{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A surface that is used during DND.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Interfaces.DragSurface
    ( 

-- * Exported types
    DragSurface(..)                         ,
    IsDragSurface                           ,
    toDragSurface                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Surface#g:method:beep"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [createCairoContext]("GI.Gdk.Objects.Surface#g:method:createCairoContext"), [createGlContext]("GI.Gdk.Objects.Surface#g:method:createGlContext"), [createSimilarSurface]("GI.Gdk.Objects.Surface#g:method:createSimilarSurface"), [createVulkanContext]("GI.Gdk.Objects.Surface#g:method:createVulkanContext"), [destroy]("GI.Gdk.Objects.Surface#g:method:destroy"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hide]("GI.Gdk.Objects.Surface#g:method:hide"), [isDestroyed]("GI.Gdk.Objects.Surface#g:method:isDestroyed"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [present]("GI.Gdk.Interfaces.DragSurface#g:method:present"), [queueRender]("GI.Gdk.Objects.Surface#g:method:queueRender"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [requestLayout]("GI.Gdk.Objects.Surface#g:method:requestLayout"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gdk.Objects.Surface#g:method:translateCoordinates"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCursor]("GI.Gdk.Objects.Surface#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceCursor]("GI.Gdk.Objects.Surface#g:method:getDeviceCursor"), [getDevicePosition]("GI.Gdk.Objects.Surface#g:method:getDevicePosition"), [getDisplay]("GI.Gdk.Objects.Surface#g:method:getDisplay"), [getFrameClock]("GI.Gdk.Objects.Surface#g:method:getFrameClock"), [getHeight]("GI.Gdk.Objects.Surface#g:method:getHeight"), [getMapped]("GI.Gdk.Objects.Surface#g:method:getMapped"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScale]("GI.Gdk.Objects.Surface#g:method:getScale"), [getScaleFactor]("GI.Gdk.Objects.Surface#g:method:getScaleFactor"), [getWidth]("GI.Gdk.Objects.Surface#g:method:getWidth").
-- 
-- ==== Setters
-- [setCursor]("GI.Gdk.Objects.Surface#g:method:setCursor"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDeviceCursor]("GI.Gdk.Objects.Surface#g:method:setDeviceCursor"), [setInputRegion]("GI.Gdk.Objects.Surface#g:method:setInputRegion"), [setOpaqueRegion]("GI.Gdk.Objects.Surface#g:method:setOpaqueRegion"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDragSurfaceMethod                ,
#endif

-- ** present #method:present#

#if defined(ENABLE_OVERLOADING)
    DragSurfacePresentMethodInfo            ,
#endif
    dragSurfacePresent                      ,




 -- * Signals


-- ** computeSize #signal:computeSize#

    DragSurfaceComputeSizeCallback          ,
#if defined(ENABLE_OVERLOADING)
    DragSurfaceComputeSizeSignalInfo        ,
#endif
    afterDragSurfaceComputeSize             ,
    onDragSurfaceComputeSize                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DragSurfaceSize as Gdk.DragSurfaceSize
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Structs.DragSurfaceSize as Gdk.DragSurfaceSize

#endif

-- interface DragSurface 
-- | Memory-managed wrapper type.
newtype DragSurface = DragSurface (SP.ManagedPtr DragSurface)
    deriving (Eq)

instance SP.ManagedPtrNewtype DragSurface where
    toManagedPtr (DragSurface p) = p

foreign import ccall "gdk_drag_surface_get_type"
    c_gdk_drag_surface_get_type :: IO B.Types.GType

instance B.Types.TypedObject DragSurface where
    glibType = c_gdk_drag_surface_get_type

instance B.Types.GObject DragSurface

-- | Type class for types which can be safely cast to t'DragSurface', for instance with `toDragSurface`.
class (SP.GObject o, O.IsDescendantOf DragSurface o) => IsDragSurface o
instance (SP.GObject o, O.IsDescendantOf DragSurface o) => IsDragSurface o

instance O.HasParentTypes DragSurface
type instance O.ParentTypes DragSurface = '[GObject.Object.Object, Gdk.Surface.Surface]

-- | Cast to t'DragSurface', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDragSurface :: (MIO.MonadIO m, IsDragSurface o) => o -> m DragSurface
toDragSurface = MIO.liftIO . B.ManagedPtr.unsafeCastTo DragSurface

-- | Convert t'DragSurface' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DragSurface) where
    gvalueGType_ = c_gdk_drag_surface_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DragSurface)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DragSurface)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DragSurface ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DragSurface
type instance O.AttributeList DragSurface = DragSurfaceAttributeList
type DragSurfaceAttributeList = ('[ '("cursor", Gdk.Surface.SurfaceCursorPropertyInfo), '("display", Gdk.Surface.SurfaceDisplayPropertyInfo), '("frameClock", Gdk.Surface.SurfaceFrameClockPropertyInfo), '("height", Gdk.Surface.SurfaceHeightPropertyInfo), '("mapped", Gdk.Surface.SurfaceMappedPropertyInfo), '("scale", Gdk.Surface.SurfaceScalePropertyInfo), '("scaleFactor", Gdk.Surface.SurfaceScaleFactorPropertyInfo), '("width", Gdk.Surface.SurfaceWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDragSurfaceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDragSurfaceMethod "beep" o = Gdk.Surface.SurfaceBeepMethodInfo
    ResolveDragSurfaceMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDragSurfaceMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDragSurfaceMethod "createCairoContext" o = Gdk.Surface.SurfaceCreateCairoContextMethodInfo
    ResolveDragSurfaceMethod "createGlContext" o = Gdk.Surface.SurfaceCreateGlContextMethodInfo
    ResolveDragSurfaceMethod "createSimilarSurface" o = Gdk.Surface.SurfaceCreateSimilarSurfaceMethodInfo
    ResolveDragSurfaceMethod "createVulkanContext" o = Gdk.Surface.SurfaceCreateVulkanContextMethodInfo
    ResolveDragSurfaceMethod "destroy" o = Gdk.Surface.SurfaceDestroyMethodInfo
    ResolveDragSurfaceMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDragSurfaceMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDragSurfaceMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDragSurfaceMethod "hide" o = Gdk.Surface.SurfaceHideMethodInfo
    ResolveDragSurfaceMethod "isDestroyed" o = Gdk.Surface.SurfaceIsDestroyedMethodInfo
    ResolveDragSurfaceMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDragSurfaceMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDragSurfaceMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDragSurfaceMethod "present" o = DragSurfacePresentMethodInfo
    ResolveDragSurfaceMethod "queueRender" o = Gdk.Surface.SurfaceQueueRenderMethodInfo
    ResolveDragSurfaceMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDragSurfaceMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDragSurfaceMethod "requestLayout" o = Gdk.Surface.SurfaceRequestLayoutMethodInfo
    ResolveDragSurfaceMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDragSurfaceMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDragSurfaceMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDragSurfaceMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDragSurfaceMethod "translateCoordinates" o = Gdk.Surface.SurfaceTranslateCoordinatesMethodInfo
    ResolveDragSurfaceMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDragSurfaceMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDragSurfaceMethod "getCursor" o = Gdk.Surface.SurfaceGetCursorMethodInfo
    ResolveDragSurfaceMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDragSurfaceMethod "getDeviceCursor" o = Gdk.Surface.SurfaceGetDeviceCursorMethodInfo
    ResolveDragSurfaceMethod "getDevicePosition" o = Gdk.Surface.SurfaceGetDevicePositionMethodInfo
    ResolveDragSurfaceMethod "getDisplay" o = Gdk.Surface.SurfaceGetDisplayMethodInfo
    ResolveDragSurfaceMethod "getFrameClock" o = Gdk.Surface.SurfaceGetFrameClockMethodInfo
    ResolveDragSurfaceMethod "getHeight" o = Gdk.Surface.SurfaceGetHeightMethodInfo
    ResolveDragSurfaceMethod "getMapped" o = Gdk.Surface.SurfaceGetMappedMethodInfo
    ResolveDragSurfaceMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDragSurfaceMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDragSurfaceMethod "getScale" o = Gdk.Surface.SurfaceGetScaleMethodInfo
    ResolveDragSurfaceMethod "getScaleFactor" o = Gdk.Surface.SurfaceGetScaleFactorMethodInfo
    ResolveDragSurfaceMethod "getWidth" o = Gdk.Surface.SurfaceGetWidthMethodInfo
    ResolveDragSurfaceMethod "setCursor" o = Gdk.Surface.SurfaceSetCursorMethodInfo
    ResolveDragSurfaceMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDragSurfaceMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDragSurfaceMethod "setDeviceCursor" o = Gdk.Surface.SurfaceSetDeviceCursorMethodInfo
    ResolveDragSurfaceMethod "setInputRegion" o = Gdk.Surface.SurfaceSetInputRegionMethodInfo
    ResolveDragSurfaceMethod "setOpaqueRegion" o = Gdk.Surface.SurfaceSetOpaqueRegionMethodInfo
    ResolveDragSurfaceMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDragSurfaceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDragSurfaceMethod t DragSurface, O.OverloadedMethod info DragSurface p) => OL.IsLabel t (DragSurface -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDragSurfaceMethod t DragSurface, O.OverloadedMethod info DragSurface p, R.HasField t DragSurface p) => R.HasField t DragSurface p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDragSurfaceMethod t DragSurface, O.OverloadedMethodInfo info DragSurface) => OL.IsLabel t (O.MethodProxy info DragSurface) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method DragSurface::present
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "drag_surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragSurface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkDragSurface` to show"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the unconstrained drag_surface width to layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the unconstrained drag_surface height to layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drag_surface_present" gdk_drag_surface_present :: 
    Ptr DragSurface ->                      -- drag_surface : TInterface (Name {namespace = "Gdk", name = "DragSurface"})
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    IO CInt

-- | Present /@dragSurface@/.
dragSurfacePresent ::
    (B.CallStack.HasCallStack, MonadIO m, IsDragSurface a) =>
    a
    -- ^ /@dragSurface@/: the @GdkDragSurface@ to show
    -> Int32
    -- ^ /@width@/: the unconstrained drag_surface width to layout
    -> Int32
    -- ^ /@height@/: the unconstrained drag_surface height to layout
    -> m Bool
    -- ^ __Returns:__ 'P.False' if it failed to be presented, otherwise 'P.True'.
dragSurfacePresent dragSurface width height = liftIO $ do
    dragSurface' <- unsafeManagedPtrCastPtr dragSurface
    result <- gdk_drag_surface_present dragSurface' width height
    let result' = (/= 0) result
    touchManagedPtr dragSurface
    return result'

#if defined(ENABLE_OVERLOADING)
data DragSurfacePresentMethodInfo
instance (signature ~ (Int32 -> Int32 -> m Bool), MonadIO m, IsDragSurface a) => O.OverloadedMethod DragSurfacePresentMethodInfo a signature where
    overloadedMethod = dragSurfacePresent

instance O.OverloadedMethodInfo DragSurfacePresentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.DragSurface.dragSurfacePresent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-DragSurface.html#v:dragSurfacePresent"
        })


#endif

-- signal DragSurface::compute-size
-- | Emitted when the size for the surface needs to be computed, when it is
-- present.
-- 
-- This signal will normally be emitted during the native surface layout
-- cycle when the surface size needs to be recomputed.
-- 
-- It is the responsibility of the drag surface user to handle this signal
-- and compute the desired size of the surface, storing the computed size
-- in the t'GI.Gdk.Structs.DragSurfaceSize.DragSurfaceSize' object that is passed to the signal
-- handler, using 'GI.Gdk.Structs.DragSurfaceSize.dragSurfaceSizeSetSize'.
-- 
-- Failing to set a size so will result in an arbitrary size being used as
-- a result.
-- 
-- /Since: 4.12/
type DragSurfaceComputeSizeCallback =
    Gdk.DragSurfaceSize.DragSurfaceSize
    -- ^ /@size@/: the size of the drag surface
    -> IO ()

type C_DragSurfaceComputeSizeCallback =
    Ptr DragSurface ->                      -- object
    Ptr Gdk.DragSurfaceSize.DragSurfaceSize ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DragSurfaceComputeSizeCallback`.
foreign import ccall "wrapper"
    mk_DragSurfaceComputeSizeCallback :: C_DragSurfaceComputeSizeCallback -> IO (FunPtr C_DragSurfaceComputeSizeCallback)

wrap_DragSurfaceComputeSizeCallback :: 
    GObject a => (a -> DragSurfaceComputeSizeCallback) ->
    C_DragSurfaceComputeSizeCallback
wrap_DragSurfaceComputeSizeCallback gi'cb gi'selfPtr size _ = do
    size' <- (newPtr Gdk.DragSurfaceSize.DragSurfaceSize) size
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  size'


-- | Connect a signal handler for the [computeSize](#signal:computeSize) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dragSurface #computeSize callback
-- @
-- 
-- 
onDragSurfaceComputeSize :: (IsDragSurface a, MonadIO m) => a -> ((?self :: a) => DragSurfaceComputeSizeCallback) -> m SignalHandlerId
onDragSurfaceComputeSize obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragSurfaceComputeSizeCallback wrapped
    wrapped'' <- mk_DragSurfaceComputeSizeCallback wrapped'
    connectSignalFunPtr obj "compute-size" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [computeSize](#signal:computeSize) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dragSurface #computeSize callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDragSurfaceComputeSize :: (IsDragSurface a, MonadIO m) => a -> ((?self :: a) => DragSurfaceComputeSizeCallback) -> m SignalHandlerId
afterDragSurfaceComputeSize obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DragSurfaceComputeSizeCallback wrapped
    wrapped'' <- mk_DragSurfaceComputeSizeCallback wrapped'
    connectSignalFunPtr obj "compute-size" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DragSurfaceComputeSizeSignalInfo
instance SignalInfo DragSurfaceComputeSizeSignalInfo where
    type HaskellCallbackType DragSurfaceComputeSizeSignalInfo = DragSurfaceComputeSizeCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DragSurfaceComputeSizeCallback cb
        cb'' <- mk_DragSurfaceComputeSizeCallback cb'
        connectSignalFunPtr obj "compute-size" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Interfaces.DragSurface::compute-size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Interfaces-DragSurface.html#g:signal:computeSize"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DragSurface = DragSurfaceSignalList
type DragSurfaceSignalList = ('[ '("computeSize", DragSurfaceComputeSizeSignalInfo), '("enterMonitor", Gdk.Surface.SurfaceEnterMonitorSignalInfo), '("event", Gdk.Surface.SurfaceEventSignalInfo), '("layout", Gdk.Surface.SurfaceLayoutSignalInfo), '("leaveMonitor", Gdk.Surface.SurfaceLeaveMonitorSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("render", Gdk.Surface.SurfaceRenderSignalInfo)] :: [(Symbol, DK.Type)])

#endif


