/* Welcome.c generated by valac 0.56.17, the Vala compiler
 * generated from Welcome.vala, do not modify */

/*
 * Copyright 2018–2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011–2013 Maxwell Barvian <maxwell@elementaryos.org>
 * Copyright 2011–2013 Victor Eduardo <victoreduardm@gmal.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_WELCOME_0_PROPERTY,
	GRANITE_WIDGETS_WELCOME_TITLE_PROPERTY,
	GRANITE_WIDGETS_WELCOME_SUBTITLE_PROPERTY,
	GRANITE_WIDGETS_WELCOME_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_welcome_properties[GRANITE_WIDGETS_WELCOME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
enum  {
	GRANITE_WIDGETS_WELCOME_ACTIVATED_SIGNAL,
	GRANITE_WIDGETS_WELCOME_NUM_SIGNALS
};
static guint granite_widgets_welcome_signals[GRANITE_WIDGETS_WELCOME_NUM_SIGNALS] = {0};

struct _GraniteWidgetsWelcomePrivate {
	GtkLabel* title_label;
	GtkLabel* subtitle_label;
};

struct _Block14Data {
	int _ref_count_;
	GraniteWidgetsWelcome* self;
	GraniteWidgetsWelcomeButton* button;
};

static gint GraniteWidgetsWelcome_private_offset;
static gpointer granite_widgets_welcome_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void __lambda100_ (Block14Data* _data14_);
static void ___lambda100__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static GObject * granite_widgets_welcome_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void granite_widgets_welcome_finalize (GObject * obj);
static GType granite_widgets_welcome_get_type_once (void);
static void _vala_granite_widgets_welcome_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_granite_widgets_welcome_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
granite_widgets_welcome_get_instance_private (GraniteWidgetsWelcome* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsWelcome_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

const gchar*
granite_widgets_welcome_get_title (GraniteWidgetsWelcome* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_welcome_set_title (GraniteWidgetsWelcome* self,
                                   const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->title_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_welcome_properties[GRANITE_WIDGETS_WELCOME_TITLE_PROPERTY]);
}

const gchar*
granite_widgets_welcome_get_subtitle (GraniteWidgetsWelcome* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->subtitle_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_widgets_welcome_set_subtitle (GraniteWidgetsWelcome* self,
                                      const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subtitle_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_welcome_properties[GRANITE_WIDGETS_WELCOME_SUBTITLE_PROPERTY]);
}

/**
     * Makes new Welcome Page
     *
     * @param title_text main title for new Welcome Page
     * @param subtitle_text subtitle text for new Welcome Page
     */
GraniteWidgetsWelcome*
granite_widgets_welcome_construct (GType object_type,
                                   const gchar* title_text,
                                   const gchar* subtitle_text)
{
	GraniteWidgetsWelcome * self = NULL;
	g_return_val_if_fail (title_text != NULL, NULL);
	g_return_val_if_fail (subtitle_text != NULL, NULL);
	self = (GraniteWidgetsWelcome*) g_object_new (object_type, "title", title_text, "subtitle", subtitle_text, NULL);
	return self;
}

GraniteWidgetsWelcome*
granite_widgets_welcome_new (const gchar* title_text,
                             const gchar* subtitle_text)
{
	return granite_widgets_welcome_construct (GRANITE_WIDGETS_TYPE_WELCOME, title_text, subtitle_text);
}

/**
      * Sets action item of given index's visiblity
      *
      * @param index index of action item to be changed
      * @param val value deteriming whether the action item is visible
      */
void
granite_widgets_welcome_set_item_visible (GraniteWidgetsWelcome* self,
                                          guint index,
                                          gboolean val)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->children;
	if (index < g_list_length (_tmp1_)) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->children;
		_tmp3_ = g_list_nth_data (_tmp2_, index);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE ((GtkButton*) _tmp3_, gtk_widget_get_type ());
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		GList* _tmp6_;
		gconstpointer _tmp7_;
		_tmp4_ = self->children;
		_tmp5_ = g_list_nth_data (_tmp4_, index);
		gtk_widget_set_no_show_all ((GtkWidget*) ((GtkButton*) _tmp5_), !val);
		_tmp6_ = self->children;
		_tmp7_ = g_list_nth_data (_tmp6_, index);
		gtk_widget_set_visible ((GtkWidget*) ((GtkButton*) _tmp7_), val);
	}
}

/**
      * Removes action item of given index
      *
      * @param index index of action item to remove
      */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
granite_widgets_welcome_remove_item (GraniteWidgetsWelcome* self,
                                     guint index)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->children;
	if (index < g_list_length (_tmp1_)) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->children;
		_tmp3_ = g_list_nth_data (_tmp2_, index);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE ((GtkButton*) _tmp3_, gtk_widget_get_type ());
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkButton* item = NULL;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		_tmp4_ = self->children;
		_tmp5_ = g_list_nth_data (_tmp4_, index);
		_tmp6_ = _g_object_ref0 ((GtkButton*) _tmp5_);
		item = _tmp6_;
		_tmp7_ = item;
		gtk_widget_destroy ((GtkWidget*) _tmp7_);
		_tmp8_ = item;
		self->children = vala_g_list_remove_full (self->children, _tmp8_, _g_object_unref0_);
		_g_object_unref0 (item);
	}
}

/**
      * Sets action item of given index sensitivity
      *
      * @param index index of action item to be changed
      * @param val value deteriming whether the action item is senstitive
      */
void
granite_widgets_welcome_set_item_sensitivity (GraniteWidgetsWelcome* self,
                                              guint index,
                                              gboolean val)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->children;
	if (index < g_list_length (_tmp1_)) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->children;
		_tmp3_ = g_list_nth_data (_tmp2_, index);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE ((GtkButton*) _tmp3_, gtk_widget_get_type ());
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp4_;
		gconstpointer _tmp5_;
		_tmp4_ = self->children;
		_tmp5_ = g_list_nth_data (_tmp4_, index);
		gtk_widget_set_sensitive ((GtkWidget*) ((GtkButton*) _tmp5_), val);
	}
}

/**
      * Appends new action item to welcome page with a {@link Gtk.Image.from_icon_name}
      *
      * @param icon_name named icon to be set as icon for action item
      * @param option_text text to be set as the title for action item. It should use Title Case.
      * @param description_text text to be set as description for action item. It should use sentence case.
      * @return index of new item
      */
gint
granite_widgets_welcome_append (GraniteWidgetsWelcome* self,
                                const gchar* icon_name,
                                const gchar* option_text,
                                const gchar* description_text)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (icon_name != NULL, 0);
	g_return_val_if_fail (option_text != NULL, 0);
	g_return_val_if_fail (description_text != NULL, 0);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	g_object_set (image, "use-fallback", TRUE, NULL);
	result = granite_widgets_welcome_append_with_image (self, image, option_text, description_text);
	_g_object_unref0 (image);
	return result;
}

/**
      * Appends new action item to welcome page with a {link Gdk.Pixbuf} icon
      *
      * @param pixbuf pixbuf to be set as icon for action item
      * @param option_text text to be set as the header for action item
      * @param description_text text to be set as description for action item
      * @return index of new item
      */
gint
granite_widgets_welcome_append_with_pixbuf (GraniteWidgetsWelcome* self,
                                            GdkPixbuf* pixbuf,
                                            const gchar* option_text,
                                            const gchar* description_text)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (option_text != NULL, 0);
	g_return_val_if_fail (description_text != NULL, 0);
	_tmp0_ = (GtkImage*) gtk_image_new_from_pixbuf (pixbuf);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	result = granite_widgets_welcome_append_with_image (self, image, option_text, description_text);
	_g_object_unref0 (image);
	return result;
}

/**
      * Appends new action item to welcome page with a {@link Gtk.Image} icon
      *
      * @param image image to be set as icon for action item
      * @param option_text text to be set as the header for action item
      * @param description_text text to be set as description for action item
      * @return index of new item
      */
static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		GraniteWidgetsWelcome* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->button);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda100_ (Block14Data* _data14_)
{
	GraniteWidgetsWelcome* self;
	gint index = 0;
	GList* _tmp0_;
	self = _data14_->self;
	_tmp0_ = self->children;
	index = g_list_index (_tmp0_, (GtkButton*) _data14_->button);
	g_signal_emit (self, granite_widgets_welcome_signals[GRANITE_WIDGETS_WELCOME_ACTIVATED_SIGNAL], 0, index);
}

static void
___lambda100__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda100_ (self);
}

gint
granite_widgets_welcome_append_with_image (GraniteWidgetsWelcome* self,
                                           GtkImage* image,
                                           const gchar* option_text,
                                           const gchar* description_text)
{
	Block14Data* _data14_;
	GraniteWidgetsWelcomeButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkGrid* _tmp2_;
	GList* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (option_text != NULL, 0);
	g_return_val_if_fail (description_text != NULL, 0);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = granite_widgets_welcome_button_new (image, option_text, description_text);
	g_object_ref_sink (_tmp0_);
	_data14_->button = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GtkButton*) _data14_->button);
	self->children = g_list_append (self->children, _tmp1_);
	_tmp2_ = self->options;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _data14_->button);
	g_signal_connect_data ((GtkButton*) _data14_->button, "clicked", (GCallback) ___lambda100__gtk_button_clicked, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp3_ = self->children;
	result = g_list_index (_tmp3_, (GtkButton*) _data14_->button);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return result;
}

/**
     * Returns a welcome button by index
     *
     * @param index index of action item to be returned
     * @return welcome button at //index//, or //null// if //index// is invalid.
     * @since 0.3
     */
GraniteWidgetsWelcomeButton*
granite_widgets_welcome_get_button_from_index (GraniteWidgetsWelcome* self,
                                               gint index)
{
	gboolean _tmp0_ = FALSE;
	GraniteWidgetsWelcomeButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (index >= 0) {
		GList* _tmp1_;
		_tmp1_ = self->children;
		_tmp0_ = ((guint) index) < g_list_length (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp2_;
		gconstpointer _tmp3_;
		GtkButton* _tmp4_;
		GraniteWidgetsWelcomeButton* _tmp5_;
		_tmp2_ = self->children;
		_tmp3_ = g_list_nth_data (_tmp2_, (guint) index);
		_tmp4_ = (GtkButton*) _tmp3_;
		_tmp5_ = _g_object_ref0 (GRANITE_WIDGETS_IS_WELCOME_BUTTON (_tmp4_) ? ((GraniteWidgetsWelcomeButton*) _tmp4_) : NULL);
		result = _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

static GObject *
granite_widgets_welcome_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsWelcome * self;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkStyleContext* subtitle_label_context = NULL;
	GtkLabel* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkGrid* _tmp17_;
	GtkGrid* _tmp18_;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* content = NULL;
	GtkGrid* _tmp22_;
	GtkGrid* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkLabel* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkGrid* _tmp33_;
	parent_class = G_OBJECT_CLASS (granite_widgets_welcome_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_WELCOME, GraniteWidgetsWelcome);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GTK_STYLE_CLASS_VIEW);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, GRANITE_STYLE_CLASS_WELCOME);
	_tmp2_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp2_;
	_tmp3_ = self->priv->title_label;
	gtk_label_set_justify (_tmp3_, GTK_JUSTIFY_CENTER);
	_tmp4_ = self->priv->title_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->title_label;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, GRANITE_STYLE_CLASS_H1_LABEL);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->subtitle_label);
	self->priv->subtitle_label = _tmp7_;
	_tmp8_ = self->priv->subtitle_label;
	gtk_label_set_justify (_tmp8_, GTK_JUSTIFY_CENTER);
	_tmp9_ = self->priv->subtitle_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = self->priv->subtitle_label;
	g_object_set (_tmp10_, "wrap", TRUE, NULL);
	_tmp11_ = self->priv->subtitle_label;
	g_object_set (_tmp11_, "wrap-mode", PANGO_WRAP_WORD, NULL);
	_tmp12_ = self->priv->subtitle_label;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	subtitle_label_context = _tmp14_;
	_tmp15_ = subtitle_label_context;
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp16_ = subtitle_label_context;
	gtk_style_context_add_class (_tmp16_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->options);
	self->options = _tmp17_;
	_tmp18_ = self->options;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp18_, GTK_ORIENTATION_VERTICAL);
	_tmp19_ = self->options;
	gtk_grid_set_row_spacing (_tmp19_, 12);
	_tmp20_ = self->options;
	gtk_widget_set_halign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	_tmp21_ = self->options;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp21_, 24);
	_tmp22_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp22_);
	content = _tmp22_;
	_tmp23_ = content;
	g_object_set ((GtkWidget*) _tmp23_, "expand", TRUE, NULL);
	_tmp24_ = content;
	g_object_set ((GtkWidget*) _tmp24_, "margin", 12, NULL);
	_tmp25_ = content;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp25_, GTK_ORIENTATION_VERTICAL);
	_tmp26_ = content;
	gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	_tmp27_ = content;
	_tmp28_ = self->priv->title_label;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = content;
	_tmp30_ = self->priv->subtitle_label;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = content;
	_tmp32_ = self->options;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = content;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_g_object_unref0 (content);
	_g_object_unref0 (subtitle_label_context);
	return obj;
}

static void
granite_widgets_welcome_class_init (GraniteWidgetsWelcomeClass * klass,
                                    gpointer klass_data)
{
	granite_widgets_welcome_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsWelcome_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_welcome_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_welcome_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_welcome_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_welcome_finalize;
	/**
	     * This is the title of the welcome widget. It should use Title Case.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_WELCOME_TITLE_PROPERTY, granite_widgets_welcome_properties[GRANITE_WIDGETS_WELCOME_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * This is the subtitle of the welcome widget. It should use sentence case.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_WELCOME_SUBTITLE_PROPERTY, granite_widgets_welcome_properties[GRANITE_WIDGETS_WELCOME_SUBTITLE_PROPERTY] = g_param_spec_string ("subtitle", "subtitle", "subtitle", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	granite_widgets_welcome_signals[GRANITE_WIDGETS_WELCOME_ACTIVATED_SIGNAL] = g_signal_new ("activated", GRANITE_WIDGETS_TYPE_WELCOME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
granite_widgets_welcome_instance_init (GraniteWidgetsWelcome * self,
                                       gpointer klass)
{
	self->priv = granite_widgets_welcome_get_instance_private (self);
	self->children = NULL;
}

static void
granite_widgets_welcome_finalize (GObject * obj)
{
	GraniteWidgetsWelcome * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_WELCOME, GraniteWidgetsWelcome);
	(self->children == NULL) ? NULL : (self->children = (_g_list_free__g_object_unref0_ (self->children), NULL));
	_g_object_unref0 (self->options);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->subtitle_label);
	G_OBJECT_CLASS (granite_widgets_welcome_parent_class)->finalize (obj);
}

/**
 * This class is for making a first-launch screen easily
 *
 * It can be used to create a list of one-time action items that need to be executed in order to setup the app.
 *
 * Granite.Widgets.Welcome will get the style class `welcome`.
 *
 * {{../doc/images/Welcome.png}}
 *
 * ''Example''<<BR>>
 * {{{
 * public class WelcomeView : Gtk.Grid {
 *     construct {
 *         var welcome = new Granite.Widgets.Welcome ("Granite Demo", "This is a demo of the Granite library.");
 *         welcome.append ("text-x-vala", "Visit Valadoc", "The canonical source for Vala API references.");
 *         welcome.append ("text-x-source", "Get Granite Source", "Granite's source code is hosted on GitHub.");
 *
 *         add (welcome);
 *
 *         welcome.activated.connect ((index) => {
 *             switch (index) {
 *                 case 0:
 *                     try {
 *                         AppInfo.launch_default_for_uri ("https://valadoc.org/granite/Granite.html", null);
 *                     } catch (Error e) {
 *                         warning (e.message);
 *                     }
 *
 *                     break;
 *                 case 1:
 *                     try {
 *                         AppInfo.launch_default_for_uri ("https://github.com/elementary/granite", null);
 *                     } catch (Error e) {
 *                         warning (e.message);
 *                     }
 *
 *                     break;
 *             }
 *         });
 *     }
 * }
 * }}}
 *
 */
static GType
granite_widgets_welcome_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsWelcomeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_welcome_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsWelcome), 0, (GInstanceInitFunc) granite_widgets_welcome_instance_init, NULL };
	GType granite_widgets_welcome_type_id;
	granite_widgets_welcome_type_id = g_type_register_static (gtk_event_box_get_type (), "GraniteWidgetsWelcome", &g_define_type_info, 0);
	GraniteWidgetsWelcome_private_offset = g_type_add_instance_private (granite_widgets_welcome_type_id, sizeof (GraniteWidgetsWelcomePrivate));
	return granite_widgets_welcome_type_id;
}

GType
granite_widgets_welcome_get_type (void)
{
	static volatile gsize granite_widgets_welcome_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_welcome_type_id__once)) {
		GType granite_widgets_welcome_type_id;
		granite_widgets_welcome_type_id = granite_widgets_welcome_get_type_once ();
		g_once_init_leave (&granite_widgets_welcome_type_id__once, granite_widgets_welcome_type_id);
	}
	return granite_widgets_welcome_type_id__once;
}

static void
_vala_granite_widgets_welcome_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GraniteWidgetsWelcome * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_WELCOME, GraniteWidgetsWelcome);
	switch (property_id) {
		case GRANITE_WIDGETS_WELCOME_TITLE_PROPERTY:
		g_value_set_string (value, granite_widgets_welcome_get_title (self));
		break;
		case GRANITE_WIDGETS_WELCOME_SUBTITLE_PROPERTY:
		g_value_set_string (value, granite_widgets_welcome_get_subtitle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_welcome_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GraniteWidgetsWelcome * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_WELCOME, GraniteWidgetsWelcome);
	switch (property_id) {
		case GRANITE_WIDGETS_WELCOME_TITLE_PROPERTY:
		granite_widgets_welcome_set_title (self, g_value_get_string (value));
		break;
		case GRANITE_WIDGETS_WELCOME_SUBTITLE_PROPERTY:
		granite_widgets_welcome_set_subtitle (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

