/* IBreakTimer.c generated by valac 0.56.17, the Vala compiler
 * generated from IBreakTimer.vala, do not modify */

/* IBreakTimer.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "common.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy BreakTimerCommonIBreakTimerProxy;
typedef GDBusProxyClass BreakTimerCommonIBreakTimerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

static GType break_timer_common_ibreak_timer_get_type_once (void);
static void break_timer_common_ibreak_timer_proxy_g_signal (GDBusProxy* proxy,
                                                     const gchar* sender_name,
                                                     const gchar* signal_name,
                                                     GVariant* parameters);
static gchar** break_timer_common_ibreak_timer_proxy_get_current_active_break (BreakTimerCommonIBreakTimer* self,
                                                                        gint* result_length1,
                                                                        GError** error);
static gchar** break_timer_common_ibreak_timer_proxy_get_break_ids (BreakTimerCommonIBreakTimer* self,
                                                             gint* result_length1,
                                                             GError** error);
static gchar** break_timer_common_ibreak_timer_proxy_get_status_messages (BreakTimerCommonIBreakTimer* self,
                                                                   gint* result_length1,
                                                                   GError** error);
static void break_timer_common_ibreak_timer_proxy_activate_break (BreakTimerCommonIBreakTimer* self,
                                                           const gchar* break_id,
                                                           GError** error);
static void break_timer_common_ibreak_timer_proxy_break_timer_common_ibreak_timer_interface_init (BreakTimerCommonIBreakTimerIface* iface);
static void _dbus_break_timer_common_ibreak_timer_get_current_active_break (BreakTimerCommonIBreakTimer* self,
                                                                     GVariant* _parameters_,
                                                                     GDBusMethodInvocation* invocation);
static void _dbus_break_timer_common_ibreak_timer_get_break_ids (BreakTimerCommonIBreakTimer* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_break_timer_common_ibreak_timer_get_status_messages (BreakTimerCommonIBreakTimer* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation);
static void _dbus_break_timer_common_ibreak_timer_activate_break (BreakTimerCommonIBreakTimer* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void break_timer_common_ibreak_timer_dbus_interface_method_call (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* method_name,
                                                                 GVariant* parameters,
                                                                 GDBusMethodInvocation* invocation,
                                                                 gpointer user_data);
static GVariant* break_timer_common_ibreak_timer_dbus_interface_get_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GError** error,
                                                                       gpointer user_data);
static gboolean break_timer_common_ibreak_timer_dbus_interface_set_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GVariant* value,
                                                                      GError** error,
                                                                      gpointer user_data);
static void _break_timer_common_ibreak_timer_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _break_timer_common_ibreak_timer_dbus_arg_info_get_current_active_break_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_get_current_active_break_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_get_current_active_break_out[] = {&_break_timer_common_ibreak_timer_dbus_arg_info_get_current_active_break_result, NULL};
static const GDBusMethodInfo _break_timer_common_ibreak_timer_dbus_method_info_get_current_active_break = {-1, "GetCurrentActiveBreak", (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_get_current_active_break_in), (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_get_current_active_break_out), NULL};
static const GDBusArgInfo _break_timer_common_ibreak_timer_dbus_arg_info_get_break_ids_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_get_break_ids_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_get_break_ids_out[] = {&_break_timer_common_ibreak_timer_dbus_arg_info_get_break_ids_result, NULL};
static const GDBusMethodInfo _break_timer_common_ibreak_timer_dbus_method_info_get_break_ids = {-1, "GetBreakIds", (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_get_break_ids_in), (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_get_break_ids_out), NULL};
static const GDBusArgInfo _break_timer_common_ibreak_timer_dbus_arg_info_get_status_messages_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_get_status_messages_in[] = {NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_get_status_messages_out[] = {&_break_timer_common_ibreak_timer_dbus_arg_info_get_status_messages_result, NULL};
static const GDBusMethodInfo _break_timer_common_ibreak_timer_dbus_method_info_get_status_messages = {-1, "GetStatusMessages", (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_get_status_messages_in), (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_get_status_messages_out), NULL};
static const GDBusArgInfo _break_timer_common_ibreak_timer_dbus_arg_info_activate_break_break_id = {-1, "break_id", "s", NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_activate_break_in[] = {&_break_timer_common_ibreak_timer_dbus_arg_info_activate_break_break_id, NULL};
static const GDBusArgInfo * const _break_timer_common_ibreak_timer_dbus_arg_info_activate_break_out[] = {NULL};
static const GDBusMethodInfo _break_timer_common_ibreak_timer_dbus_method_info_activate_break = {-1, "ActivateBreak", (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_activate_break_in), (GDBusArgInfo **) (&_break_timer_common_ibreak_timer_dbus_arg_info_activate_break_out), NULL};
static const GDBusMethodInfo * const _break_timer_common_ibreak_timer_dbus_method_info[] = {&_break_timer_common_ibreak_timer_dbus_method_info_get_current_active_break, &_break_timer_common_ibreak_timer_dbus_method_info_get_break_ids, &_break_timer_common_ibreak_timer_dbus_method_info_get_status_messages, &_break_timer_common_ibreak_timer_dbus_method_info_activate_break, NULL};
static const GDBusSignalInfo * const _break_timer_common_ibreak_timer_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _break_timer_common_ibreak_timer_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _break_timer_common_ibreak_timer_dbus_interface_info = {-1, "org.gnome.BreakTimer", (GDBusMethodInfo **) (&_break_timer_common_ibreak_timer_dbus_method_info), (GDBusSignalInfo **) (&_break_timer_common_ibreak_timer_dbus_signal_info), (GDBusPropertyInfo **) (&_break_timer_common_ibreak_timer_dbus_property_info), NULL};
static const GDBusInterfaceVTable _break_timer_common_ibreak_timer_dbus_interface_vtable = {break_timer_common_ibreak_timer_dbus_interface_method_call, break_timer_common_ibreak_timer_dbus_interface_get_property, break_timer_common_ibreak_timer_dbus_interface_set_property};

/** Returns the ID of the break that is currently focused and activated, if any. */
gchar**
break_timer_common_ibreak_timer_get_current_active_break (BreakTimerCommonIBreakTimer* self,
                                                          gint* result_length1,
                                                          GError** error)
{
	BreakTimerCommonIBreakTimerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BREAK_TIMER_COMMON_IBREAK_TIMER_GET_INTERFACE (self);
	if (_iface_->get_current_active_break) {
		return _iface_->get_current_active_break (self, result_length1, error);
	}
	return NULL;
}

/** Returns a list of breaks that are currently known to the break daemon. */
gchar**
break_timer_common_ibreak_timer_get_break_ids (BreakTimerCommonIBreakTimer* self,
                                               gint* result_length1,
                                               GError** error)
{
	BreakTimerCommonIBreakTimerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BREAK_TIMER_COMMON_IBREAK_TIMER_GET_INTERFACE (self);
	if (_iface_->get_break_ids) {
		return _iface_->get_break_ids (self, result_length1, error);
	}
	return NULL;
}

/** Returns a list of helpful status messages for each break, for debugging. */
gchar**
break_timer_common_ibreak_timer_get_status_messages (BreakTimerCommonIBreakTimer* self,
                                                     gint* result_length1,
                                                     GError** error)
{
	BreakTimerCommonIBreakTimerIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BREAK_TIMER_COMMON_IBREAK_TIMER_GET_INTERFACE (self);
	if (_iface_->get_status_messages) {
		return _iface_->get_status_messages (self, result_length1, error);
	}
	return NULL;
}

/** Activate the specified break immediately, regardless of the usual activation conditions. */
void
break_timer_common_ibreak_timer_activate_break (BreakTimerCommonIBreakTimer* self,
                                                const gchar* break_id,
                                                GError** error)
{
	BreakTimerCommonIBreakTimerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BREAK_TIMER_COMMON_IBREAK_TIMER_GET_INTERFACE (self);
	if (_iface_->activate_break) {
		_iface_->activate_break (self, break_id, error);
	}
}

static void
break_timer_common_ibreak_timer_default_init (BreakTimerCommonIBreakTimerIface * iface,
                                              gpointer iface_data)
{
}

static GType
break_timer_common_ibreak_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerCommonIBreakTimerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_common_ibreak_timer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType break_timer_common_ibreak_timer_type_id;
	break_timer_common_ibreak_timer_type_id = g_type_register_static (G_TYPE_INTERFACE, "BreakTimerCommonIBreakTimer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (break_timer_common_ibreak_timer_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (break_timer_common_ibreak_timer_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) break_timer_common_ibreak_timer_proxy_get_type);
	g_type_set_qdata (break_timer_common_ibreak_timer_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.BreakTimer");
	g_type_set_qdata (break_timer_common_ibreak_timer_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_break_timer_common_ibreak_timer_dbus_interface_info));
	g_type_set_qdata (break_timer_common_ibreak_timer_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) break_timer_common_ibreak_timer_register_object);
	return break_timer_common_ibreak_timer_type_id;
}

GType
break_timer_common_ibreak_timer_get_type (void)
{
	static volatile gsize break_timer_common_ibreak_timer_type_id__once = 0;
	if (g_once_init_enter (&break_timer_common_ibreak_timer_type_id__once)) {
		GType break_timer_common_ibreak_timer_type_id;
		break_timer_common_ibreak_timer_type_id = break_timer_common_ibreak_timer_get_type_once ();
		g_once_init_leave (&break_timer_common_ibreak_timer_type_id__once, break_timer_common_ibreak_timer_type_id);
	}
	return break_timer_common_ibreak_timer_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BreakTimerCommonIBreakTimerProxy, break_timer_common_ibreak_timer_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BREAK_TIMER_COMMON_TYPE_IBREAK_TIMER, break_timer_common_ibreak_timer_proxy_break_timer_common_ibreak_timer_interface_init) )
static void
break_timer_common_ibreak_timer_proxy_class_init (BreakTimerCommonIBreakTimerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = break_timer_common_ibreak_timer_proxy_g_signal;
}

static void
break_timer_common_ibreak_timer_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters)
{
}

static void
break_timer_common_ibreak_timer_proxy_init (BreakTimerCommonIBreakTimerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_break_timer_common_ibreak_timer_dbus_interface_info));
}

static gchar**
break_timer_common_ibreak_timer_proxy_get_current_active_break (BreakTimerCommonIBreakTimer* self,
                                                                gint* result_length1,
                                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length;
	gint _tmp11__size;
	gint _tmp11__length1;
	GVariantIter _tmp12_;
	GVariant* _tmp13_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.BreakTimer", "GetCurrentActiveBreak");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp10_ = g_variant_iter_next_value (&_reply_iter);
	_tmp11_ = g_new (gchar*, 5);
	_tmp11__length = 0;
	_tmp11__size = 4;
	_tmp11__length1 = 0;
	g_variant_iter_init (&_tmp12_, _tmp10_);
	for (; (_tmp13_ = g_variant_iter_next_value (&_tmp12_)) != NULL; _tmp11__length1++) {
		if (_tmp11__size == _tmp11__length) {
			_tmp11__size = 2 * _tmp11__size;
			_tmp11_ = g_renew (gchar*, _tmp11_, _tmp11__size + 1);
		}
		_tmp11_[_tmp11__length++] = g_variant_dup_string (_tmp13_, NULL);
		g_variant_unref (_tmp13_);
	}
	_result_length1 = _tmp11__length1;
	_tmp11_[_tmp11__length] = NULL;
	_result = _tmp11_;
	g_variant_unref (_tmp10_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gchar**
break_timer_common_ibreak_timer_proxy_get_break_ids (BreakTimerCommonIBreakTimer* self,
                                                     gint* result_length1,
                                                     GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length;
	gint _tmp15__size;
	gint _tmp15__length1;
	GVariantIter _tmp16_;
	GVariant* _tmp17_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.BreakTimer", "GetBreakIds");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp14_ = g_variant_iter_next_value (&_reply_iter);
	_tmp15_ = g_new (gchar*, 5);
	_tmp15__length = 0;
	_tmp15__size = 4;
	_tmp15__length1 = 0;
	g_variant_iter_init (&_tmp16_, _tmp14_);
	for (; (_tmp17_ = g_variant_iter_next_value (&_tmp16_)) != NULL; _tmp15__length1++) {
		if (_tmp15__size == _tmp15__length) {
			_tmp15__size = 2 * _tmp15__size;
			_tmp15_ = g_renew (gchar*, _tmp15_, _tmp15__size + 1);
		}
		_tmp15_[_tmp15__length++] = g_variant_dup_string (_tmp17_, NULL);
		g_variant_unref (_tmp17_);
	}
	_result_length1 = _tmp15__length1;
	_tmp15_[_tmp15__length] = NULL;
	_result = _tmp15_;
	g_variant_unref (_tmp14_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static gchar**
break_timer_common_ibreak_timer_proxy_get_status_messages (BreakTimerCommonIBreakTimer* self,
                                                           gint* result_length1,
                                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length;
	gint _tmp19__size;
	gint _tmp19__length1;
	GVariantIter _tmp20_;
	GVariant* _tmp21_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.BreakTimer", "GetStatusMessages");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp18_ = g_variant_iter_next_value (&_reply_iter);
	_tmp19_ = g_new (gchar*, 5);
	_tmp19__length = 0;
	_tmp19__size = 4;
	_tmp19__length1 = 0;
	g_variant_iter_init (&_tmp20_, _tmp18_);
	for (; (_tmp21_ = g_variant_iter_next_value (&_tmp20_)) != NULL; _tmp19__length1++) {
		if (_tmp19__size == _tmp19__length) {
			_tmp19__size = 2 * _tmp19__size;
			_tmp19_ = g_renew (gchar*, _tmp19_, _tmp19__size + 1);
		}
		_tmp19_[_tmp19__length++] = g_variant_dup_string (_tmp21_, NULL);
		g_variant_unref (_tmp21_);
	}
	_result_length1 = _tmp19__length1;
	_tmp19_[_tmp19__length] = NULL;
	_result = _tmp19_;
	g_variant_unref (_tmp18_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
break_timer_common_ibreak_timer_proxy_activate_break (BreakTimerCommonIBreakTimer* self,
                                                      const gchar* break_id,
                                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.BreakTimer", "ActivateBreak");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (break_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
break_timer_common_ibreak_timer_proxy_break_timer_common_ibreak_timer_interface_init (BreakTimerCommonIBreakTimerIface* iface)
{
	iface->get_current_active_break = break_timer_common_ibreak_timer_proxy_get_current_active_break;
	iface->get_break_ids = break_timer_common_ibreak_timer_proxy_get_break_ids;
	iface->get_status_messages = break_timer_common_ibreak_timer_proxy_get_status_messages;
	iface->activate_break = break_timer_common_ibreak_timer_proxy_activate_break;
}

static void
_dbus_break_timer_common_ibreak_timer_get_current_active_break (BreakTimerCommonIBreakTimer* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp22_;
	GVariantBuilder _tmp23_;
	gint _tmp24_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_common_ibreak_timer_get_current_active_break (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp22_ = result;
	g_variant_builder_init (&_tmp23_, G_VARIANT_TYPE ("as"));
	for (_tmp24_ = 0; _tmp24_ < result_length1; _tmp24_++) {
		g_variant_builder_add_value (&_tmp23_, g_variant_new_string (*_tmp22_));
		_tmp22_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp23_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_common_ibreak_timer_get_break_ids (BreakTimerCommonIBreakTimer* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp25_;
	GVariantBuilder _tmp26_;
	gint _tmp27_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_common_ibreak_timer_get_break_ids (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp25_ = result;
	g_variant_builder_init (&_tmp26_, G_VARIANT_TYPE ("as"));
	for (_tmp27_ = 0; _tmp27_ < result_length1; _tmp27_++) {
		g_variant_builder_add_value (&_tmp26_, g_variant_new_string (*_tmp25_));
		_tmp25_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp26_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_common_ibreak_timer_get_status_messages (BreakTimerCommonIBreakTimer* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp28_;
	GVariantBuilder _tmp29_;
	gint _tmp30_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = break_timer_common_ibreak_timer_get_status_messages (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp28_ = result;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE ("as"));
	for (_tmp30_ = 0; _tmp30_ < result_length1; _tmp30_++) {
		g_variant_builder_add_value (&_tmp29_, g_variant_new_string (*_tmp28_));
		_tmp28_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp29_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_break_timer_common_ibreak_timer_activate_break (BreakTimerCommonIBreakTimer* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* break_id = NULL;
	GVariant* _tmp31_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	break_id = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	break_timer_common_ibreak_timer_activate_break (self, break_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (break_id);
	;
}

static void
break_timer_common_ibreak_timer_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetCurrentActiveBreak") == 0) {
		_dbus_break_timer_common_ibreak_timer_get_current_active_break (object, parameters, invocation);
	} else if (strcmp (method_name, "GetBreakIds") == 0) {
		_dbus_break_timer_common_ibreak_timer_get_break_ids (object, parameters, invocation);
	} else if (strcmp (method_name, "GetStatusMessages") == 0) {
		_dbus_break_timer_common_ibreak_timer_get_status_messages (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateBreak") == 0) {
		_dbus_break_timer_common_ibreak_timer_activate_break (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
break_timer_common_ibreak_timer_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
break_timer_common_ibreak_timer_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
break_timer_common_ibreak_timer_register_object (gpointer object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_break_timer_common_ibreak_timer_dbus_interface_info), &_break_timer_common_ibreak_timer_dbus_interface_vtable, data, _break_timer_common_ibreak_timer_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_break_timer_common_ibreak_timer_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

