/* WindowOverview.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowOverview.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann
 * Copyright 2012 Rico Tzschichholz
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/workspace.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include <meta/keybindings.h>
#include <mtk/mtk.h>
#include <meta/prefs.h>

#define GALA_WINDOW_OVERVIEW_BORDER 10
#define GALA_WINDOW_OVERVIEW_TOP_GAP 30
#define GALA_WINDOW_OVERVIEW_BOTTOM_GAP 100
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;

#define GALA_TYPE_ROOT_TARGET (gala_root_target_get_type ())
#define GALA_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTarget))
#define GALA_IS_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ROOT_TARGET))
#define GALA_ROOT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTargetIface))

typedef struct _GalaRootTarget GalaRootTarget;
typedef struct _GalaRootTargetIface GalaRootTargetIface;

#define GALA_TYPE_WINDOW_OVERVIEW (gala_window_overview_get_type ())
#define GALA_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview))
#define GALA_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))
#define GALA_IS_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_IS_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_WINDOW_OVERVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))

typedef struct _GalaWindowOverview GalaWindowOverview;
typedef struct _GalaWindowOverviewClass GalaWindowOverviewClass;
typedef struct _GalaWindowOverviewPrivate GalaWindowOverviewPrivate;

#define GALA_TYPE_GESTURE_CONTROLLER (gala_gesture_controller_get_type ())
#define GALA_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController))
#define GALA_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))
#define GALA_IS_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_IS_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_GESTURE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))

typedef struct _GalaGestureController GalaGestureController;
typedef struct _GalaGestureControllerClass GalaGestureControllerClass;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
enum  {
	GALA_WINDOW_OVERVIEW_0_PROPERTY,
	GALA_WINDOW_OVERVIEW_WM_PROPERTY,
	GALA_WINDOW_OVERVIEW_NUM_PROPERTIES
};
static GParamSpec* gala_window_overview_properties[GALA_WINDOW_OVERVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block64Data Block64Data;

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaRootTargetIface {
	GTypeInterface parent_iface;
};

struct _GalaWindowOverview {
	GalaActorTarget parent_instance;
	GalaWindowOverviewPrivate * priv;
};

struct _GalaWindowOverviewClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWindowOverviewPrivate {
	GalaWindowManager* _wm;
	GalaGestureController* gesture_controller;
	GalaModalProxy* modal_proxy;
	GList* workspaces;
	GalaWindowCloneContainer* window_clone_container;
};

struct _Block64Data {
	int _ref_count_;
	GalaWindowOverview* self;
	MetaWindow* window;
};

static gint GalaWindowOverview_private_offset;
static gpointer gala_window_overview_parent_class = NULL;
static GalaRootTargetIface * gala_window_overview_gala_root_target_parent_iface = NULL;
static GalaActivatableComponentIface * gala_window_overview_gala_activatable_component_parent_iface = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_root_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_window_overview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowOverview, g_object_unref)
VALA_EXTERN GType gala_gesture_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureController, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GalaWindowOverview* gala_window_overview_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowOverview* gala_window_overview_construct (GType object_type,
                                                    GalaWindowManager* wm);
static gboolean gala_window_overview_real_key_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static gboolean gala_window_overview_real_button_release_event (ClutterActor* base,
                                                         ClutterEvent* event);
static gboolean gala_window_overview_real_is_opened (GalaActivatableComponent* base);
static void gala_window_overview_real_open (GalaActivatableComponent* base,
                                     GHashTable* hints);
VALA_EXTERN GalaWindowManager* gala_window_overview_get_wm (GalaWindowOverview* self);
static guint64* _variant_get2 (GVariant* value,
                        gint* result_length1);
VALA_EXTERN gboolean gala_notification_stack_is_notification (MetaWindow* window);
static gboolean _vala_uint64_array_contains (guint64 * stack,
                                      gssize stack_length,
                                      const guint64 needle);
static void gala_window_overview_add_window (GalaWindowOverview* self,
                                      MetaWindow* window);
static void _gala_window_overview_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void gala_window_overview_remove_window (GalaWindowOverview* self,
                                         MetaWindow* window);
static void _gala_window_overview_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                        MetaWindow* object,
                                                                        gpointer self);
static void gala_window_overview_window_left_monitor (GalaWindowOverview* self,
                                               gint num,
                                               MetaWindow* window);
static void _gala_window_overview_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                 gint object,
                                                                                 MetaWindow* p0,
                                                                                 gpointer self);
static gboolean gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                                 MetaKeyBinding* binding);
static gboolean _gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                         gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                          MetaWindow* window);
static void _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                       MetaWindow* window,
                                                                                       gpointer self);
static void _____lambda145_ (GalaWindowOverview* self);
static void ______lambda145__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                   gpointer self);
static void _____lambda146_ (GalaWindowOverview* self);
static void ______lambda146__gala_window_clone_container_last_window_closed (GalaWindowCloneContainer* _sender,
                                                                      gpointer self);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN void gala_gesture_controller_goto (GalaGestureController* self,
                                   gdouble to);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
static gboolean ___lambda144_ (Block64Data* _data64_);
static gboolean ____lambda144__gsource_func (gpointer self);
static void gala_window_overview_real_close (GalaActivatableComponent* base,
                                      GHashTable* hints);
static gboolean __lambda143_ (GalaWindowOverview* self);
static void gala_window_overview_cleanup (GalaWindowOverview* self);
static gboolean ___lambda143__gsource_func (gpointer self);
static void gala_window_overview_set_wm (GalaWindowOverview* self,
                                  GalaWindowManager* value);
static GObject * gala_window_overview_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
VALA_EXTERN GalaGestureController* gala_gesture_controller_new (GalaGestureAction action,
                                                    GalaWindowManager* wm);
VALA_EXTERN GalaGestureController* gala_gesture_controller_construct (GType object_type,
                                                          GalaGestureAction action,
                                                          GalaWindowManager* wm);
VALA_EXTERN void gala_gesture_controller_set_enabled (GalaGestureController* self,
                                          gboolean value);
VALA_EXTERN void gala_root_target_add_gesture_controller (GalaRootTarget* self,
                                              GalaGestureController* controller);
static void gala_window_overview_finalize (GObject * obj);
static GType gala_window_overview_get_type_once (void);
static void _vala_gala_window_overview_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_overview_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_window_overview_get_instance_private (GalaWindowOverview* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowOverview_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaWindowOverview*
gala_window_overview_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowOverview * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowOverview*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowOverview*
gala_window_overview_new (GalaWindowManager* wm)
{
	return gala_window_overview_construct (GALA_TYPE_WINDOW_OVERVIEW, wm);
}

static gboolean
gala_window_overview_real_key_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowOverview * self;
	GalaWindowCloneContainer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gala_activatable_component_is_opened ((GalaActivatableComponent*) self)) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->window_clone_container;
	g_signal_emit_by_name ((ClutterActor*) _tmp0_, "key-press-event", event, &_tmp1_);
	result = _tmp1_;
	return result;
}

static gboolean
gala_window_overview_real_button_release_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaWindowOverview * self;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

/**
     * {@inheritDoc}
     */
static gboolean
gala_window_overview_real_is_opened (GalaActivatableComponent* base)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint64*
_variant_get2 (GVariant* value,
               gint* result_length1)
{
	guint64* _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (guint64, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
	g_variant_iter_init (&_tmp1_, value);
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
		if (_tmp0__size == _tmp0__length) {
			_tmp0__size = 2 * _tmp0__size;
			_tmp0_ = g_renew (guint64, _tmp0_, _tmp0__size + 1);
		}
		_tmp0_[_tmp0__length++] = g_variant_get_uint64 (_tmp2_);
		g_variant_unref (_tmp2_);
	}
	*result_length1 = _tmp0__length1;
	return _tmp0_;
}

static gboolean
_vala_uint64_array_contains (guint64 * stack,
                             gssize stack_length,
                             const guint64 needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
_gala_window_overview_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	gala_window_overview_add_window ((GalaWindowOverview*) self, object);
}

static void
_gala_window_overview_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self)
{
	gala_window_overview_remove_window ((GalaWindowOverview*) self, object);
}

static void
_gala_window_overview_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                            gint object,
                                                                            MetaWindow* p0,
                                                                            gpointer self)
{
	gala_window_overview_window_left_monitor ((GalaWindowOverview*) self, object, p0);
}

static gboolean
_gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                gpointer self)
{
	gboolean result;
	result = gala_window_overview_keybinding_filter ((GalaWindowOverview*) self, binding);
	return result;
}

static void
_gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                  MetaWindow* window,
                                                                                  gpointer self)
{
	gala_window_overview_thumb_selected ((GalaWindowOverview*) self, window);
}

static void
_____lambda145_ (GalaWindowOverview* self)
{
	gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
}

static void
______lambda145__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                              gpointer self)
{
	_____lambda145_ ((GalaWindowOverview*) self);
}

static void
_____lambda146_ (GalaWindowOverview* self)
{
	gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
}

static void
______lambda146__gala_window_clone_container_last_window_closed (GalaWindowCloneContainer* _sender,
                                                                 gpointer self)
{
	_____lambda146_ ((GalaWindowOverview*) self);
}

static void
gala_window_overview_real_open (GalaActivatableComponent* base,
                                GHashTable* hints)
{
	GalaWindowOverview * self;
	MetaWorkspaceManager* manager = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	GList* _tmp4_;
	guint64* window_ids = NULL;
	gint window_ids_length1;
	gint _window_ids_size_;
	gboolean _tmp7_ = FALSE;
	GList* windows = NULL;
	GList* _tmp10_;
	GList* _tmp45_;
	GList* _tmp46_;
	GalaWindowManager* _tmp50_;
	MetaDisplay* _tmp51_;
	GalaWindowManager* _tmp52_;
	GalaModalProxy* _tmp53_;
	GalaModalProxy* _tmp54_;
	GalaModalProxy* _tmp55_;
	GalaGestureAction* _tmp56_;
	GalaGestureAction* _tmp57_;
	gint _tmp57__length1;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp58_;
	MetaDisplay* _tmp59_;
	GList* _tmp76_;
	GalaGestureController* _tmp85_;
	self = (GalaWindowOverview*) base;
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	self->priv->workspaces = NULL;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_workspaces (_tmp3_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp4_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* workspace = NULL;
			workspace = (MetaWorkspace*) workspace_it->data;
			{
				MetaWorkspace* _tmp5_;
				MetaWorkspace* _tmp6_;
				_tmp5_ = workspace;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				self->priv->workspaces = g_list_append (self->priv->workspaces, _tmp6_);
			}
		}
	}
	window_ids = NULL;
	window_ids_length1 = 0;
	_window_ids_size_ = window_ids_length1;
	if (hints != NULL) {
		_tmp7_ = g_hash_table_contains (hints, "windows");
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gconstpointer _tmp8_;
		guint64* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp8_ = g_hash_table_lookup (hints, "windows");
		_tmp9_ = _variant_get2 ((GVariant*) _tmp8_, &_tmp9__length1);
		window_ids = (g_free (window_ids), NULL);
		window_ids = _tmp9_;
		window_ids_length1 = _tmp9__length1;
		_window_ids_size_ = window_ids_length1;
	}
	windows = NULL;
	_tmp10_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp10_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp11_;
			MetaWorkspace* workspace = NULL;
			_tmp11_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp11_;
			{
				MetaWorkspace* _tmp12_;
				GList* _tmp13_;
				_tmp12_ = workspace;
				_tmp13_ = meta_workspace_list_windows (_tmp12_);
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp13_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							gboolean _tmp14_ = FALSE;
							MetaWindow* _tmp15_;
							MetaWindowType _tmp16_;
							MetaWindowType _tmp17_;
							gboolean _tmp19_ = FALSE;
							gboolean _tmp20_ = FALSE;
							gboolean _tmp21_ = FALSE;
							MetaWindow* _tmp22_;
							MetaWindowType _tmp23_;
							MetaWindowType _tmp24_;
							gboolean _tmp36_ = FALSE;
							MetaWindow* _tmp37_;
							gboolean _tmp38_;
							gboolean _tmp39_;
							MetaWindow* _tmp43_;
							MetaWindow* _tmp44_;
							_tmp15_ = window;
							_tmp16_ = meta_window_get_window_type (_tmp15_);
							_tmp17_ = _tmp16_;
							if (_tmp17_ == META_WINDOW_DOCK) {
								_tmp14_ = TRUE;
							} else {
								MetaWindow* _tmp18_;
								_tmp18_ = window;
								_tmp14_ = gala_notification_stack_is_notification (_tmp18_);
							}
							if (_tmp14_) {
								continue;
							}
							_tmp22_ = window;
							_tmp23_ = meta_window_get_window_type (_tmp22_);
							_tmp24_ = _tmp23_;
							if (_tmp24_ != META_WINDOW_NORMAL) {
								MetaWindow* _tmp25_;
								MetaWindowType _tmp26_;
								MetaWindowType _tmp27_;
								_tmp25_ = window;
								_tmp26_ = meta_window_get_window_type (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp21_ = _tmp27_ != META_WINDOW_DIALOG;
							} else {
								_tmp21_ = FALSE;
							}
							if (_tmp21_) {
								_tmp20_ = TRUE;
							} else {
								MetaWindow* _tmp28_;
								_tmp28_ = window;
								_tmp20_ = meta_window_is_attached_dialog (_tmp28_);
							}
							if (_tmp20_) {
								_tmp19_ = TRUE;
							} else {
								gboolean _tmp29_ = FALSE;
								guint64* _tmp30_;
								gint _tmp30__length1;
								_tmp30_ = window_ids;
								_tmp30__length1 = window_ids_length1;
								if (_tmp30_ != NULL) {
									MetaWindow* _tmp31_;
									guint64* _tmp32_;
									gint _tmp32__length1;
									_tmp31_ = window;
									_tmp32_ = window_ids;
									_tmp32__length1 = window_ids_length1;
									_tmp29_ = !_vala_uint64_array_contains (_tmp32_, _tmp32__length1, meta_window_get_id (_tmp31_));
								} else {
									_tmp29_ = FALSE;
								}
								_tmp19_ = _tmp29_;
							}
							if (_tmp19_) {
								MetaWindowActor* actor = NULL;
								MetaWindow* _tmp33_;
								GObject* _tmp34_;
								MetaWindowActor* _tmp35_;
								_tmp33_ = window;
								_tmp34_ = meta_window_get_compositor_private (_tmp33_);
								actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, meta_window_actor_get_type (), MetaWindowActor);
								_tmp35_ = actor;
								clutter_actor_hide ((ClutterActor*) _tmp35_);
								continue;
							}
							_tmp37_ = window;
							g_object_get (_tmp37_, "on-all-workspaces", &_tmp38_, NULL);
							_tmp39_ = _tmp38_;
							if (_tmp39_) {
								MetaWindow* _tmp40_;
								MetaWorkspace* _tmp41_;
								MetaWorkspace* _tmp42_;
								_tmp40_ = window;
								_tmp41_ = meta_window_get_workspace (_tmp40_);
								_tmp42_ = workspace;
								_tmp36_ = _tmp41_ != _tmp42_;
							} else {
								_tmp36_ = FALSE;
							}
							if (_tmp36_) {
								continue;
							}
							_tmp43_ = window;
							_tmp44_ = _g_object_ref0 (_tmp43_);
							windows = g_list_append (windows, _tmp44_);
						}
					}
					(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
				}
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp45_ = windows;
	if (vala_g_list_is_empty (_tmp45_)) {
		(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
		window_ids = (g_free (window_ids), NULL);
		return;
	}
	_tmp46_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp46_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp47_;
			MetaWorkspace* workspace = NULL;
			_tmp47_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp47_;
			{
				MetaWorkspace* _tmp48_;
				MetaWorkspace* _tmp49_;
				_tmp48_ = workspace;
				g_signal_connect_object (_tmp48_, "window-added", (GCallback) _gala_window_overview_add_window_meta_workspace_window_added, self, 0);
				_tmp49_ = workspace;
				g_signal_connect_object (_tmp49_, "window-removed", (GCallback) _gala_window_overview_remove_window_meta_workspace_window_removed, self, 0);
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp50_ = self->priv->_wm;
	_tmp51_ = meta_plugin_get_display ((MetaPlugin*) _tmp50_);
	g_signal_connect_object (_tmp51_, "window-left-monitor", (GCallback) _gala_window_overview_window_left_monitor_meta_display_window_left_monitor, self, 0);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp52_ = self->priv->_wm;
	_tmp53_ = gala_window_manager_push_modal (_tmp52_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp53_;
	_tmp54_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp54_, _gala_window_overview_keybinding_filter_gala_keybinding_filter, self);
	_tmp55_ = self->priv->modal_proxy;
	_tmp56_ = g_new0 (GalaGestureAction, 1);
	_tmp56_[0] = GALA_GESTURE_ACTION_ZOOM;
	_tmp57_ = _tmp56_;
	_tmp57__length1 = 1;
	gala_modal_proxy_allow_actions (_tmp55_, _tmp57_, (gint) 1);
	_tmp57_ = (g_free (_tmp57_), NULL);
	_tmp58_ = self->priv->_wm;
	_tmp59_ = meta_plugin_get_display ((MetaPlugin*) _tmp58_);
	display = _tmp59_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp60_ = FALSE;
			_tmp60_ = TRUE;
			while (TRUE) {
				MetaDisplay* _tmp62_;
				MtkRectangle geometry = {0};
				MetaDisplay* _tmp63_;
				MtkRectangle _tmp64_ = {0};
				gfloat scale = 0.0F;
				MetaDisplay* _tmp65_;
				GalaWindowManager* _tmp66_;
				MtkRectangle _tmp67_;
				MtkRectangle _tmp68_;
				MtkRectangle _tmp69_;
				MtkRectangle _tmp70_;
				GalaWindowCloneContainer* _tmp71_ = NULL;
				GalaWindowCloneContainer* _tmp72_;
				GalaWindowCloneContainer* _tmp73_;
				GalaWindowCloneContainer* _tmp74_;
				GalaWindowCloneContainer* _tmp75_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = i;
					i = _tmp61_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp62_ = display;
				if (!(i < meta_display_get_n_monitors (_tmp62_))) {
					break;
				}
				_tmp63_ = display;
				meta_display_get_monitor_geometry (_tmp63_, i, &_tmp64_);
				geometry = _tmp64_;
				_tmp65_ = display;
				scale = meta_display_get_monitor_scale (_tmp65_, i);
				_tmp66_ = self->priv->_wm;
				_tmp67_ = geometry;
				_tmp68_ = geometry;
				_tmp69_ = geometry;
				_tmp70_ = geometry;
				_tmp71_ = gala_window_clone_container_new (_tmp66_, scale, TRUE);
				gala_window_clone_container_set_padding_top (_tmp71_, GALA_WINDOW_OVERVIEW_TOP_GAP);
				gala_window_clone_container_set_padding_left (_tmp71_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_right (_tmp71_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_bottom (_tmp71_, GALA_WINDOW_OVERVIEW_BOTTOM_GAP);
				clutter_actor_set_width ((ClutterActor*) _tmp71_, (gfloat) _tmp67_.width);
				clutter_actor_set_height ((ClutterActor*) _tmp71_, (gfloat) _tmp68_.height);
				clutter_actor_set_x ((ClutterActor*) _tmp71_, (gfloat) _tmp69_.x);
				clutter_actor_set_y ((ClutterActor*) _tmp71_, (gfloat) _tmp70_.y);
				g_object_ref_sink (_tmp71_);
				_g_object_unref0 (self->priv->window_clone_container);
				self->priv->window_clone_container = _tmp71_;
				_tmp72_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp72_, "window-selected", (GCallback) _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected, self, 0);
				_tmp73_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp73_, "requested-close", (GCallback) ______lambda145__gala_window_clone_container_requested_close, self, 0);
				_tmp74_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp74_, "last-window-closed", (GCallback) ______lambda146__gala_window_clone_container_last_window_closed, self, 0);
				_tmp75_ = self->priv->window_clone_container;
				clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp75_);
			}
		}
	}
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	_tmp76_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp76_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindowActor* actor = NULL;
				MetaWindow* _tmp77_;
				GObject* _tmp78_;
				MetaWindowActor* _tmp79_;
				GalaWindowCloneContainer* container = NULL;
				MetaWindow* _tmp80_;
				ClutterActor* _tmp81_;
				GalaWindowCloneContainer* _tmp82_;
				GalaWindowCloneContainer* _tmp83_;
				MetaWindow* _tmp84_;
				_tmp77_ = window;
				_tmp78_ = meta_window_get_compositor_private (_tmp77_);
				actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, meta_window_actor_get_type (), MetaWindowActor);
				_tmp79_ = actor;
				clutter_actor_hide ((ClutterActor*) _tmp79_);
				_tmp80_ = window;
				_tmp81_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (_tmp80_));
				container = G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
				_tmp82_ = container;
				if (_tmp82_ == NULL) {
					continue;
				}
				_tmp83_ = container;
				_tmp84_ = window;
				gala_window_clone_container_add_window (_tmp83_, _tmp84_);
			}
		}
	}
	_tmp85_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp85_, (gdouble) 1);
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
	window_ids = (g_free (window_ids), NULL);
}

static gboolean
gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                        MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp1_ = meta_key_binding_get_name (binding);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("expose-all-windows")))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = TRUE;
	return result;
}

static void
gala_window_overview_window_left_monitor (GalaWindowOverview* self,
                                          gint num,
                                          MetaWindow* window)
{
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_child_at_index ((ClutterActor*) self, num);
	container = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp1_ = container;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp2_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp3_;
			MetaWorkspace* workspace = NULL;
			_tmp3_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp3_;
			{
				MetaWorkspace* _tmp4_;
				_tmp4_ = workspace;
				if (meta_window_located_on_workspace (window, _tmp4_)) {
					GalaWindowCloneContainer* _tmp5_;
					_tmp5_ = container;
					gala_window_clone_container_remove_window (_tmp5_, window);
					_g_object_unref0 (workspace);
					break;
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

static void
gala_window_overview_add_window (GalaWindowOverview* self,
                                 MetaWindow* window)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	MetaWindowType _tmp3_;
	MetaWindowType _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	MetaWindowType _tmp7_;
	MetaWindowType _tmp8_;
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp13_;
	GalaWindowCloneContainer* _tmp14_;
	GList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp3_ = meta_window_get_window_type (window);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == META_WINDOW_DOCK) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gala_notification_stack_is_notification (window);
	}
	if (_tmp2_) {
		return;
	}
	_tmp7_ = meta_window_get_window_type (window);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != META_WINDOW_NORMAL) {
		MetaWindowType _tmp9_;
		MetaWindowType _tmp10_;
		_tmp9_ = meta_window_get_window_type (window);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != META_WINDOW_DIALOG;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = meta_window_is_attached_dialog (window);
	}
	if (_tmp5_) {
		MetaWindowActor* actor = NULL;
		GObject* _tmp11_;
		MetaWindowActor* _tmp12_;
		_tmp11_ = meta_window_get_compositor_private (window);
		actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, meta_window_actor_get_type (), MetaWindowActor);
		_tmp12_ = actor;
		clutter_actor_hide ((ClutterActor*) _tmp12_);
		return;
	}
	_tmp13_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (window));
	container = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp14_ = container;
	if (_tmp14_ == NULL) {
		return;
	}
	_tmp15_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp15_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp16_;
			MetaWorkspace* workspace = NULL;
			_tmp16_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp16_;
			{
				MetaWorkspace* _tmp17_;
				_tmp17_ = workspace;
				if (meta_window_located_on_workspace (window, _tmp17_)) {
					GalaWindowCloneContainer* _tmp18_;
					_tmp18_ = container;
					gala_window_clone_container_add_window (_tmp18_, window);
					_g_object_unref0 (workspace);
					break;
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

static void
gala_window_overview_remove_window (GalaWindowOverview* self,
                                    MetaWindow* window)
{
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	GalaWindowCloneContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (window));
	container = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp1_ = container;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = container;
	gala_window_clone_container_remove_window (_tmp2_, window);
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		GalaWindowOverview* self;
		self = _data64_->self;
		_g_object_unref0 (_data64_->window);
		_g_object_unref0 (self);
		g_slice_free (Block64Data, _data64_);
	}
}

static gboolean
___lambda144_ (Block64Data* _data64_)
{
	GalaWindowOverview* self;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gboolean result;
	self = _data64_->self;
	_tmp0_ = meta_window_get_workspace (_data64_->window);
	_tmp1_ = meta_window_get_display (_data64_->window);
	meta_workspace_activate_with_focus (_tmp0_, _data64_->window, meta_display_get_current_time (_tmp1_));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda144__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda144_ (self);
	return result;
}

static void
gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                     MetaWindow* window)
{
	Block64Data* _data64_;
	MetaWindow* _tmp0_;
	MetaWorkspace* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data64_ = g_slice_new0 (Block64Data);
	_data64_->_ref_count_ = 1;
	_data64_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data64_->window);
	_data64_->window = _tmp0_;
	_tmp1_ = meta_window_get_workspace (_data64_->window);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	if (_tmp1_ == _tmp5_) {
		MetaDisplay* _tmp6_;
		_tmp6_ = meta_window_get_display (_data64_->window);
		meta_window_activate (_data64_->window, meta_display_get_current_time (_tmp6_));
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	} else {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION, ____lambda144__gsource_func, block64_data_ref (_data64_), block64_data_unref);
	}
	block64_data_unref (_data64_);
	_data64_ = NULL;
}

/**
     * {@inheritDoc}
     */
static gboolean
__lambda143_ (GalaWindowOverview* self)
{
	gboolean result;
	gala_window_overview_cleanup (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda143__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda143_ ((GalaWindowOverview*) self);
	return result;
}

static void
gala_window_overview_real_close (GalaActivatableComponent* base,
                                 GHashTable* hints)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GList* _tmp2_;
	GalaWindowManager* _tmp8_;
	MetaDisplay* _tmp9_;
	guint _tmp10_;
	GalaGestureController* _tmp11_;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp2_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp3_;
			MetaWorkspace* workspace = NULL;
			_tmp3_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp3_;
			{
				MetaWorkspace* _tmp4_;
				guint _tmp5_;
				MetaWorkspace* _tmp6_;
				guint _tmp7_;
				_tmp4_ = workspace;
				g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp5_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_window_overview_add_window_meta_workspace_window_added, self);
				_tmp6_ = workspace;
				g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp7_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gala_window_overview_remove_window_meta_workspace_window_removed, self);
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp8_ = self->priv->_wm;
	_tmp9_ = meta_plugin_get_display ((MetaPlugin*) _tmp8_);
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gala_window_overview_window_left_monitor_meta_display_window_left_monitor, self);
	clutter_threads_add_timeout ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION, ___lambda143__gsource_func, self);
	_tmp11_ = self->priv->gesture_controller;
	gala_gesture_controller_goto (_tmp11_, (gdouble) 0);
}

static void
gala_window_overview_cleanup (GalaWindowOverview* self)
{
	GalaWindowManager* _tmp0_;
	GalaModalProxy* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = self->priv->modal_proxy;
	gala_window_manager_pop_modal (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	_tmp6_ = meta_workspace_list_windows (_tmp5_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp6_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp7_;
				_tmp7_ = window;
				if (meta_window_showing_on_its_workspace (_tmp7_)) {
					MetaWindow* _tmp8_;
					GObject* _tmp9_;
					_tmp8_ = window;
					_tmp9_ = meta_window_get_compositor_private (_tmp8_);
					clutter_actor_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, clutter_actor_get_type (), ClutterActor));
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	clutter_actor_destroy_all_children ((ClutterActor*) self);
}

GalaWindowManager*
gala_window_overview_get_wm (GalaWindowOverview* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_overview_set_wm (GalaWindowOverview* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_overview_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY]);
	}
}

static GObject *
gala_window_overview_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowOverview * self;
	GalaWindowManager* _tmp0_;
	GalaGestureController* _tmp1_ = NULL;
	GalaGestureController* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_window_overview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, _tmp0_);
	gala_gesture_controller_set_enabled (_tmp1_, FALSE);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp1_;
	_tmp2_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp2_);
	return obj;
}

static void
gala_window_overview_class_init (GalaWindowOverviewClass * klass,
                                 gpointer klass_data)
{
	gala_window_overview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowOverview_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_overview_real_key_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_overview_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_overview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_overview_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_overview_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_overview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_OVERVIEW_WM_PROPERTY, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_overview_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                      gpointer iface_data)
{
	gala_window_overview_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_window_overview_gala_activatable_component_interface_init (GalaActivatableComponentIface * iface,
                                                                gpointer iface_data)
{
	gala_window_overview_gala_activatable_component_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_opened = (gboolean (*) (GalaActivatableComponent*)) gala_window_overview_real_is_opened;
	iface->open = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_open;
	iface->close = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_close;
}

static void
gala_window_overview_instance_init (GalaWindowOverview * self,
                                    gpointer klass)
{
	self->priv = gala_window_overview_get_instance_private (self);
}

static void
gala_window_overview_finalize (GObject * obj)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->gesture_controller);
	_g_object_unref0 (self->priv->modal_proxy);
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	_g_object_unref0 (self->priv->window_clone_container);
	G_OBJECT_CLASS (gala_window_overview_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_window_overview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowOverviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_overview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowOverview), 0, (GInstanceInitFunc) gala_window_overview_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_window_overview_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gala_activatable_component_info = { (GInterfaceInitFunc) gala_window_overview_gala_activatable_component_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_overview_type_id;
	gala_window_overview_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWindowOverview", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_overview_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	g_type_add_interface_static (gala_window_overview_type_id, GALA_TYPE_ACTIVATABLE_COMPONENT, &gala_activatable_component_info);
	GalaWindowOverview_private_offset = g_type_add_instance_private (gala_window_overview_type_id, sizeof (GalaWindowOverviewPrivate));
	return gala_window_overview_type_id;
}

GType
gala_window_overview_get_type (void)
{
	static gsize gala_window_overview_type_id__once = 0;
	if (g_once_init_enter (&gala_window_overview_type_id__once)) {
		GType gala_window_overview_type_id;
		gala_window_overview_type_id = gala_window_overview_get_type_once ();
		g_once_init_leave (&gala_window_overview_type_id__once, gala_window_overview_type_id);
	}
	return gala_window_overview_type_id__once;
}

static void
_vala_gala_window_overview_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		g_value_set_object (value, gala_window_overview_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_overview_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		gala_window_overview_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

