/* WindowClone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022-2025 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <meta/meta-window-actor.h>
#include <meta/workspace.h>
#include <meta/display.h>
#include <meta/meta-workspace-manager.h>
#include <stdlib.h>
#include <string.h>
#include <meta/prefs.h>
#include <meta/common.h>
#include <meta/meta-plugin.h>
#include <graphene-gobject.h>
#include <meta/meta-background-group.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#define GALA_WINDOW_CLONE_WINDOW_ICON_SIZE 64
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE 12
#define GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION 200
#define GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN 60
#define GALA_WINDOW_CLONE_CLOSE_TRANSLATION 600
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_BORDER_RADIUS 16
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY 0.8
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_TARGET (gala_gesture_target_get_type ())
#define GALA_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTarget))
#define GALA_IS_GESTURE_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TARGET))
#define GALA_GESTURE_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_TARGET, GalaGestureTargetIface))

typedef struct _GalaGestureTarget GalaGestureTarget;
typedef struct _GalaGestureTargetIface GalaGestureTargetIface;
typedef enum  {
	GALA_GESTURE_TARGET_UPDATE_TYPE_START,
	GALA_GESTURE_TARGET_UPDATE_TYPE_UPDATE,
	GALA_GESTURE_TARGET_UPDATE_TYPE_COMMIT,
	GALA_GESTURE_TARGET_UPDATE_TYPE_END
} GalaGestureTargetUpdateType;

#define GALA_GESTURE_TARGET_TYPE_UPDATE_TYPE (gala_gesture_target_update_type_get_type ())

#define GALA_TYPE_ACTOR_TARGET (gala_actor_target_get_type ())
#define GALA_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTarget))
#define GALA_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))
#define GALA_IS_ACTOR_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ACTOR_TARGET))
#define GALA_IS_ACTOR_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ACTOR_TARGET))
#define GALA_ACTOR_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ACTOR_TARGET, GalaActorTargetClass))

typedef struct _GalaActorTarget GalaActorTarget;
typedef struct _GalaActorTargetClass GalaActorTargetClass;
typedef struct _GalaActorTargetPrivate GalaActorTargetPrivate;

#define GALA_TYPE_ROOT_TARGET (gala_root_target_get_type ())
#define GALA_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTarget))
#define GALA_IS_ROOT_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ROOT_TARGET))
#define GALA_ROOT_TARGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_ROOT_TARGET, GalaRootTargetIface))

typedef struct _GalaRootTarget GalaRootTarget;
typedef struct _GalaRootTargetIface GalaRootTargetIface;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
typedef struct _GalaWindowClonePrivate GalaWindowClonePrivate;

#define GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE (gala_window_clone_active_shape_get_type ())
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))

typedef struct _GalaWindowCloneActiveShape GalaWindowCloneActiveShape;
typedef struct _GalaWindowCloneActiveShapeClass GalaWindowCloneActiveShapeClass;

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;

#define GALA_TYPE_GESTURE_CONTROLLER (gala_gesture_controller_get_type ())
#define GALA_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureController))
#define GALA_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))
#define GALA_IS_GESTURE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_IS_GESTURE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_CONTROLLER))
#define GALA_GESTURE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_CONTROLLER, GalaGestureControllerClass))

typedef struct _GalaGestureController GalaGestureController;
typedef struct _GalaGestureControllerClass GalaGestureControllerClass;
enum  {
	GALA_WINDOW_CLONE_0_PROPERTY,
	GALA_WINDOW_CLONE_WM_PROPERTY,
	GALA_WINDOW_CLONE_WINDOW_PROPERTY,
	GALA_WINDOW_CLONE_SLOT_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_PROPERTY,
	GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY,
	GALA_WINDOW_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_properties[GALA_WINDOW_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))

#define GALA_TYPE_PROPERTY_TARGET (gala_property_target_get_type ())
#define GALA_PROPERTY_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTarget))
#define GALA_PROPERTY_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTargetClass))
#define GALA_IS_PROPERTY_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_PROPERTY_TARGET))
#define GALA_IS_PROPERTY_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_PROPERTY_TARGET))
#define GALA_PROPERTY_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_PROPERTY_TARGET, GalaPropertyTargetClass))

typedef struct _GalaPropertyTarget GalaPropertyTarget;
typedef struct _GalaPropertyTargetClass GalaPropertyTargetClass;
typedef struct _Block62Data Block62Data;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _Block63Data Block63Data;
typedef struct _GalaWindowCloneActiveShapePrivate GalaWindowCloneActiveShapePrivate;
enum  {
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_0_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_active_shape_properties[GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES];
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);
enum  {
	GALA_WINDOW_CLONE_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL,
	GALA_WINDOW_CLONE_NUM_SIGNALS
};
static guint gala_window_clone_signals[GALA_WINDOW_CLONE_NUM_SIGNALS] = {0};

struct _GalaGestureTargetIface {
	GTypeInterface parent_iface;
	void (*propagate) (GalaGestureTarget* self, GalaGestureTargetUpdateType update_type, GalaGestureAction action, gdouble progress);
	ClutterActor* (*get_actor) (GalaGestureTarget* self);
};

struct _GalaActorTarget {
	ClutterActor parent_instance;
	GalaActorTargetPrivate * priv;
};

struct _GalaActorTargetClass {
	ClutterActorClass parent_class;
	void (*start_progress) (GalaActorTarget* self, GalaGestureAction action);
	void (*update_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble progress);
	void (*commit_progress) (GalaActorTarget* self, GalaGestureAction action, gdouble to);
	void (*end_progress) (GalaActorTarget* self, GalaGestureAction action);
};

struct _GalaRootTargetIface {
	GTypeInterface parent_iface;
};

struct _GalaWindowClone {
	GalaActorTarget parent_instance;
	GalaWindowClonePrivate * priv;
};

struct _GalaWindowCloneClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWindowClonePrivate {
	GalaWindowManager* _wm;
	MetaWindow* _window;
	MtkRectangle* _slot;
	gboolean _overview_mode;
	gfloat _monitor_scale;
	GalaDragDropAction* drag_action;
	ClutterClone* clone;
	GalaShadowEffect* shadow_effect;
	ClutterActor* prev_parent;
	gint prev_index;
	gulong check_confirm_dialog_cb;
	gboolean in_slot_animation;
	ClutterActor* clone_container;
	GalaCloseButton* close_button;
	GalaWindowCloneActiveShape* active_shape;
	ClutterActor* window_icon;
	GalaTooltip* window_title;
	GalaGestureController* gesture_controller;
};

struct _Block62Data {
	int _ref_count_;
	GalaWindowClone* self;
	MetaWindow* new_window;
};

struct _Block63Data {
	int _ref_count_;
	GalaWindowClone* self;
	gulong handler;
};

struct _GalaWindowCloneActiveShape {
	GalaCanvasActor parent_instance;
	GalaWindowCloneActiveShapePrivate * priv;
};

struct _GalaWindowCloneActiveShapeClass {
	GalaCanvasActorClass parent_class;
};

static gint GalaWindowClone_private_offset;
static gpointer gala_window_clone_parent_class = NULL;
static gpointer gala_window_clone_active_shape_parent_class = NULL;
static GalaRootTargetIface * gala_window_clone_gala_root_target_parent_iface = NULL;

VALA_EXTERN GType gala_gesture_target_update_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_gesture_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTarget, g_object_unref)
VALA_EXTERN GType gala_actor_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaActorTarget, g_object_unref)
VALA_EXTERN GType gala_root_target_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
static GType gala_window_clone_active_shape_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneActiveShape, g_object_unref)
VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN GType gala_gesture_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureController, g_object_unref)
VALA_EXTERN void gala_actor_target_start_progress (GalaActorTarget* self,
                                       GalaGestureAction action);
VALA_EXTERN void gala_actor_target_update_progress (GalaActorTarget* self,
                                        GalaGestureAction action,
                                        gdouble progress);
VALA_EXTERN void gala_actor_target_end_progress (GalaActorTarget* self,
                                     GalaGestureAction action);
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
static void gala_window_clone_unmanaged (GalaWindowClone* self);
static void _gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                         gpointer self);
static void gala_window_clone_check_shadow_requirements (GalaWindowClone* self);
static void _gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        gfloat monitor_scale,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              gfloat monitor_scale,
                                              gboolean overview_mode);
static void gala_window_clone_reallocate (GalaWindowClone* self);
VALA_EXTERN gfloat gala_window_clone_get_monitor_scale (GalaWindowClone* self);
static void gala_window_clone_close_window (GalaWindowClone* self,
                                     guint32 timestamp);
static void _gala_window_clone_close_window_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                  guint32 timestamp,
                                                                  gpointer self);
static void __lambda11_ (GalaWindowClone* self);
static void gala_window_clone_update_hover_widgets (GalaWindowClone* self,
                                             gboolean* animating);
static void ___lambda11__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gboolean gala_window_clone_get_overview_mode (GalaWindowClone* self);
static void gala_window_clone_load_clone (GalaWindowClone* self,
                                   MetaWindowActor* actor);
VALA_EXTERN void gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                           guint8 value);
static gboolean gala_window_clone_should_fade (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MtkRectangle* rect,
                                  gboolean animate);
static void gala_window_clone_set_slot (GalaWindowClone* self,
                                 MtkRectangle* value);
static void gala_window_clone_update_targets (GalaWindowClone* self);
VALA_EXTERN void gala_actor_target_remove_all_targets (GalaActorTarget* self);
VALA_EXTERN MtkRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
VALA_EXTERN void gala_actor_target_add_target (GalaActorTarget* self,
                                   GalaGestureTarget* target);
VALA_EXTERN GalaPropertyTarget* gala_property_target_new (GalaGestureAction action,
                                              ClutterActor* actor,
                                              const gchar* property,
                                              GType value_type,
                                              GValue* from_value,
                                              GValue* to_value);
VALA_EXTERN GalaPropertyTarget* gala_property_target_construct (GType object_type,
                                                    GalaGestureAction action,
                                                    ClutterActor* actor,
                                                    const gchar* property,
                                                    GType value_type,
                                                    GValue* from_value,
                                                    GValue* to_value);
VALA_EXTERN GType gala_property_target_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaPropertyTarget, g_object_unref)
static void gala_window_clone_real_start_progress (GalaActorTarget* base,
                                            GalaGestureAction action);
static void gala_window_clone_real_update_progress (GalaActorTarget* base,
                                             GalaGestureAction action,
                                             gdouble progress);
static void gala_window_clone_real_end_progress (GalaActorTarget* base,
                                          GalaGestureAction action);
VALA_EXTERN gdouble gala_actor_target_get_current_commit (GalaActorTarget* self,
                                              GalaGestureAction action);
static void gala_window_clone_real_allocate (ClutterActor* base,
                                      ClutterActorBox* box);
VALA_EXTERN void gala_internal_utils_actor_box_from_rect (gfloat x,
                                              gfloat y,
                                              gfloat width,
                                              gfloat height,
                                              ClutterActorBox* result);
VALA_EXTERN GalaWindowManager* gala_window_clone_get_wm (GalaWindowClone* self);
static gboolean gala_window_clone_is_close_button_on_left (void);
static gboolean gala_window_clone_real_button_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static void gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                             gint monitor,
                                             MetaWindow* new_window);
static void _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static gboolean __lambda10_ (Block62Data* _data62_);
VALA_EXTERN void gala_gesture_controller_goto (GalaGestureController* self,
                                   gdouble to);
static gboolean ___lambda10__gsource_func (gpointer self);
static void gala_window_clone_actor_clicked (GalaWindowClone* self,
                                      guint32 button,
                                      ClutterInputDeviceType device_type);
static ClutterActor* gala_window_clone_drag_begin (GalaWindowClone* self,
                                            gfloat click_x,
                                            gfloat click_y);
static void gala_window_clone_drag_destination_crossed (GalaWindowClone* self,
                                                 ClutterActor* destination,
                                                 gboolean hovered);
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_delay (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_window_thumb (GalaWorkspaceInsertThumb* self,
                                                   MetaWindow* window);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static void gala_window_clone_drag_end (GalaWindowClone* self,
                                 ClutterActor* destination);
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_internal_utils_insert_workspace_with_window (gint index,
                                                       MetaWindow* new_window);
static void gala_window_clone_drag_canceled (GalaWindowClone* self);
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static void ___lambda76_ (Block63Data* _data63_);
static void ____lambda76__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                        gpointer self);
static void gala_window_clone_set_wm (GalaWindowClone* self,
                               GalaWindowManager* value);
static void gala_window_clone_set_window (GalaWindowClone* self,
                                   MetaWindow* value);
static gboolean _mtk_rectangle_equal (const MtkRectangle * s1,
                               const MtkRectangle * s2);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
static void gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                          gboolean value);
VALA_EXTERN void gala_window_clone_set_monitor_scale (GalaWindowClone* self,
                                          gfloat value);
VALA_EXTERN guint8 gala_window_clone_get_shadow_opacity (GalaWindowClone* self);
static void gala_window_clone_active_shape_invalidate (GalaWindowCloneActiveShape* self);
static void gala_window_clone_active_shape_real_draw (GalaCanvasActor* base,
                                               cairo_t* cr,
                                               gint width,
                                               gint height);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_new (void);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_construct (GType object_type);
static GObject * gala_window_clone_active_shape_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _gala_window_clone_active_shape_invalidate_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static GType gala_window_clone_active_shape_get_type_once (void);
static GObject * gala_window_clone_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN GalaGestureController* gala_gesture_controller_new (GalaGestureAction action,
                                                    GalaWindowManager* wm);
VALA_EXTERN GalaGestureController* gala_gesture_controller_construct (GType object_type,
                                                          GalaGestureAction action,
                                                          GalaWindowManager* wm);
VALA_EXTERN void gala_gesture_controller_enable_scroll (GalaGestureController* self,
                                            ClutterActor* actor,
                                            ClutterOrientation orientation);
VALA_EXTERN void gala_root_target_add_gesture_controller (GalaRootTarget* self,
                                              GalaGestureController* controller);
static void _gala_window_clone___lambda77_ (GalaWindowClone* self);
static void __gala_window_clone___lambda77__meta_window_size_changed (MetaWindow* _sender,
                                                               gpointer self);
static void _gala_window_clone_update_targets_meta_window_position_changed (MetaWindow* _sender,
                                                                     gpointer self);
static void _gala_window_clone____lambda78_ (GalaWindowClone* self,
                                      ClutterClickAction* action,
                                      ClutterActor* actor);
static void __gala_window_clone____lambda78__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                    ClutterActor* actor,
                                                                    gpointer self);
static ClutterActor* _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                              gfloat x,
                                                                              gfloat y,
                                                                              gpointer self);
static void _gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                            ClutterActor* destination,
                                                                                            gboolean hovered,
                                                                                            gpointer self);
static void _gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self);
static void _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                           gpointer self);
static void _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                           guint32 button,
                                                                           ClutterInputDeviceType device_type,
                                                                           gpointer self);
VALA_EXTERN GalaTooltip* gala_tooltip_new (void);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type);
static void _gala_window_clone_reallocate_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                                GalaInternalUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify);
static void _gala_window_clone_load_clone_gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                                    gpointer self);
static void _gala_window_clone___lambda79_ (GalaWindowClone* self);
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text);
static void __gala_window_clone___lambda79__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _gala_window_clone___lambda80_ (GalaWindowClone* self);
static void __gala_window_clone___lambda80__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void gala_window_clone_finalize (GObject * obj);
static GType gala_window_clone_get_type_once (void);
static void _vala_gala_window_clone_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_window_clone_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
gala_window_clone_get_instance_private (GalaWindowClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowClone_private_offset);
}

static void
_gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                    gpointer self)
{
	gala_window_clone_unmanaged ((GalaWindowClone*) self);
}

static void
_gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	gala_window_clone_check_shadow_requirements ((GalaWindowClone*) self);
}

static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

GalaWindowClone*
gala_window_clone_construct (GType object_type,
                             GalaWindowManager* wm,
                             MetaWindow* window,
                             gfloat monitor_scale,
                             gboolean overview_mode)
{
	GalaWindowClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowClone*) g_object_new (object_type, "wm", wm, "window", window, "monitor-scale", monitor_scale, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowClone*
gala_window_clone_new (GalaWindowManager* wm,
                       MetaWindow* window,
                       gfloat monitor_scale,
                       gboolean overview_mode)
{
	return gala_window_clone_construct (GALA_TYPE_WINDOW_CLONE, wm, window, monitor_scale, overview_mode);
}

static void
_gala_window_clone_close_window_gala_close_button_triggered (GalaCloseButton* _sender,
                                                             guint32 timestamp,
                                                             gpointer self)
{
	gala_window_clone_close_window ((GalaWindowClone*) self, timestamp);
}

static void
__lambda11_ (GalaWindowClone* self)
{
	gala_window_clone_update_hover_widgets (self, NULL);
}

static void
___lambda11__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda11_ ((GalaWindowClone*) self);
}

static void
gala_window_clone_reallocate (GalaWindowClone* self)
{
	gfloat _tmp0_;
	GalaCloseButton* _tmp1_ = NULL;
	GalaCloseButton* _tmp2_;
	GalaCloseButton* _tmp3_;
	MetaWindow* _tmp4_;
	gfloat _tmp5_;
	gboolean _tmp6_;
	GalaWindowIcon* _tmp7_ = NULL;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	GalaCloseButton* _tmp10_;
	ClutterActor* _tmp11_;
	ClutterActor* _tmp12_;
	GalaTooltip* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitor_scale;
	_tmp1_ = gala_close_button_new (_tmp0_);
	clutter_actor_set_opacity ((ClutterActor*) _tmp1_, (guint) 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp1_;
	_tmp2_ = self->priv->close_button;
	g_signal_connect_object (_tmp2_, "triggered", (GCallback) _gala_window_clone_close_window_gala_close_button_triggered, self, 0);
	_tmp3_ = self->priv->close_button;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::has-pointer", (GCallback) ___lambda11__g_object_notify, self, 0);
	_tmp4_ = self->priv->_window;
	_tmp5_ = self->priv->_monitor_scale;
	_tmp6_ = self->priv->_overview_mode;
	_tmp7_ = gala_window_icon_new (_tmp4_, GALA_WINDOW_CLONE_WINDOW_ICON_SIZE, (gint) round ((gdouble) _tmp5_));
	g_object_set ((ClutterActor*) _tmp7_, "visible", !_tmp6_, NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->window_icon);
	self->priv->window_icon = (ClutterActor*) _tmp7_;
	_tmp8_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp8_, (guint) 0);
	_tmp9_ = self->priv->window_icon;
	clutter_actor_set_pivot_point (_tmp9_, 0.5f, 0.5f);
	_tmp10_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp10_);
	_tmp11_ = self->priv->window_icon;
	clutter_actor_add_child ((ClutterActor*) self, _tmp11_);
	_tmp12_ = self->priv->window_icon;
	_tmp13_ = self->priv->window_title;
	clutter_actor_set_child_below_sibling ((ClutterActor*) self, _tmp12_, (ClutterActor*) _tmp13_);
}

/**
     * Waits for the texture of a new Meta.WindowActor to be available
     * and makes a close of it. If it was already was assigned a slot
     * at this point it will animate to it. Otherwise it will just place
     * itself at the location of the original window. Also adds the shadow
     * effect and makes sure the shadow is updated on size changes.
     */
static void
gala_window_clone_load_clone (GalaWindowClone* self,
                              MetaWindowActor* actor)
{
	gboolean _tmp0_;
	ClutterClone* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterClone* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->_overview_mode;
	if (_tmp0_) {
		clutter_actor_hide ((ClutterActor*) actor);
	}
	_tmp1_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) actor);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = _tmp1_;
	_tmp2_ = self->priv->clone_container;
	_tmp3_ = self->priv->clone;
	clutter_actor_add_child (_tmp2_, (ClutterActor*) _tmp3_);
	gala_window_clone_check_shadow_requirements (self);
}

static void
gala_window_clone_check_shadow_requirements (GalaWindowClone* self)
{
	ClutterClone* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->_window;
	g_object_get (_tmp2_, "fullscreen", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		MetaWindow* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->_window;
		g_object_get (_tmp6_, "maximized-horizontally", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			MetaWindow* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = self->priv->_window;
			g_object_get (_tmp9_, "maximized-vertically", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		GalaShadowEffect* _tmp12_;
		_tmp12_ = self->priv->shadow_effect;
		if (_tmp12_ == NULL) {
			gfloat _tmp13_;
			GalaShadowEffect* _tmp14_;
			ClutterClone* _tmp15_;
			GalaShadowEffect* _tmp16_;
			_tmp13_ = self->priv->_monitor_scale;
			_tmp14_ = gala_shadow_effect_new ("window", _tmp13_);
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = _tmp14_;
			gala_window_clone_set_shadow_opacity (self, (guint8) 0);
			_tmp15_ = self->priv->clone;
			_tmp16_ = self->priv->shadow_effect;
			clutter_actor_add_effect_with_name ((ClutterActor*) _tmp15_, "shadow", (ClutterEffect*) _tmp16_);
		}
	} else {
		GalaShadowEffect* _tmp17_;
		_tmp17_ = self->priv->shadow_effect;
		if (_tmp17_ != NULL) {
			ClutterClone* _tmp18_;
			GalaShadowEffect* _tmp19_;
			_tmp18_ = self->priv->clone;
			_tmp19_ = self->priv->shadow_effect;
			clutter_actor_remove_effect ((ClutterActor*) _tmp18_, (ClutterEffect*) _tmp19_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = NULL;
		}
	}
}

/**
     * If we are in overview mode, we may display windows from workspaces other than
     * the current one. To ease their appearance we have to fade them in.
     */
static gboolean
gala_window_clone_should_fade (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->_overview_mode;
	if (_tmp2_) {
		MetaWindow* _tmp3_;
		MetaWorkspace* _tmp4_;
		MetaWindow* _tmp5_;
		MetaDisplay* _tmp6_;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		_tmp3_ = self->priv->_window;
		_tmp4_ = meta_window_get_workspace (_tmp3_);
		_tmp5_ = self->priv->_window;
		_tmp6_ = meta_window_get_display (_tmp5_);
		_tmp7_ = meta_display_get_workspace_manager (_tmp6_);
		_tmp8_ = meta_workspace_manager_get_active_workspace (_tmp7_);
		_tmp1_ = _tmp4_ != _tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaWindow* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->_window;
		g_object_get (_tmp9_, "minimized", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	result = _tmp0_;
	return result;
}

/**
     * Animate the window to the given slot
     */
void
gala_window_clone_take_slot (GalaWindowClone* self,
                             MtkRectangle* rect,
                             gboolean animate)
{
	MtkRectangle _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	gala_window_clone_set_slot (self, &_tmp0_);
	if (animate) {
		clutter_actor_save_easing_state ((ClutterActor*) self);
		clutter_actor_set_easing_duration ((ClutterActor*) self, gala_utils_get_animation_duration ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION));
		clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	}
	gala_window_clone_update_targets (self);
	if (animate) {
		clutter_actor_restore_easing_state ((ClutterActor*) self);
	}
}

static void
gala_window_clone_update_targets (GalaWindowClone* self)
{
	MtkRectangle* _tmp0_;
	MtkRectangle window_rect = {0};
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	MtkRectangle monitor_geometry = {0};
	MetaWindow* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaWindow* _tmp6_;
	MtkRectangle _tmp7_ = {0};
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	GValue _tmp10_ = {0};
	MtkRectangle* _tmp11_;
	GValue _tmp12_ = {0};
	GalaPropertyTarget* _tmp13_;
	GalaPropertyTarget* _tmp14_;
	MtkRectangle _tmp15_;
	MtkRectangle _tmp16_;
	GValue _tmp17_ = {0};
	MtkRectangle* _tmp18_;
	GValue _tmp19_ = {0};
	GalaPropertyTarget* _tmp20_;
	GalaPropertyTarget* _tmp21_;
	MtkRectangle _tmp22_;
	GValue _tmp23_ = {0};
	MtkRectangle* _tmp24_;
	GValue _tmp25_ = {0};
	GalaPropertyTarget* _tmp26_;
	GalaPropertyTarget* _tmp27_;
	MtkRectangle _tmp28_;
	GValue _tmp29_ = {0};
	MtkRectangle* _tmp30_;
	GValue _tmp31_ = {0};
	GalaPropertyTarget* _tmp32_;
	GalaPropertyTarget* _tmp33_;
	GValue _tmp34_ = {0};
	GValue _tmp35_ = {0};
	GalaPropertyTarget* _tmp36_;
	GalaPropertyTarget* _tmp37_;
	ClutterActor* _tmp42_;
	GValue _tmp43_ = {0};
	GValue _tmp44_ = {0};
	GalaPropertyTarget* _tmp45_;
	GalaPropertyTarget* _tmp46_;
	GalaTooltip* _tmp47_;
	GValue _tmp48_ = {0};
	GValue _tmp49_ = {0};
	GalaPropertyTarget* _tmp50_;
	GalaPropertyTarget* _tmp51_;
	g_return_if_fail (self != NULL);
	gala_actor_target_remove_all_targets ((GalaActorTarget*) self);
	_tmp0_ = self->priv->_slot;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp1_, &_tmp2_);
	window_rect = _tmp2_;
	_tmp3_ = self->priv->_window;
	_tmp4_ = meta_window_get_display (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_window;
	meta_display_get_monitor_geometry (_tmp5_, meta_window_get_monitor (_tmp6_), &_tmp7_);
	monitor_geometry = _tmp7_;
	_tmp8_ = window_rect;
	_tmp9_ = monitor_geometry;
	g_value_init (&_tmp10_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp10_, (gfloat) (_tmp8_.x - _tmp9_.x));
	_tmp11_ = self->priv->_slot;
	g_value_init (&_tmp12_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp12_, (gfloat) (*_tmp11_).x);
	_tmp13_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "x", G_TYPE_FLOAT, &_tmp10_, &_tmp12_);
	_tmp14_ = _tmp13_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	_tmp15_ = window_rect;
	_tmp16_ = monitor_geometry;
	g_value_init (&_tmp17_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp17_, (gfloat) (_tmp15_.y - _tmp16_.y));
	_tmp18_ = self->priv->_slot;
	g_value_init (&_tmp19_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp19_, (gfloat) (*_tmp18_).y);
	_tmp20_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "y", G_TYPE_FLOAT, &_tmp17_, &_tmp19_);
	_tmp21_ = _tmp20_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
	G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
	_tmp22_ = window_rect;
	g_value_init (&_tmp23_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp23_, (gfloat) _tmp22_.width);
	_tmp24_ = self->priv->_slot;
	g_value_init (&_tmp25_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp25_, (gfloat) (*_tmp24_).width);
	_tmp26_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "width", G_TYPE_FLOAT, &_tmp23_, &_tmp25_);
	_tmp27_ = _tmp26_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	G_IS_VALUE (&_tmp23_) ? (g_value_unset (&_tmp23_), NULL) : NULL;
	_tmp28_ = window_rect;
	g_value_init (&_tmp29_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp29_, (gfloat) _tmp28_.height);
	_tmp30_ = self->priv->_slot;
	g_value_init (&_tmp31_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp31_, (gfloat) (*_tmp30_).height);
	_tmp32_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "height", G_TYPE_FLOAT, &_tmp29_, &_tmp31_);
	_tmp33_ = _tmp32_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp33_);
	_g_object_unref0 (_tmp33_);
	G_IS_VALUE (&_tmp31_) ? (g_value_unset (&_tmp31_), NULL) : NULL;
	G_IS_VALUE (&_tmp29_) ? (g_value_unset (&_tmp29_), NULL) : NULL;
	g_value_init (&_tmp34_, G_TYPE_UCHAR);
	g_value_set_uchar (&_tmp34_, (guint8) 0U);
	g_value_init (&_tmp35_, G_TYPE_UCHAR);
	g_value_set_uchar (&_tmp35_, (guint8) 255U);
	_tmp36_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "shadow-opacity", G_TYPE_UCHAR, &_tmp34_, &_tmp35_);
	_tmp37_ = _tmp36_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	G_IS_VALUE (&_tmp35_) ? (g_value_unset (&_tmp35_), NULL) : NULL;
	G_IS_VALUE (&_tmp34_) ? (g_value_unset (&_tmp34_), NULL) : NULL;
	if (gala_window_clone_should_fade (self)) {
		GValue _tmp38_ = {0};
		GValue _tmp39_ = {0};
		GalaPropertyTarget* _tmp40_;
		GalaPropertyTarget* _tmp41_;
		g_value_init (&_tmp38_, G_TYPE_UCHAR);
		g_value_set_uchar (&_tmp38_, (guint8) 0U);
		g_value_init (&_tmp39_, G_TYPE_UCHAR);
		g_value_set_uchar (&_tmp39_, (guint8) 255U);
		_tmp40_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) self, "opacity", G_TYPE_UCHAR, &_tmp38_, &_tmp39_);
		_tmp41_ = _tmp40_;
		gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp41_);
		_g_object_unref0 (_tmp41_);
		G_IS_VALUE (&_tmp39_) ? (g_value_unset (&_tmp39_), NULL) : NULL;
		G_IS_VALUE (&_tmp38_) ? (g_value_unset (&_tmp38_), NULL) : NULL;
	}
	_tmp42_ = self->priv->window_icon;
	g_value_init (&_tmp43_, G_TYPE_UINT);
	g_value_set_uint (&_tmp43_, 0U);
	g_value_init (&_tmp44_, G_TYPE_UINT);
	g_value_set_uint (&_tmp44_, 255U);
	_tmp45_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, _tmp42_, "opacity", G_TYPE_UINT, &_tmp43_, &_tmp44_);
	_tmp46_ = _tmp45_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	G_IS_VALUE (&_tmp44_) ? (g_value_unset (&_tmp44_), NULL) : NULL;
	G_IS_VALUE (&_tmp43_) ? (g_value_unset (&_tmp43_), NULL) : NULL;
	_tmp47_ = self->priv->window_title;
	g_value_init (&_tmp48_, G_TYPE_UINT);
	g_value_set_uint (&_tmp48_, 0U);
	g_value_init (&_tmp49_, G_TYPE_UINT);
	g_value_set_uint (&_tmp49_, 255U);
	_tmp50_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (ClutterActor*) _tmp47_, "opacity", G_TYPE_UINT, &_tmp48_, &_tmp49_);
	_tmp51_ = _tmp50_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	G_IS_VALUE (&_tmp49_) ? (g_value_unset (&_tmp49_), NULL) : NULL;
	G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
}

static void
gala_window_clone_real_start_progress (GalaActorTarget* base,
                                       GalaGestureAction action)
{
	GalaWindowClone * self;
	gboolean _tmp0_;
	self = (GalaWindowClone*) base;
	_tmp0_ = TRUE;
	gala_window_clone_update_hover_widgets (self, &_tmp0_);
}

static void
gala_window_clone_real_update_progress (GalaActorTarget* base,
                                        GalaGestureAction action,
                                        gdouble progress)
{
	GalaWindowClone * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gfloat target_translation_y = 0.0F;
	gfloat _tmp3_;
	guint target_opacity = 0U;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	GalaTooltip* _tmp8_;
	GalaTooltip* _tmp9_;
	GalaCloseButton* _tmp10_;
	GalaCloseButton* _tmp11_;
	self = (GalaWindowClone*) base;
	if (action != GALA_GESTURE_ACTION_CLOSE_WINDOW) {
		_tmp1_ = TRUE;
	} else {
		MtkRectangle* _tmp2_;
		_tmp2_ = self->priv->_slot;
		_tmp1_ = _tmp2_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !meta_prefs_get_gnome_animations ();
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->_monitor_scale;
	target_translation_y = (gfloat) (((-GALA_WINDOW_CLONE_CLOSE_TRANSLATION) * _tmp3_) * progress);
	target_opacity = (guint) (255 * (1 - progress));
	_tmp4_ = self->priv->clone_container;
	g_object_set (_tmp4_, "translation-y", target_translation_y, NULL);
	_tmp5_ = self->priv->clone_container;
	clutter_actor_set_opacity (_tmp5_, target_opacity);
	_tmp6_ = self->priv->window_icon;
	g_object_set (_tmp6_, "translation-y", target_translation_y, NULL);
	_tmp7_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp7_, target_opacity);
	_tmp8_ = self->priv->window_title;
	g_object_set ((ClutterActor*) _tmp8_, "translation-y", target_translation_y, NULL);
	_tmp9_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp9_, target_opacity);
	_tmp10_ = self->priv->close_button;
	g_object_set ((ClutterActor*) _tmp10_, "translation-y", target_translation_y, NULL);
	_tmp11_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp11_, target_opacity);
}

static void
gala_window_clone_real_end_progress (GalaActorTarget* base,
                                     GalaGestureAction action)
{
	GalaWindowClone * self;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (GalaWindowClone*) base;
	_tmp0_ = FALSE;
	gala_window_clone_update_hover_widgets (self, &_tmp0_);
	if (action == GALA_GESTURE_ACTION_CLOSE_WINDOW) {
		_tmp2_ = gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_CLOSE_WINDOW) > 0.5;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = meta_prefs_get_gnome_animations ();
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gala_window_clone_close_window (self, (guint32) META_CURRENT_TIME);
	}
}

static void
gala_window_clone_real_allocate (ClutterActor* base,
                                 ClutterActorBox* box)
{
	GalaWindowClone * self;
	ClutterActorBox _tmp0_;
	MtkRectangle input_rect = {0};
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	MtkRectangle outer_rect = {0};
	MetaWindow* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	gfloat clone_scale_factor = 0.0F;
	gfloat _tmp5_;
	gfloat _tmp6_;
	MtkRectangle _tmp7_;
	gfloat clone_x = 0.0F;
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	gfloat clone_y = 0.0F;
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	ClutterActorBox clone_container_alloc = {0};
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	ClutterActorBox _tmp14_ = {0};
	ClutterActor* _tmp15_;
	ClutterActorBox _tmp16_;
	gboolean _tmp17_ = FALSE;
	ClutterClone* _tmp18_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp24_;
	MetaDisplay* _tmp25_;
	ClutterClone* _tmp26_;
	gfloat clone_width = 0.0F;
	gfloat clone_height = 0.0F;
	ClutterClone* _tmp27_;
	gfloat _tmp28_ = 0.0F;
	gfloat _tmp29_ = 0.0F;
	ClutterActorBox clone_alloc = {0};
	ClutterActorBox _tmp30_ = {0};
	ClutterClone* _tmp31_;
	ClutterActorBox _tmp32_;
	ClutterActorBox shape_alloc = {0};
	ClutterActorBox _tmp33_ = {0};
	GalaWindowCloneActiveShape* _tmp34_;
	ClutterActorBox _tmp35_;
	gfloat close_button_width = 0.0F;
	gfloat close_button_height = 0.0F;
	GalaCloseButton* _tmp36_;
	gfloat _tmp37_ = 0.0F;
	gfloat _tmp38_ = 0.0F;
	gfloat _tmp39_ = 0.0F;
	gfloat close_button_x = 0.0F;
	ClutterActorBox close_button_alloc = {0};
	ClutterActorBox _tmp40_ = {0};
	GalaCloseButton* _tmp41_;
	ClutterActorBox _tmp42_;
	gfloat window_icon_width = 0.0F;
	gfloat window_icon_height = 0.0F;
	ClutterActor* _tmp43_;
	gfloat _tmp44_ = 0.0F;
	gfloat _tmp45_ = 0.0F;
	gfloat window_icon_x = 0.0F;
	gfloat window_icon_y = 0.0F;
	ClutterActorBox window_icon_alloc = {0};
	ClutterActorBox _tmp46_ = {0};
	ClutterActor* _tmp47_;
	ClutterActorBox _tmp48_;
	graphene_rect_t rect = {0};
	graphene_rect_t _tmp49_ = {0};
	gint monitor_index = 0;
	MetaDisplay* _tmp50_;
	graphene_rect_t _tmp51_;
	MtkRectangle _tmp52_ = {0};
	gfloat monitor_scale = 0.0F;
	MetaDisplay* _tmp53_;
	gfloat window_title_max_width = 0.0F;
	gfloat window_title_height = 0.0F;
	gfloat window_title_nat_width = 0.0F;
	GalaTooltip* _tmp54_;
	gfloat _tmp55_ = 0.0F;
	gfloat _tmp56_ = 0.0F;
	gfloat window_title_width = 0.0F;
	gfloat window_title_x = 0.0F;
	gfloat _tmp57_ = 0.0F;
	ClutterActor* _tmp58_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	gfloat window_title_y = 0.0F;
	ClutterActorBox window_title_alloc = {0};
	ClutterActorBox _tmp61_ = {0};
	GalaTooltip* _tmp62_;
	ClutterActorBox _tmp63_;
	self = (GalaWindowClone*) base;
	g_return_if_fail (box != NULL);
	_tmp0_ = *box;
	CLUTTER_ACTOR_CLASS (gala_window_clone_parent_class)->allocate ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_ACTOR_TARGET, GalaActorTarget), (const ClutterActorBox *) (&_tmp0_));
	_tmp1_ = self->priv->_window;
	meta_window_get_buffer_rect (_tmp1_, &_tmp2_);
	input_rect = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp3_, &_tmp4_);
	outer_rect = _tmp4_;
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = outer_rect;
	clone_scale_factor = _tmp6_ / _tmp7_.width;
	_tmp8_ = input_rect;
	_tmp9_ = outer_rect;
	clone_x = (_tmp8_.x - _tmp9_.x) * clone_scale_factor;
	_tmp10_ = input_rect;
	_tmp11_ = outer_rect;
	clone_y = (_tmp10_.y - _tmp11_.y) * clone_scale_factor;
	_tmp12_ = input_rect;
	_tmp13_ = input_rect;
	gala_internal_utils_actor_box_from_rect (clone_x, clone_y, _tmp12_.width * clone_scale_factor, _tmp13_.height * clone_scale_factor, &_tmp14_);
	clone_container_alloc = _tmp14_;
	_tmp15_ = self->priv->clone_container;
	_tmp16_ = clone_container_alloc;
	clutter_actor_allocate (_tmp15_, (const ClutterActorBox *) (&_tmp16_));
	_tmp18_ = self->priv->clone;
	if (_tmp18_ == NULL) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp19_ = FALSE;
		GalaDragDropAction* _tmp20_;
		_tmp20_ = self->priv->drag_action;
		if (_tmp20_ != NULL) {
			GalaDragDropAction* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = self->priv->drag_action;
			_tmp22_ = gala_drag_drop_action_get_dragging (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp19_ = _tmp23_;
		} else {
			_tmp19_ = FALSE;
		}
		_tmp17_ = _tmp19_;
	}
	if (_tmp17_) {
		return;
	}
	_tmp24_ = self->priv->_wm;
	_tmp25_ = meta_plugin_get_display ((MetaPlugin*) _tmp24_);
	display = _tmp25_;
	_tmp26_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp26_, (gdouble) clone_scale_factor, (gdouble) clone_scale_factor);
	_tmp27_ = self->priv->clone;
	clutter_actor_get_preferred_size ((ClutterActor*) _tmp27_, NULL, NULL, &_tmp28_, &_tmp29_);
	clone_width = _tmp28_;
	clone_height = _tmp29_;
	gala_internal_utils_actor_box_from_rect ((gfloat) 0, (gfloat) 0, clone_width, clone_height, &_tmp30_);
	clone_alloc = _tmp30_;
	_tmp31_ = self->priv->clone;
	_tmp32_ = clone_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp31_, (const ClutterActorBox *) (&_tmp32_));
	_tmp33_.x1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp33_.y1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp33_.x2 = clutter_actor_box_get_width (box) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	_tmp33_.y2 = clutter_actor_box_get_height (box) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	shape_alloc = _tmp33_;
	clutter_actor_box_clamp_to_pixel (&shape_alloc);
	_tmp34_ = self->priv->active_shape;
	_tmp35_ = shape_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp34_, (const ClutterActorBox *) (&_tmp35_));
	_tmp36_ = self->priv->close_button;
	clutter_actor_get_preferred_size ((ClutterActor*) _tmp36_, NULL, NULL, &_tmp37_, &_tmp38_);
	close_button_width = _tmp37_;
	close_button_height = _tmp38_;
	if (gala_window_clone_is_close_button_on_left ()) {
		_tmp39_ = (-close_button_width) * 0.5f;
	} else {
		_tmp39_ = clutter_actor_box_get_width (box) - (close_button_width * 0.5f);
	}
	close_button_x = _tmp39_;
	gala_internal_utils_actor_box_from_rect (close_button_x, (-close_button_height) * 0.33f, close_button_width, close_button_height, &_tmp40_);
	close_button_alloc = _tmp40_;
	_tmp41_ = self->priv->close_button;
	_tmp42_ = close_button_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp41_, (const ClutterActorBox *) (&_tmp42_));
	_tmp43_ = self->priv->window_icon;
	clutter_actor_get_preferred_size (_tmp43_, NULL, NULL, &_tmp44_, &_tmp45_);
	window_icon_width = _tmp44_;
	window_icon_height = _tmp45_;
	window_icon_x = (clutter_actor_box_get_width (box) - window_icon_width) / 2;
	window_icon_y = clutter_actor_box_get_height (box) - (window_icon_height * 0.75f);
	gala_internal_utils_actor_box_from_rect (window_icon_x, window_icon_y, window_icon_width, window_icon_height, &_tmp46_);
	window_icon_alloc = _tmp46_;
	_tmp47_ = self->priv->window_icon;
	_tmp48_ = window_icon_alloc;
	clutter_actor_allocate (_tmp47_, (const ClutterActorBox *) (&_tmp48_));
	clutter_actor_get_transformed_extents ((ClutterActor*) self, &_tmp49_);
	rect = _tmp49_;
	_tmp50_ = display;
	_tmp51_ = rect;
	mtk_rectangle_from_graphene_rect (&_tmp51_, MTK_ROUNDING_STRATEGY_ROUND, &_tmp52_);
	monitor_index = meta_display_get_monitor_index_for_rect (_tmp50_, &_tmp52_);
	_tmp53_ = display;
	monitor_scale = meta_display_get_monitor_scale (_tmp53_, monitor_index);
	window_title_max_width = clutter_actor_box_get_width (box) - gala_utils_scale_to_int (GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN, monitor_scale);
	_tmp54_ = self->priv->window_title;
	clutter_actor_get_preferred_size ((ClutterActor*) _tmp54_, NULL, NULL, &_tmp55_, &_tmp56_);
	window_title_nat_width = _tmp55_;
	window_title_height = _tmp56_;
	window_title_width = CLAMP (window_title_nat_width, (gfloat) 0, window_title_max_width);
	window_title_x = (clutter_actor_box_get_width (box) - window_title_width) / 2;
	_tmp58_ = self->priv->window_icon;
	g_object_get (_tmp58_, "visible", &_tmp59_, NULL);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		_tmp57_ = window_icon_y;
	} else {
		_tmp57_ = clutter_actor_box_get_height (box);
	}
	window_title_y = (_tmp57_ - (window_title_height / 2)) - gala_utils_scale_to_int (18, monitor_scale);
	gala_internal_utils_actor_box_from_rect (window_title_x, window_title_y, window_title_width, window_title_height, &_tmp61_);
	window_title_alloc = _tmp61_;
	_tmp62_ = self->priv->window_title;
	_tmp63_ = window_title_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp62_, (const ClutterActorBox *) (&_tmp63_));
}

static gboolean
gala_window_clone_real_button_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowClone * self;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = CLUTTER_EVENT_STOP;
	return result;
}

static void
gala_window_clone_update_hover_widgets (GalaWindowClone* self,
                                        gboolean* animating)
{
	guint duration = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean show = FALSE;
	GalaCloseButton* _tmp7_;
	GalaCloseButton* _tmp8_;
	GalaCloseButton* _tmp9_;
	gint _tmp10_ = 0;
	GalaCloseButton* _tmp11_;
	GalaCloseButton* _tmp12_;
	g_return_if_fail (self != NULL);
	if (animating != NULL) {
		self->priv->in_slot_animation = *animating;
	}
	duration = gala_utils_get_animation_duration ((guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	g_object_get ((ClutterActor*) self, "has-pointer", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		GalaCloseButton* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->close_button;
		g_object_get ((ClutterActor*) _tmp4_, "has-pointer", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	}
	if (_tmp1_) {
		_tmp0_ = !self->priv->in_slot_animation;
	} else {
		_tmp0_ = FALSE;
	}
	show = _tmp0_;
	_tmp7_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp7_);
	_tmp8_ = self->priv->close_button;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp8_, CLUTTER_LINEAR);
	_tmp9_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp9_, duration);
	if (show) {
		_tmp10_ = 255;
	} else {
		_tmp10_ = 0;
	}
	_tmp11_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp11_, (guint) _tmp10_);
	_tmp12_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp12_);
}

/**
     * Send the window the delete signal and listen for new windows to be added
     * to the window's workspace, in which case we check if the new window is a
     * dialog of the window we were going to delete. If that's the case, we request
     * to select our window.
     */
static void
_gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                             gint object,
                                                                             MetaWindow* p0,
                                                                             gpointer self)
{
	gala_window_clone_check_confirm_dialog ((GalaWindowClone*) self, object, p0);
}

static void
gala_window_clone_close_window (GalaWindowClone* self,
                                guint32 timestamp)
{
	MetaDisplay* display = NULL;
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	gulong _tmp2_;
	MetaWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = g_signal_connect_object (display, "window-entered-monitor", (GCallback) _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor, self, 0);
	self->priv->check_confirm_dialog_cb = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_delete (_tmp3_, timestamp);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data62_->self;
		_g_object_unref0 (_data62_->new_window);
		_g_object_unref0 (self);
		g_slice_free (Block62Data, _data62_);
	}
}

static gboolean
__lambda10_ (Block62Data* _data62_)
{
	GalaWindowClone* self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	gboolean result;
	self = _data62_->self;
	_tmp0_ = meta_window_get_transient_for (_data62_->new_window);
	_tmp1_ = self->priv->_window;
	if (_tmp0_ == _tmp1_) {
		GalaGestureController* _tmp2_;
		MetaWindow* _tmp3_;
		MetaDisplay* _tmp4_;
		_tmp2_ = self->priv->gesture_controller;
		gala_gesture_controller_goto (_tmp2_, 0.0);
		g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
		_tmp3_ = self->priv->_window;
		_tmp4_ = meta_window_get_display (_tmp3_);
		g_signal_handler_disconnect (_tmp4_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ (self);
	return result;
}

static void
gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                        gint monitor,
                                        MetaWindow* new_window)
{
	Block62Data* _data62_;
	MetaWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_window != NULL);
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_data62_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (new_window);
	_g_object_unref0 (_data62_->new_window);
	_data62_->new_window = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, block62_data_ref (_data62_), block62_data_unref);
	block62_data_unref (_data62_);
	_data62_ = NULL;
}

/**
     * The window unmanaged by the compositor, so we need to destroy ourselves too.
     */
static void
gala_window_clone_unmanaged (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	GalaDragDropAction* _tmp1_;
	ClutterClone* _tmp6_;
	g_return_if_fail (self != NULL);
	clutter_actor_remove_all_transitions ((ClutterActor*) self);
	_tmp1_ = self->priv->drag_action;
	if (_tmp1_ != NULL) {
		GalaDragDropAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->drag_action;
		_tmp3_ = gala_drag_drop_action_get_dragging (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaDragDropAction* _tmp5_;
		_tmp5_ = self->priv->drag_action;
		gala_drag_drop_action_cancel (_tmp5_);
	}
	_tmp6_ = self->priv->clone;
	if (_tmp6_ != NULL) {
		ClutterClone* _tmp7_;
		_tmp7_ = self->priv->clone;
		clutter_actor_destroy ((ClutterActor*) _tmp7_);
	}
	if (self->priv->check_confirm_dialog_cb != ((gulong) 0)) {
		MetaWindow* _tmp8_;
		MetaDisplay* _tmp9_;
		_tmp8_ = self->priv->_window;
		_tmp9_ = meta_window_get_display (_tmp8_);
		g_signal_handler_disconnect (_tmp9_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
	clutter_actor_destroy ((ClutterActor*) self);
}

static void
gala_window_clone_actor_clicked (GalaWindowClone* self,
                                 guint32 button,
                                 ClutterInputDeviceType device_type)
{
	g_return_if_fail (self != NULL);
	if (button == CLUTTER_BUTTON_PRIMARY) {
		g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
	} else {
		gboolean _tmp0_ = FALSE;
		if (button == CLUTTER_BUTTON_MIDDLE) {
			_tmp0_ = device_type == CLUTTER_POINTER_DEVICE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GalaWindowManager* _tmp1_;
			MetaDisplay* _tmp2_;
			_tmp1_ = self->priv->_wm;
			_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
			gala_window_clone_close_window (self, meta_display_get_current_time (_tmp2_));
		}
	}
}

/**
     * A drag action has been initiated on us, we reparent ourselves to the stage so
     * we can move freely, scale ourselves to a smaller scale and request that the
     * position we just freed is immediately filled by the WindowCloneContainer.
     */
static ClutterActor*
gala_window_clone_drag_begin (GalaWindowClone* self,
                              gfloat click_x,
                              gfloat click_y)
{
	gfloat last_window_icon_x = 0.0F;
	ClutterActor* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat last_window_icon_y = 0.0F;
	ClutterActor* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	gfloat prev_parent_x = 0.0F;
	gfloat prev_parent_y = 0.0F;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	ClutterActor* _tmp11_;
	gfloat _tmp12_ = 0.0F;
	gfloat _tmp13_ = 0.0F;
	ClutterStage* stage = NULL;
	ClutterStage* _tmp14_;
	ClutterStage* _tmp15_;
	ClutterActor* _tmp16_;
	GalaWindowCloneActiveShape* _tmp17_;
	gfloat scale = 0.0F;
	ClutterActor* _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	ClutterClone* _tmp21_;
	gfloat _tmp22_;
	gfloat _tmp23_;
	guint duration = 0U;
	ClutterClone* _tmp24_;
	gfloat _tmp25_ = 0.0F;
	gfloat _tmp26_ = 0.0F;
	ClutterClone* _tmp27_;
	ClutterClone* _tmp28_;
	ClutterClone* _tmp29_;
	ClutterClone* _tmp30_;
	ClutterClone* _tmp31_;
	gfloat _tmp32_;
	gfloat _tmp33_;
	ClutterClone* _tmp34_;
	gfloat _tmp35_;
	gfloat _tmp36_;
	ClutterClone* _tmp37_;
	ClutterClone* _tmp38_;
	ClutterClone* _tmp39_;
	gfloat _tmp40_ = 0.0F;
	gfloat _tmp41_ = 0.0F;
	ClutterActor* _tmp42_;
	ClutterActor* _tmp43_;
	ClutterActor* _tmp44_;
	ClutterActor* _tmp45_;
	ClutterActor* _tmp46_;
	ClutterActor* _tmp47_;
	gfloat _tmp48_;
	gfloat _tmp49_;
	ClutterActor* _tmp50_;
	gfloat _tmp51_;
	gfloat _tmp52_;
	ClutterActor* _tmp53_;
	GalaCloseButton* _tmp54_;
	GalaTooltip* _tmp55_;
	GalaWindowManager* _tmp56_;
	MetaDisplay* _tmp57_;
	ClutterActor* _tmp58_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window_icon;
	_tmp1_ = clutter_actor_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	last_window_icon_x = _tmp2_;
	_tmp3_ = self->priv->window_icon;
	_tmp4_ = clutter_actor_get_y (_tmp3_);
	_tmp5_ = _tmp4_;
	last_window_icon_y = _tmp5_;
	_tmp6_ = clutter_actor_get_parent ((ClutterActor*) self);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->prev_parent);
	self->priv->prev_parent = _tmp7_;
	_tmp8_ = self->priv->prev_parent;
	_tmp9_ = clutter_actor_get_children (_tmp8_);
	_tmp10_ = _tmp9_;
	self->priv->prev_index = g_list_index (_tmp10_, (ClutterActor*) self);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (g_list_free (_tmp10_), NULL));
	_tmp11_ = self->priv->prev_parent;
	clutter_actor_get_transformed_position (_tmp11_, &_tmp12_, &_tmp13_);
	prev_parent_x = _tmp12_;
	prev_parent_y = _tmp13_;
	_tmp14_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) self);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	stage = _tmp15_;
	_tmp16_ = self->priv->prev_parent;
	clutter_actor_remove_child (_tmp16_, (ClutterActor*) self);
	clutter_actor_add_child ((ClutterActor*) stage, (ClutterActor*) self);
	_tmp17_ = self->priv->active_shape;
	clutter_actor_hide ((ClutterActor*) _tmp17_);
	_tmp18_ = self->priv->window_icon;
	_tmp19_ = clutter_actor_get_width (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->clone;
	_tmp22_ = clutter_actor_get_width ((ClutterActor*) _tmp21_);
	_tmp23_ = _tmp22_;
	scale = _tmp20_ / _tmp23_;
	duration = gala_utils_get_animation_duration ((guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION);
	_tmp24_ = self->priv->clone;
	clutter_actor_get_transformed_position ((ClutterActor*) _tmp24_, &_tmp25_, &_tmp26_);
	abs_x = _tmp25_;
	abs_y = _tmp26_;
	_tmp27_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp27_);
	_tmp28_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp28_, duration);
	_tmp29_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp29_, CLUTTER_EASE_IN_CUBIC);
	_tmp30_ = self->priv->clone;
	_tmp31_ = self->priv->clone;
	_tmp32_ = clutter_actor_get_width ((ClutterActor*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->priv->clone;
	_tmp35_ = clutter_actor_get_height ((ClutterActor*) _tmp34_);
	_tmp36_ = _tmp35_;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp30_, (click_x - abs_x) / _tmp33_, (click_y - abs_y) / _tmp36_);
	_tmp37_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp37_, (gdouble) scale, (gdouble) scale);
	_tmp38_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp38_, (guint) 0);
	_tmp39_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp39_);
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp40_, &_tmp41_);
	abs_x = _tmp40_;
	abs_y = _tmp41_;
	clutter_actor_set_position ((ClutterActor*) self, abs_x + prev_parent_x, abs_y + prev_parent_y);
	_tmp42_ = self->priv->window_icon;
	clutter_actor_set_position (_tmp42_, last_window_icon_x, last_window_icon_y);
	_tmp43_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp43_);
	_tmp44_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp44_, duration);
	_tmp45_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp45_, CLUTTER_EASE_IN_OUT_CUBIC);
	_tmp46_ = self->priv->window_icon;
	_tmp47_ = self->priv->window_icon;
	_tmp48_ = clutter_actor_get_width (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = self->priv->window_icon;
	_tmp51_ = clutter_actor_get_height (_tmp50_);
	_tmp52_ = _tmp51_;
	clutter_actor_set_position (_tmp46_, (click_x - (abs_x + prev_parent_x)) - (_tmp49_ / 2), (click_y - (abs_y + prev_parent_y)) - (_tmp52_ / 2));
	_tmp53_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp53_);
	_tmp54_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp54_, (guint) 0);
	_tmp55_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp55_, (guint) 0);
	_tmp56_ = self->priv->_wm;
	_tmp57_ = meta_plugin_get_display ((MetaPlugin*) _tmp56_);
	meta_display_set_cursor (_tmp57_, META_CURSOR_DND_IN_DRAG);
	_tmp58_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp58_;
	_g_object_unref0 (stage);
	return result;
}

/**
     * When we cross an IconGroup, we animate to an even smaller size and slightly
     * less opacity and add ourselves as temporary window to the group. When left,
     * we reverse those steps.
     */
static void
gala_window_clone_drag_destination_crossed (GalaWindowClone* self,
                                            ClutterActor* destination,
                                            gboolean hovered)
{
	GalaIconGroup* icon_group = NULL;
	GalaIconGroup* _tmp0_;
	GalaWorkspaceInsertThumb* insert_thumb = NULL;
	GalaWorkspaceInsertThumb* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GalaIconGroup* _tmp4_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GalaIconGroup* _tmp10_;
	gdouble _tmp17_ = 0.0;
	gdouble scale = 0.0;
	gint _tmp18_ = 0;
	gint opacity = 0;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	guint duration = 0U;
	ClutterActor* _tmp25_;
	ClutterActor* _tmp26_;
	ClutterActor* _tmp27_;
	ClutterActor* _tmp28_;
	ClutterActor* _tmp29_;
	ClutterActor* _tmp30_;
	GalaWorkspaceInsertThumb* _tmp31_;
	GalaIconGroup* _tmp34_;
	MetaCursor _tmp39_ = 0;
	GalaWindowManager* _tmp40_;
	MetaDisplay* _tmp41_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = _g_object_ref0 (GALA_IS_ICON_GROUP (destination) ? ((GalaIconGroup*) destination) : NULL);
	icon_group = _tmp0_;
	_tmp1_ = _g_object_ref0 (GALA_IS_WORKSPACE_INSERT_THUMB (destination) ? ((GalaWorkspaceInsertThumb*) destination) : NULL);
	insert_thumb = _tmp1_;
	_tmp4_ = icon_group;
	if (_tmp4_ == NULL) {
		GalaWorkspaceInsertThumb* _tmp5_;
		_tmp5_ = insert_thumb;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		GalaWorkspaceInsertThumb* _tmp7_;
		_tmp7_ = insert_thumb;
		if (_tmp7_ != NULL) {
			_tmp6_ = !meta_prefs_get_dynamic_workspaces ();
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		_g_object_unref0 (insert_thumb);
		_g_object_unref0 (icon_group);
		return;
	}
	_tmp10_ = icon_group;
	if (_tmp10_ != NULL) {
		GalaIconGroup* _tmp11_;
		MetaWorkspace* _tmp12_;
		MetaWorkspace* _tmp13_;
		MetaWindow* _tmp14_;
		MetaWorkspace* _tmp15_;
		_tmp11_ = icon_group;
		_tmp12_ = gala_icon_group_get_workspace (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_window;
		_tmp15_ = meta_window_get_workspace (_tmp14_);
		_tmp9_ = _tmp13_ == _tmp15_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		MetaWindow* _tmp16_;
		_tmp16_ = self->priv->_window;
		_tmp8_ = meta_window_is_on_primary_monitor (_tmp16_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_g_object_unref0 (insert_thumb);
		_g_object_unref0 (icon_group);
		return;
	}
	if (hovered) {
		_tmp17_ = 0.4;
	} else {
		_tmp17_ = 1.0;
	}
	scale = _tmp17_;
	if (hovered) {
		_tmp18_ = 0;
	} else {
		_tmp18_ = 255;
	}
	opacity = _tmp18_;
	if (hovered) {
		GalaWorkspaceInsertThumb* _tmp21_;
		_tmp21_ = insert_thumb;
		_tmp20_ = _tmp21_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		GalaWorkspaceInsertThumb* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = insert_thumb;
		_tmp23_ = gala_workspace_insert_thumb_get_delay (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp19_ = _tmp24_;
	} else {
		_tmp19_ = 100;
	}
	duration = (guint) _tmp19_;
	duration = gala_utils_get_animation_duration (duration);
	_tmp25_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp25_);
	_tmp26_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp26_, CLUTTER_LINEAR);
	_tmp27_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp27_, duration);
	_tmp28_ = self->priv->window_icon;
	clutter_actor_set_scale (_tmp28_, scale, scale);
	_tmp29_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp29_, (guint8) opacity);
	_tmp30_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp30_);
	_tmp31_ = insert_thumb;
	if (_tmp31_ != NULL) {
		GalaWorkspaceInsertThumb* _tmp32_;
		MetaWindow* _tmp33_;
		_tmp32_ = insert_thumb;
		_tmp33_ = self->priv->_window;
		gala_workspace_insert_thumb_set_window_thumb (_tmp32_, _tmp33_);
	}
	_tmp34_ = icon_group;
	if (_tmp34_ != NULL) {
		if (hovered) {
			GalaIconGroup* _tmp35_;
			MetaWindow* _tmp36_;
			_tmp35_ = icon_group;
			_tmp36_ = self->priv->_window;
			gala_icon_group_add_window (_tmp35_, _tmp36_, FALSE, TRUE);
		} else {
			GalaIconGroup* _tmp37_;
			MetaWindow* _tmp38_;
			_tmp37_ = icon_group;
			_tmp38_ = self->priv->_window;
			gala_icon_group_remove_window (_tmp37_, _tmp38_, FALSE);
		}
	}
	if (hovered) {
		_tmp39_ = META_CURSOR_DND_MOVE;
	} else {
		_tmp39_ = META_CURSOR_DND_IN_DRAG;
	}
	_tmp40_ = self->priv->_wm;
	_tmp41_ = meta_plugin_get_display ((MetaPlugin*) _tmp40_);
	meta_display_set_cursor (_tmp41_, _tmp39_);
	_g_object_unref0 (insert_thumb);
	_g_object_unref0 (icon_group);
}

/**
     * Depending on the destination we have different ways to find the correct destination.
     * After we found one we destroy ourselves so the dragged clone immediately disappears,
     * otherwise we cancel the drag and animate back to our old place.
     */
static void
gala_window_clone_drag_end (GalaWindowClone* self,
                            ClutterActor* destination)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspace* workspace = NULL;
	gint primary = 0;
	MetaDisplay* _tmp2_;
	GalaWindowCloneActiveShape* _tmp3_;
	MetaDisplay* _tmp4_;
	gboolean did_move = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp31_ = FALSE;
	MetaWorkspace* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	workspace = NULL;
	_tmp2_ = display;
	primary = meta_display_get_primary_monitor (_tmp2_);
	_tmp3_ = self->priv->active_shape;
	clutter_actor_show ((ClutterActor*) _tmp3_);
	_tmp4_ = display;
	meta_display_set_cursor (_tmp4_, META_CURSOR_DEFAULT);
	if (GALA_IS_ICON_GROUP (destination)) {
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		MetaWorkspace* _tmp7_;
		_tmp5_ = gala_icon_group_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_ICON_GROUP, GalaIconGroup));
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (workspace);
		workspace = _tmp7_;
	} else {
		if (GALA_IS_FRAMED_BACKGROUND (destination)) {
			ClutterActor* _tmp8_;
			MetaWorkspace* _tmp9_;
			MetaWorkspace* _tmp10_;
			MetaWorkspace* _tmp11_;
			_tmp8_ = clutter_actor_get_parent (destination);
			_tmp9_ = gala_workspace_clone_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone));
			_tmp10_ = _tmp9_;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (workspace);
			workspace = _tmp11_;
		} else {
			if (GALA_IS_WORKSPACE_INSERT_THUMB (destination)) {
				GalaWorkspaceInsertThumb* inserter = NULL;
				gboolean will_move = FALSE;
				MetaWindow* _tmp12_;
				MetaWorkspace* _tmp13_;
				GalaWorkspaceInsertThumb* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gboolean _tmp17_ = FALSE;
				GalaWorkspaceInsertThumb* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				MetaWindow* _tmp23_;
				inserter = G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
				_tmp12_ = self->priv->_window;
				_tmp13_ = meta_window_get_workspace (_tmp12_);
				_tmp14_ = inserter;
				_tmp15_ = gala_workspace_insert_thumb_get_workspace_index (_tmp14_);
				_tmp16_ = _tmp15_;
				will_move = meta_workspace_index (_tmp13_) != _tmp16_;
				if (meta_prefs_get_workspaces_only_on_primary ()) {
					MetaWindow* _tmp18_;
					_tmp18_ = self->priv->_window;
					_tmp17_ = !meta_window_is_on_primary_monitor (_tmp18_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					MetaWindow* _tmp19_;
					_tmp19_ = self->priv->_window;
					meta_window_move_to_monitor (_tmp19_, primary);
					will_move = TRUE;
				}
				_tmp20_ = inserter;
				_tmp21_ = gala_workspace_insert_thumb_get_workspace_index (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->_window;
				gala_internal_utils_insert_workspace_with_window (_tmp22_, _tmp23_);
				if (will_move) {
					gala_window_clone_unmanaged (self);
				} else {
					gala_window_clone_drag_canceled (self);
				}
				_g_object_unref0 (workspace);
				return;
			} else {
				if (GALA_IS_MONITOR_CLONE (destination)) {
					gint monitor = 0;
					gint _tmp24_;
					gint _tmp25_;
					MetaWindow* _tmp26_;
					_tmp24_ = gala_monitor_clone_get_monitor (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone));
					_tmp25_ = _tmp24_;
					monitor = _tmp25_;
					_tmp26_ = self->priv->_window;
					if (meta_window_get_monitor (_tmp26_) != monitor) {
						MetaWindow* _tmp27_;
						_tmp27_ = self->priv->_window;
						meta_window_move_to_monitor (_tmp27_, monitor);
						gala_window_clone_unmanaged (self);
					} else {
						gala_window_clone_drag_canceled (self);
					}
					_g_object_unref0 (workspace);
					return;
				}
			}
		}
	}
	did_move = FALSE;
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		MetaWindow* _tmp29_;
		_tmp29_ = self->priv->_window;
		_tmp28_ = !meta_window_is_on_primary_monitor (_tmp29_);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		MetaWindow* _tmp30_;
		_tmp30_ = self->priv->_window;
		meta_window_move_to_monitor (_tmp30_, primary);
		did_move = TRUE;
	}
	_tmp32_ = workspace;
	if (_tmp32_ != NULL) {
		MetaWorkspace* _tmp33_;
		MetaWindow* _tmp34_;
		MetaWorkspace* _tmp35_;
		_tmp33_ = workspace;
		_tmp34_ = self->priv->_window;
		_tmp35_ = meta_window_get_workspace (_tmp34_);
		_tmp31_ = _tmp33_ != _tmp35_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		MetaWindow* _tmp36_;
		MetaWorkspace* _tmp37_;
		_tmp36_ = self->priv->_window;
		_tmp37_ = workspace;
		meta_window_change_workspace (_tmp36_, _tmp37_);
		did_move = TRUE;
	}
	if (did_move) {
		gala_window_clone_unmanaged (self);
	} else {
		gala_window_clone_drag_canceled (self);
	}
	_g_object_unref0 (workspace);
}

/**
     * Animate back to our previous position with a bouncing animation.
     */
static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data63_->self;
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static void
___lambda76_ (Block63Data* _data63_)
{
	GalaWindowClone* self;
	ClutterActor* _tmp0_;
	ClutterClone* _tmp1_;
	self = _data63_->self;
	_tmp0_ = self->priv->prev_parent;
	clutter_actor_set_child_at_index (_tmp0_, (ClutterActor*) self, self->priv->prev_index);
	_tmp1_ = self->priv->clone;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data63_->handler);
}

static void
____lambda76__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                   gpointer self)
{
	___lambda76_ (self);
}

static void
gala_window_clone_drag_canceled (GalaWindowClone* self)
{
	ClutterActor* _tmp0_;
	guint duration = 0U;
	ClutterActor* _tmp1_;
	ClutterClone* _tmp2_;
	ClutterClone* _tmp3_;
	ClutterClone* _tmp4_;
	ClutterClone* _tmp5_;
	ClutterClone* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	GalaWindowManager* _tmp9_;
	MetaDisplay* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
	duration = gala_utils_get_animation_duration ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, duration);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	_tmp1_ = self->priv->prev_parent;
	clutter_actor_add_child (_tmp1_, (ClutterActor*) self);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp2_ = self->priv->clone;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp2_, 0.0f, 0.0f);
	_tmp3_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp3_);
	_tmp4_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp4_, duration);
	_tmp5_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
	_tmp6_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp6_, (gdouble) 1, (gdouble) 1);
	_tmp7_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp7_, (guint) 255);
	_tmp8_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp8_);
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	_tmp9_ = self->priv->_wm;
	_tmp10_ = meta_plugin_get_display ((MetaPlugin*) _tmp9_);
	meta_display_set_cursor (_tmp10_, META_CURSOR_DEFAULT);
	if (duration > ((guint) 0)) {
		Block63Data* _data63_;
		ClutterClone* _tmp11_;
		gulong _tmp12_;
		_data63_ = g_slice_new0 (Block63Data);
		_data63_->_ref_count_ = 1;
		_data63_->self = g_object_ref (self);
		_data63_->handler = (gulong) 0;
		_tmp11_ = self->priv->clone;
		_tmp12_ = g_signal_connect_data ((ClutterActor*) _tmp11_, "transitions-completed", (GCallback) ____lambda76__clutter_actor_transitions_completed, block63_data_ref (_data63_), (GClosureNotify) block63_data_unref, 0);
		_data63_->handler = _tmp12_;
		block63_data_unref (_data63_);
		_data63_ = NULL;
	} else {
		ClutterActor* _tmp13_;
		_tmp13_ = self->priv->prev_parent;
		clutter_actor_set_child_at_index (_tmp13_, (ClutterActor*) self, self->priv->prev_index);
	}
}

static gboolean
gala_window_clone_is_close_button_on_left (void)
{
	MetaButtonLayout layout = {0};
	MetaButtonLayout _tmp0_ = {0};
	MetaButtonLayout _tmp1_;
	gboolean result;
	meta_prefs_get_button_layout (&_tmp0_);
	layout = _tmp0_;
	_tmp1_ = layout;
	{
		MetaButtonFunction* button_function_collection = NULL;
		gint button_function_collection_length1 = 0;
		gint _button_function_collection_size_ = 0;
		gint button_function_it = 0;
		button_function_collection = _tmp1_.left_buttons;
		button_function_collection_length1 = 4;
		for (button_function_it = 0; button_function_it < button_function_collection_length1; button_function_it = button_function_it + 1) {
			MetaButtonFunction button_function = 0;
			button_function = button_function_collection[button_function_it];
			{
				if (button_function == META_BUTTON_FUNCTION_CLOSE) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

GalaWindowManager*
gala_window_clone_get_wm (GalaWindowClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_wm (GalaWindowClone* self,
                          GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WM_PROPERTY]);
	}
}

MetaWindow*
gala_window_clone_get_window (GalaWindowClone* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_window (GalaWindowClone* self,
                              MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY]);
	}
}

MtkRectangle*
gala_window_clone_get_slot (GalaWindowClone* self)
{
	MtkRectangle* result;
	MtkRectangle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_slot;
	result = _tmp0_;
	return result;
}

static gboolean
_mtk_rectangle_equal (const MtkRectangle * s1,
                      const MtkRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

static void
gala_window_clone_set_slot (GalaWindowClone* self,
                            MtkRectangle* value)
{
	MtkRectangle* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_slot (self);
	if (_mtk_rectangle_equal (value, old_value) != TRUE) {
		MtkRectangle* _tmp0_;
		_tmp0_ = __vala_MtkRectangle_copy0 (value);
		__vala_MtkRectangle_free0 (self->priv->_slot);
		self->priv->_slot = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY]);
	}
}

void
gala_window_clone_set_active (GalaWindowClone* self,
                              gboolean value)
{
	GalaWindowCloneActiveShape* _tmp0_;
	GalaWindowCloneActiveShape* _tmp1_;
	gint _tmp2_ = 0;
	GalaWindowCloneActiveShape* _tmp3_;
	GalaWindowCloneActiveShape* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_shape;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->active_shape;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, gala_utils_get_animation_duration ((guint) GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION));
	if (value) {
		_tmp2_ = 255;
	} else {
		_tmp2_ = 0;
	}
	_tmp3_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp3_, (guint) _tmp2_);
	_tmp4_ = self->priv->active_shape;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY]);
}

gboolean
gala_window_clone_get_overview_mode (GalaWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY]);
	}
}

gfloat
gala_window_clone_get_monitor_scale (GalaWindowClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_window_clone_set_monitor_scale (GalaWindowClone* self,
                                     gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY]);
	}
}

guint8
gala_window_clone_get_shadow_opacity (GalaWindowClone* self)
{
	guint8 result;
	guint8 _tmp0_ = 0U;
	GalaShadowEffect* _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->shadow_effect;
	if (_tmp1_ != NULL) {
		GalaShadowEffect* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		_tmp2_ = self->priv->shadow_effect;
		_tmp3_ = gala_shadow_effect_get_shadow_opacity (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = (guint8) 255;
	}
	result = _tmp0_;
	return result;
}

void
gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                      guint8 value)
{
	GalaShadowEffect* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shadow_effect;
	if (_tmp0_ != NULL) {
		GalaShadowEffect* _tmp1_;
		_tmp1_ = self->priv->shadow_effect;
		gala_shadow_effect_set_shadow_opacity (_tmp1_, value);
		clutter_actor_queue_redraw ((ClutterActor*) self);
	}
}

static void
gala_window_clone_active_shape_invalidate (GalaWindowCloneActiveShape* self)
{
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
}

static void
gala_window_clone_active_shape_real_draw (GalaCanvasActor* base,
                                          cairo_t* cr,
                                          gint width,
                                          gint height)
{
	GalaWindowCloneActiveShape * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GdkRGBA color = {0};
	GalaDrawingStyleManager* _tmp5_;
	GalaDrawingStyleManager* _tmp6_;
	GdkRGBA _tmp7_ = {0};
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	self = (GalaWindowCloneActiveShape*) base;
	g_return_if_fail (cr != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = clutter_actor_get_opacity ((ClutterActor*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == ((guint) 0);
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = gala_drawing_style_manager_get_instance ();
	_tmp6_ = _tmp5_;
	gala_drawing_style_manager_get_theme_accent_color (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp6_);
	color = _tmp9_;
	cairo_save (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_restore (cr);
	gala_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) GALA_WINDOW_CLONE_ACTIVE_SHAPE_BORDER_RADIUS);
	_tmp10_ = color;
	_tmp11_ = color;
	_tmp12_ = color;
	cairo_set_source_rgba (cr, _tmp10_.red, _tmp11_.green, _tmp12_.blue, GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY);
	cairo_fill (cr);
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_construct (GType object_type)
{
	GalaWindowCloneActiveShape * self = NULL;
	self = (GalaWindowCloneActiveShape*) gala_canvas_actor_construct (object_type);
	return self;
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_new (void)
{
	return gala_window_clone_active_shape_construct (GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE);
}

static void
_gala_window_clone_active_shape_invalidate_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	gala_window_clone_active_shape_invalidate ((GalaWindowCloneActiveShape*) self);
}

static GObject *
gala_window_clone_active_shape_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowCloneActiveShape * self;
	parent_class = G_OBJECT_CLASS (gala_window_clone_active_shape_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	g_signal_connect_object ((GObject*) self, "notify::opacity", (GCallback) _gala_window_clone_active_shape_invalidate_g_object_notify, self, 0);
	return obj;
}

static void
gala_window_clone_active_shape_class_init (GalaWindowCloneActiveShapeClass * klass,
                                           gpointer klass_data)
{
	gala_window_clone_active_shape_parent_class = g_type_class_peek_parent (klass);
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_window_clone_active_shape_real_draw;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_active_shape_constructor;
}

static void
gala_window_clone_active_shape_instance_init (GalaWindowCloneActiveShape * self,
                                              gpointer klass)
{
}

/**
     * Border to show around the selected window when using keyboard navigation.
     */
 G_GNUC_NO_INLINE static GType
gala_window_clone_active_shape_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneActiveShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_active_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneActiveShape), 0, (GInstanceInitFunc) gala_window_clone_active_shape_instance_init, NULL };
	GType gala_window_clone_active_shape_type_id;
	gala_window_clone_active_shape_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaWindowCloneActiveShape", &g_define_type_info, 0);
	return gala_window_clone_active_shape_type_id;
}

static GType
gala_window_clone_active_shape_get_type (void)
{
	static gsize gala_window_clone_active_shape_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_active_shape_type_id__once)) {
		GType gala_window_clone_active_shape_type_id;
		gala_window_clone_active_shape_type_id = gala_window_clone_active_shape_get_type_once ();
		g_once_init_leave (&gala_window_clone_active_shape_type_id__once, gala_window_clone_active_shape_type_id);
	}
	return gala_window_clone_active_shape_type_id__once;
}

static void
_gala_window_clone___lambda77_ (GalaWindowClone* self)
{
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
}

static void
__gala_window_clone___lambda77__meta_window_size_changed (MetaWindow* _sender,
                                                          gpointer self)
{
	_gala_window_clone___lambda77_ ((GalaWindowClone*) self);
}

static void
_gala_window_clone_update_targets_meta_window_position_changed (MetaWindow* _sender,
                                                                gpointer self)
{
	gala_window_clone_update_targets ((GalaWindowClone*) self);
}

static void
_gala_window_clone____lambda78_ (GalaWindowClone* self,
                                 ClutterClickAction* action,
                                 ClutterActor* actor)
{
	g_return_if_fail (action != NULL);
	g_return_if_fail (actor != NULL);
	gala_window_clone_actor_clicked (self, (guint32) clutter_click_action_get_button (action), CLUTTER_POINTER_DEVICE);
}

static void
__gala_window_clone____lambda78__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self)
{
	_gala_window_clone____lambda78_ ((GalaWindowClone*) self, _sender, actor);
}

static ClutterActor*
_gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                gfloat x,
                                                                gfloat y,
                                                                gpointer self)
{
	ClutterActor* result;
	result = gala_window_clone_drag_begin ((GalaWindowClone*) self, x, y);
	return result;
}

static void
_gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                       ClutterActor* destination,
                                                                                       gboolean hovered,
                                                                                       gpointer self)
{
	gala_window_clone_drag_destination_crossed ((GalaWindowClone*) self, destination, hovered);
}

static void
_gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                            ClutterActor* actor,
                                                            gpointer self)
{
	gala_window_clone_drag_end ((GalaWindowClone*) self, actor);
}

static void
_gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                      gpointer self)
{
	gala_window_clone_drag_canceled ((GalaWindowClone*) self);
}

static void
_gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                      guint32 button,
                                                                      ClutterInputDeviceType device_type,
                                                                      gpointer self)
{
	gala_window_clone_actor_clicked ((GalaWindowClone*) self, button, device_type);
}

static void
_gala_window_clone_reallocate_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	gala_window_clone_reallocate ((GalaWindowClone*) self);
}

static void
_gala_window_clone_load_clone_gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                               gpointer self)
{
	gala_window_clone_load_clone ((GalaWindowClone*) self, window_actor);
}

static void
_gala_window_clone___lambda79_ (GalaWindowClone* self)
{
	const gchar* _tmp0_ = NULL;
	MetaWindow* _tmp1_;
	const gchar* _tmp2_;
	GalaTooltip* _tmp3_;
	_tmp1_ = self->priv->_window;
	_tmp2_ = meta_window_get_title (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp3_ = self->priv->window_title;
	gala_tooltip_set_text (_tmp3_, _tmp0_);
}

static void
__gala_window_clone___lambda79__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_window_clone___lambda79_ ((GalaWindowClone*) self);
}

static void
_gala_window_clone___lambda80_ (GalaWindowClone* self)
{
	gala_window_clone_update_hover_widgets (self, NULL);
}

static void
__gala_window_clone___lambda80__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_gala_window_clone___lambda80_ ((GalaWindowClone*) self);
}

static GObject *
gala_window_clone_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowClone * self;
	GalaWindowManager* _tmp0_;
	GalaGestureController* _tmp1_;
	GalaGestureController* _tmp2_;
	GalaGestureController* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWindow* _tmp8_;
	MetaWindow* _tmp9_;
	gboolean _tmp10_;
	GalaWindowCloneActiveShape* _tmp21_;
	GalaWindowCloneActiveShape* _tmp22_;
	graphene_point_t _tmp23_ = {0};
	ClutterActor* _tmp24_ = NULL;
	GalaTooltip* _tmp25_;
	GalaWindowCloneActiveShape* _tmp26_;
	ClutterActor* _tmp27_;
	GalaTooltip* _tmp28_;
	MetaWindow* _tmp29_;
	MetaWindow* _tmp30_;
	const gchar* _tmp31_ = NULL;
	MetaWindow* _tmp32_;
	const gchar* _tmp33_;
	GalaTooltip* _tmp34_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_gesture_controller_new (GALA_GESTURE_ACTION_CLOSE_WINDOW, _tmp0_);
	_g_object_unref0 (self->priv->gesture_controller);
	self->priv->gesture_controller = _tmp1_;
	_tmp2_ = self->priv->gesture_controller;
	gala_gesture_controller_enable_scroll (_tmp2_, (ClutterActor*) self, CLUTTER_ORIENTATION_VERTICAL);
	_tmp3_ = self->priv->gesture_controller;
	gala_root_target_add_gesture_controller ((GalaRootTarget*) self, _tmp3_);
	_tmp4_ = self->priv->_window;
	g_signal_connect_object (_tmp4_, "unmanaged", (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self, 0);
	_tmp5_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::fullscreen", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp6_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::maximized-horizontally", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp7_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::maximized-vertically", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp8_ = self->priv->_window;
	g_signal_connect_object (_tmp8_, "size-changed", (GCallback) __gala_window_clone___lambda77__meta_window_size_changed, self, 0);
	_tmp9_ = self->priv->_window;
	g_signal_connect_object (_tmp9_, "position-changed", (GCallback) _gala_window_clone_update_targets_meta_window_position_changed, self, 0);
	_tmp10_ = self->priv->_overview_mode;
	if (_tmp10_) {
		ClutterClickAction* click_action = NULL;
		ClutterClickAction* _tmp11_;
		ClutterClickAction* _tmp12_;
		ClutterClickAction* _tmp13_;
		_tmp11_ = (ClutterClickAction*) clutter_click_action_new ();
		g_object_ref_sink (_tmp11_);
		click_action = _tmp11_;
		_tmp12_ = click_action;
		g_signal_connect_object (_tmp12_, "clicked", (GCallback) __gala_window_clone____lambda78__clutter_click_action_clicked, self, 0);
		_tmp13_ = click_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp13_);
		_g_object_unref0 (click_action);
	} else {
		GalaDragDropAction* _tmp14_;
		GalaDragDropAction* _tmp15_;
		GalaDragDropAction* _tmp16_;
		GalaDragDropAction* _tmp17_;
		GalaDragDropAction* _tmp18_;
		GalaDragDropAction* _tmp19_;
		GalaDragDropAction* _tmp20_;
		_tmp14_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "multitaskingview-window");
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (self->priv->drag_action);
		self->priv->drag_action = _tmp14_;
		_tmp15_ = self->priv->drag_action;
		g_signal_connect_object (_tmp15_, "drag-begin", (GCallback) _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
		_tmp16_ = self->priv->drag_action;
		g_signal_connect_object (_tmp16_, "destination-crossed", (GCallback) _gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed, self, 0);
		_tmp17_ = self->priv->drag_action;
		g_signal_connect_object (_tmp17_, "drag-end", (GCallback) _gala_window_clone_drag_end_gala_drag_drop_action_drag_end, self, 0);
		_tmp18_ = self->priv->drag_action;
		g_signal_connect_object (_tmp18_, "drag-canceled", (GCallback) _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
		_tmp19_ = self->priv->drag_action;
		g_signal_connect_object (_tmp19_, "actor-clicked", (GCallback) _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked, self, 0);
		_tmp20_ = self->priv->drag_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp20_);
	}
	_tmp21_ = gala_window_clone_active_shape_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->active_shape);
	self->priv->active_shape = _tmp21_;
	_tmp22_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp22_, (guint) 0);
	_tmp23_.x = 0.5f;
	_tmp23_.y = 0.5f;
	_tmp24_ = clutter_actor_new ();
	g_object_set (_tmp24_, "pivot-point", &_tmp23_, NULL);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->clone_container);
	self->priv->clone_container = _tmp24_;
	_tmp25_ = gala_tooltip_new ();
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->window_title);
	self->priv->window_title = _tmp25_;
	_tmp26_ = self->priv->active_shape;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp26_);
	_tmp27_ = self->priv->clone_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp27_);
	_tmp28_ = self->priv->window_title;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp28_);
	g_signal_connect_object ((GObject*) self, "notify::monitor-scale", (GCallback) _gala_window_clone_reallocate_g_object_notify, self, 0);
	gala_window_clone_reallocate (self);
	_tmp29_ = self->priv->_window;
	gala_internal_utils_wait_for_window_actor (_tmp29_, _gala_window_clone_load_clone_gala_internal_utils_window_actor_ready_callback, g_object_ref (self), g_object_unref);
	_tmp30_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::title", (GCallback) __gala_window_clone___lambda79__g_object_notify, self, 0);
	_tmp32_ = self->priv->_window;
	_tmp33_ = meta_window_get_title (_tmp32_);
	_tmp31_ = _tmp33_;
	if (_tmp31_ == NULL) {
		_tmp31_ = "";
	}
	_tmp34_ = self->priv->window_title;
	gala_tooltip_set_text (_tmp34_, _tmp31_);
	g_signal_connect_object ((GObject*) self, "notify::has-pointer", (GCallback) __gala_window_clone___lambda80__g_object_notify, self, 0);
	return obj;
}

static void
gala_window_clone_class_init (GalaWindowCloneClass * klass,
                              gpointer klass_data)
{
	gala_window_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowClone_private_offset);
	((GalaActorTargetClass *) klass)->start_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_window_clone_real_start_progress;
	((GalaActorTargetClass *) klass)->update_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_window_clone_real_update_progress;
	((GalaActorTargetClass *) klass)->end_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_window_clone_real_end_progress;
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, const ClutterActorBox *)) gala_window_clone_real_allocate;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WM_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WINDOW_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The currently assigned slot of the window in the tiling layout. May be null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SLOT_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY] = g_param_spec_boxed ("slot", "slot", "slot", mtk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * When active fades a white border around the window in. Used for the visually
	     * indicating the WindowCloneContainer's current_window.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_ACTIVE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	     * The window was selected. The MultitaskingView should consider activating
	     * the window and closing the view.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * The window was moved or resized and a relayout of the tiling layout may
	     * be sensible right now.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL] = g_signal_new ("request-reposition", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_gala_root_target_interface_init (GalaRootTargetIface * iface,
                                                   gpointer iface_data)
{
	gala_window_clone_gala_root_target_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_window_clone_instance_init (GalaWindowClone * self,
                                 gpointer klass)
{
	self->priv = gala_window_clone_get_instance_private (self);
	self->priv->_slot = NULL;
	self->priv->drag_action = NULL;
	self->priv->clone = NULL;
	self->priv->shadow_effect = NULL;
	self->priv->prev_parent = NULL;
	self->priv->prev_index = -1;
	self->priv->check_confirm_dialog_cb = (gulong) 0;
	self->priv->in_slot_animation = FALSE;
}

static void
gala_window_clone_finalize (GObject * obj)
{
	GalaWindowClone * self;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	MetaWindow* _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	MetaWindow* _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	MetaWindow* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	_tmp0_ = self->priv->_window;
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self);
	_tmp2_ = self->priv->_window;
	g_signal_parse_name ("notify::fullscreen", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp5_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-horizontally", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp8_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-vertically", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_window);
	__vala_MtkRectangle_free0 (self->priv->_slot);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->prev_parent);
	_g_object_unref0 (self->priv->clone_container);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->active_shape);
	_g_object_unref0 (self->priv->window_icon);
	_g_object_unref0 (self->priv->window_title);
	_g_object_unref0 (self->priv->gesture_controller);
	G_OBJECT_CLASS (gala_window_clone_parent_class)->finalize (obj);
}

/**
 * A container for a clone of the texture of a MetaWindow, a WindowIcon, a Tooltip with the title,
 * a close button and a shadow. Used together with the WindowCloneContainer.
 */
 G_GNUC_NO_INLINE static GType
gala_window_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowClone), 0, (GInstanceInitFunc) gala_window_clone_instance_init, NULL };
	static const GInterfaceInfo gala_root_target_info = { (GInterfaceInitFunc) gala_window_clone_gala_root_target_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_clone_type_id;
	gala_window_clone_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWindowClone", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_clone_type_id, GALA_TYPE_ROOT_TARGET, &gala_root_target_info);
	GalaWindowClone_private_offset = g_type_add_instance_private (gala_window_clone_type_id, sizeof (GalaWindowClonePrivate));
	return gala_window_clone_type_id;
}

GType
gala_window_clone_get_type (void)
{
	static gsize gala_window_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_type_id__once)) {
		GType gala_window_clone_type_id;
		gala_window_clone_type_id = gala_window_clone_get_type_once ();
		g_once_init_leave (&gala_window_clone_type_id__once, gala_window_clone_type_id);
	}
	return gala_window_clone_type_id__once;
}

static void
_vala_gala_window_clone_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_wm (self));
		break;
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_window (self));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		{
			MtkRectangle* boxed;
			boxed = gala_window_clone_get_slot (self);
			g_value_set_boxed (value, boxed);
		}
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_get_overview_mode (self));
		break;
		case GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_clone_get_monitor_scale (self));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_window_clone_get_shadow_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WM_PROPERTY:
		gala_window_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		gala_window_clone_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		gala_window_clone_set_slot (self, g_value_get_boxed (value));
		break;
		case GALA_WINDOW_CLONE_ACTIVE_PROPERTY:
		gala_window_clone_set_active (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_set_overview_mode (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_MONITOR_SCALE_PROPERTY:
		gala_window_clone_set_monitor_scale (self, g_value_get_float (value));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		gala_window_clone_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

