/* DwellClickTimer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DwellClickTimer.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2020, 2025 elementary, Inc. (https://elementary.io)
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cogl/cogl.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <gdk/gdk.h>
#include "gala.h"
#include <stdlib.h>
#include <string.h>
#include <meta/meta-cursor-tracker.h>
#include <graphene-gobject.h>

#define GALA_DWELL_CLICK_TIMER_BACKGROUND_OPACITY 0.7
#define GALA_DWELL_CLICK_TIMER_BORDER_WIDTH_PX 1
#define GALA_DWELL_CLICK_TIMER_START_ANGLE ((3 * G_PI) / 2)
#define GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT ((gdouble) 185)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_DWELL_CLICK_TIMER (gala_dwell_click_timer_get_type ())
#define GALA_DWELL_CLICK_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer))
#define GALA_DWELL_CLICK_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimerClass))
#define GALA_IS_DWELL_CLICK_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DWELL_CLICK_TIMER))
#define GALA_IS_DWELL_CLICK_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DWELL_CLICK_TIMER))
#define GALA_DWELL_CLICK_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimerClass))

typedef struct _GalaDwellClickTimer GalaDwellClickTimer;
typedef struct _GalaDwellClickTimerClass GalaDwellClickTimerClass;
typedef struct _GalaDwellClickTimerPrivate GalaDwellClickTimerPrivate;
enum  {
	GALA_DWELL_CLICK_TIMER_0_PROPERTY,
	GALA_DWELL_CLICK_TIMER_DISPLAY_PROPERTY,
	GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY,
	GALA_DWELL_CLICK_TIMER_NUM_PROPERTIES
};
static GParamSpec* gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GalaDwellClickTimer {
	ClutterActor parent_instance;
	GalaDwellClickTimerPrivate * priv;
};

struct _GalaDwellClickTimerClass {
	ClutterActorClass parent_class;
};

struct _GalaDwellClickTimerPrivate {
	gfloat scaling_factor;
	gint cursor_size;
	CoglPipeline* pipeline;
	ClutterPropertyTransition* transition;
	cairo_pattern_t* stroke_color;
	cairo_pattern_t* fill_color;
	GSettings* interface_settings;
	cairo_surface_t* surface;
	MetaDisplay* _display;
	gdouble _angle;
};

static gint GalaDwellClickTimer_private_offset;
static gpointer gala_dwell_click_timer_parent_class = NULL;
static ClutterAnimatableInterface * gala_dwell_click_timer_clutter_animatable_parent_iface = NULL;

VALA_EXTERN GType gala_dwell_click_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDwellClickTimer, g_object_unref)
VALA_EXTERN GalaDwellClickTimer* gala_dwell_click_timer_new (MetaDisplay* display);
VALA_EXTERN GalaDwellClickTimer* gala_dwell_click_timer_construct (GType object_type,
                                                       MetaDisplay* display);
static void gala_dwell_click_timer_update_cursor_size (GalaDwellClickTimer* self,
                                                gfloat scale);
static void gala_dwell_click_timer_real_paint (ClutterActor* base,
                                        ClutterPaintContext* context);
VALA_EXTERN gdouble gala_dwell_click_timer_get_angle (GalaDwellClickTimer* self);
static gboolean gala_dwell_click_timer_real_interpolate_value (ClutterAnimatable* base,
                                                        const gchar* property_name,
                                                        ClutterInterval* interval,
                                                        gdouble progress,
                                                        GValue* value);
VALA_EXTERN MetaDisplay* gala_dwell_click_timer_get_display (GalaDwellClickTimer* self);
static void gala_dwell_click_timer_set_display (GalaDwellClickTimer* self,
                                         MetaDisplay* value);
VALA_EXTERN void gala_dwell_click_timer_set_angle (GalaDwellClickTimer* self,
                                       gdouble value);
static GObject * gala_dwell_click_timer_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _gala_dwell_click_timer___lambda147_ (GalaDwellClickTimer* self);
static void __gala_dwell_click_timer___lambda147__clutter_timeline_new_frame (ClutterTimeline* _sender,
                                                                       gint msecs,
                                                                       gpointer self);
static void _gala_dwell_click_timer___lambda148_ (GalaDwellClickTimer* self,
                                           ClutterInputDevice* device,
                                           ClutterPointerA11yTimeoutType type,
                                           guint timeout);
static void __gala_dwell_click_timer___lambda148__clutter_seat_ptr_a11y_timeout_started (ClutterSeat* _sender,
                                                                                  ClutterInputDevice* device,
                                                                                  ClutterPointerA11yTimeoutType timeout_type,
                                                                                  guint delay,
                                                                                  gpointer self);
static void _gala_dwell_click_timer___lambda149_ (GalaDwellClickTimer* self,
                                           ClutterInputDevice* device,
                                           ClutterPointerA11yTimeoutType type,
                                           gboolean clicked);
static void __gala_dwell_click_timer___lambda149__clutter_seat_ptr_a11y_timeout_stopped (ClutterSeat* _sender,
                                                                                  ClutterInputDevice* device,
                                                                                  ClutterPointerA11yTimeoutType timeout_type,
                                                                                  gboolean clicked,
                                                                                  gpointer self);
static void gala_dwell_click_timer_finalize (GObject * obj);
static GType gala_dwell_click_timer_get_type_once (void);
static void _vala_gala_dwell_click_timer_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_dwell_click_timer_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
gala_dwell_click_timer_get_instance_private (GalaDwellClickTimer* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDwellClickTimer_private_offset);
}

GalaDwellClickTimer*
gala_dwell_click_timer_construct (GType object_type,
                                  MetaDisplay* display)
{
	GalaDwellClickTimer * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaDwellClickTimer*) g_object_new (object_type, "display", display, NULL);
	return self;
}

GalaDwellClickTimer*
gala_dwell_click_timer_new (MetaDisplay* display)
{
	return gala_dwell_click_timer_construct (GALA_TYPE_DWELL_CLICK_TIMER, display);
}

static void
gala_dwell_click_timer_update_cursor_size (GalaDwellClickTimer* self,
                                           gfloat scale)
{
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	cairo_surface_t* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->scaling_factor = scale;
	_tmp0_ = self->priv->interface_settings;
	self->priv->cursor_size = (gint) ((g_settings_get_int (_tmp0_, "cursor-size") * self->priv->scaling_factor) * 1.25);
	_tmp3_ = self->priv->surface;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		cairo_surface_t* _tmp4_;
		_tmp4_ = self->priv->surface;
		_tmp2_ = cairo_image_surface_get_width (_tmp4_) != self->priv->cursor_size;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		cairo_surface_t* _tmp5_;
		_tmp5_ = self->priv->surface;
		_tmp1_ = cairo_image_surface_get_height (_tmp5_) != self->priv->cursor_size;
	}
	if (_tmp1_) {
		cairo_surface_t* _tmp6_;
		_tmp6_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, self->priv->cursor_size, self->priv->cursor_size);
		_cairo_surface_destroy0 (self->priv->surface);
		self->priv->surface = _tmp6_;
	}
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) self->priv->cursor_size, (gfloat) self->priv->cursor_size);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_dwell_click_timer_real_paint (ClutterActor* base,
                                   ClutterPaintContext* context)
{
	GalaDwellClickTimer * self;
	gdouble _tmp0_;
	GdkRGBA rgba = {0};
	GalaDrawingStyleManager* _tmp1_;
	GalaDrawingStyleManager* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	cairo_pattern_t* _tmp9_;
	GdkRGBA _tmp10_;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	cairo_pattern_t* _tmp13_;
	gint radius = 0;
	gdouble end_angle = 0.0;
	gdouble _tmp14_;
	gint border_width = 0;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_pattern_t* _tmp31_;
	cairo_t* _tmp32_;
	cairo_t* _tmp33_;
	cairo_t* _tmp34_;
	cairo_pattern_t* _tmp35_;
	cairo_t* _tmp36_;
	CoglContext* cogl_context = NULL;
	CoglFramebuffer* _tmp37_;
	CoglContext* _tmp38_;
	CoglContext* _tmp39_;
	GError* _inner_error0_ = NULL;
	self = (GalaDwellClickTimer*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->_angle;
	if (_tmp0_ == ((gdouble) 0)) {
		return;
	}
	_tmp1_ = gala_drawing_style_manager_get_instance ();
	_tmp2_ = _tmp1_;
	gala_drawing_style_manager_get_theme_accent_color (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	rgba = _tmp5_;
	_tmp6_ = rgba;
	_tmp7_ = rgba;
	_tmp8_ = rgba;
	_tmp9_ = cairo_pattern_create_rgb (_tmp6_.red, _tmp7_.green, _tmp8_.blue);
	_cairo_pattern_destroy0 (self->priv->stroke_color);
	self->priv->stroke_color = _tmp9_;
	_tmp10_ = rgba;
	_tmp11_ = rgba;
	_tmp12_ = rgba;
	_tmp13_ = cairo_pattern_create_rgba (_tmp10_.red, _tmp11_.green, _tmp12_.blue, GALA_DWELL_CLICK_TIMER_BACKGROUND_OPACITY);
	_cairo_pattern_destroy0 (self->priv->fill_color);
	self->priv->fill_color = _tmp13_;
	radius = MIN (self->priv->cursor_size / 2, self->priv->cursor_size / 2);
	_tmp14_ = self->priv->_angle;
	end_angle = GALA_DWELL_CLICK_TIMER_START_ANGLE + _tmp14_;
	border_width = gala_utils_scale_to_int (GALA_DWELL_CLICK_TIMER_BORDER_WIDTH_PX, self->priv->scaling_factor);
	_tmp15_ = self->priv->surface;
	_tmp16_ = cairo_create (_tmp15_);
	cr = _tmp16_;
	_tmp17_ = cr;
	cairo_save (_tmp17_);
	_tmp18_ = cr;
	cairo_set_source_rgba (_tmp18_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp19_ = cr;
	cairo_set_operator (_tmp19_, CAIRO_OPERATOR_SOURCE);
	_tmp20_ = cr;
	cairo_paint (_tmp20_);
	_tmp21_ = cr;
	cairo_restore (_tmp21_);
	_tmp22_ = cr;
	cairo_set_line_cap (_tmp22_, CAIRO_LINE_CAP_ROUND);
	_tmp23_ = cr;
	cairo_set_line_join (_tmp23_, CAIRO_LINE_JOIN_ROUND);
	_tmp24_ = cr;
	cairo_translate (_tmp24_, (gdouble) (self->priv->cursor_size / 2), (gdouble) (self->priv->cursor_size / 2));
	_tmp25_ = cr;
	cairo_move_to (_tmp25_, (gdouble) 0, (gdouble) 0);
	_tmp26_ = cr;
	cairo_arc (_tmp26_, (gdouble) 0, (gdouble) 0, (gdouble) (radius - border_width), GALA_DWELL_CLICK_TIMER_START_ANGLE, end_angle);
	_tmp27_ = cr;
	cairo_line_to (_tmp27_, (gdouble) 0, (gdouble) 0);
	_tmp28_ = cr;
	cairo_close_path (_tmp28_);
	_tmp29_ = cr;
	cairo_set_line_width (_tmp29_, (gdouble) 0);
	_tmp30_ = cr;
	_tmp31_ = self->priv->fill_color;
	cairo_set_source (_tmp30_, _tmp31_);
	_tmp32_ = cr;
	cairo_fill_preserve (_tmp32_);
	_tmp33_ = cr;
	cairo_set_line_width (_tmp33_, (gdouble) border_width);
	_tmp34_ = cr;
	_tmp35_ = self->priv->stroke_color;
	cairo_set_source (_tmp34_, _tmp35_);
	_tmp36_ = cr;
	cairo_stroke (_tmp36_);
	_tmp37_ = clutter_paint_context_get_framebuffer (context);
	_tmp38_ = cogl_framebuffer_get_context (_tmp37_);
	_tmp39_ = _g_object_ref0 (_tmp38_);
	cogl_context = _tmp39_;
	{
		CoglTexture2D* texture = NULL;
		CoglContext* _tmp40_;
		cairo_surface_t* _tmp41_;
		cairo_surface_t* _tmp42_;
		guchar* _tmp43_;
		CoglTexture2D* _tmp44_;
		CoglPipeline* _tmp45_;
		CoglTexture2D* _tmp46_;
		CoglFramebuffer* _tmp47_;
		CoglPipeline* _tmp48_;
		_tmp40_ = cogl_context;
		_tmp41_ = self->priv->surface;
		_tmp42_ = self->priv->surface;
		_tmp43_ = cairo_image_surface_get_data (_tmp42_);
		_tmp44_ = (CoglTexture2D*) cogl_texture_2d_new_from_data (_tmp40_, self->priv->cursor_size, self->priv->cursor_size, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp41_), _tmp43_, &_inner_error0_);
		texture = _tmp44_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp45_ = self->priv->pipeline;
		_tmp46_ = texture;
		cogl_pipeline_set_layer_texture (_tmp45_, 0, (CoglTexture*) _tmp46_);
		_tmp47_ = clutter_paint_context_get_framebuffer (context);
		_tmp48_ = self->priv->pipeline;
		cogl_framebuffer_draw_rectangle (_tmp47_, _tmp48_, (gfloat) 0, (gfloat) 0, (gfloat) self->priv->cursor_size, (gfloat) self->priv->cursor_size);
		_g_object_unref0 (texture);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (cogl_context);
		_cairo_destroy0 (cr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	CLUTTER_ACTOR_CLASS (gala_dwell_click_timer_parent_class)->paint (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), context);
	_g_object_unref0 (cogl_context);
	_cairo_destroy0 (cr);
}

static gboolean
gala_dwell_click_timer_real_interpolate_value (ClutterAnimatable* base,
                                               const gchar* property_name,
                                               ClutterInterval* interval,
                                               gdouble progress,
                                               GValue* value)
{
	GalaDwellClickTimer * self;
	GValue _vala_value = {0};
	GValue _tmp6_ = {0};
	gboolean _tmp7_;
	gboolean result;
	self = (GalaDwellClickTimer*) base;
	g_return_val_if_fail (property_name != NULL, FALSE);
	g_return_val_if_fail (interval != NULL, FALSE);
	if (g_strcmp0 (property_name, "angle") == 0) {
		GValue _tmp0_ = {0};
		guint elapsed_time = 0U;
		ClutterPropertyTransition* _tmp1_;
		g_value_init (&_tmp0_, G_TYPE_INT);
		g_value_set_int (&_tmp0_, 0);
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
		_vala_value = _tmp0_;
		_tmp1_ = self->priv->transition;
		elapsed_time = clutter_timeline_get_elapsed_time ((ClutterTimeline*) _tmp1_);
		if (((gdouble) elapsed_time) > GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT) {
			gdouble delayed_progress = 0.0;
			ClutterPropertyTransition* _tmp2_;
			guint _tmp3_;
			guint _tmp4_;
			GValue _tmp5_ = {0};
			_tmp2_ = self->priv->transition;
			_tmp3_ = clutter_timeline_get_duration ((ClutterTimeline*) _tmp2_);
			_tmp4_ = _tmp3_;
			delayed_progress = (elapsed_time - GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT) / (_tmp4_ - GALA_DWELL_CLICK_TIMER_DELAY_TIMEOUT);
			g_value_init (&_tmp5_, G_TYPE_DOUBLE);
			g_value_set_double (&_tmp5_, (delayed_progress * 2) * G_PI);
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
			_vala_value = _tmp5_;
		}
		result = TRUE;
		if (value) {
			*value = _vala_value;
		} else {
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
		}
		return result;
	}
	_tmp7_ = gala_dwell_click_timer_clutter_animatable_parent_iface->interpolate_value ((ClutterAnimatable*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), property_name, interval, progress, &_tmp6_);
	G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	_vala_value = _tmp6_;
	result = _tmp7_;
	if (value) {
		*value = _vala_value;
	} else {
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	}
	return result;
}

MetaDisplay*
gala_dwell_click_timer_get_display (GalaDwellClickTimer* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_dwell_click_timer_set_display (GalaDwellClickTimer* self,
                                    MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_dwell_click_timer_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_DISPLAY_PROPERTY]);
	}
}

gdouble
gala_dwell_click_timer_get_angle (GalaDwellClickTimer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_angle;
	return result;
}

void
gala_dwell_click_timer_set_angle (GalaDwellClickTimer* self,
                                  gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_dwell_click_timer_get_angle (self);
	if (old_value != value) {
		self->priv->_angle = value;
		g_object_notify_by_pspec ((GObject *) self, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY]);
	}
}

static void
_gala_dwell_click_timer___lambda147_ (GalaDwellClickTimer* self)
{
	clutter_actor_queue_redraw ((ClutterActor*) self);
}

static void
__gala_dwell_click_timer___lambda147__clutter_timeline_new_frame (ClutterTimeline* _sender,
                                                                  gint msecs,
                                                                  gpointer self)
{
	_gala_dwell_click_timer___lambda147_ ((GalaDwellClickTimer*) self);
}

static void
_gala_dwell_click_timer___lambda148_ (GalaDwellClickTimer* self,
                                      ClutterInputDevice* device,
                                      ClutterPointerA11yTimeoutType type,
                                      guint timeout)
{
	gfloat scale = 0.0F;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaCursorTracker* tracker = NULL;
	MetaDisplay* _tmp2_;
	MetaCursorTracker* _tmp3_;
	graphene_point_t coords = {0};
	graphene_point_t _tmp4_ = {0};
	MetaCursorTracker* _tmp5_;
	graphene_point_t _tmp6_ = {0};
	graphene_point_t _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	graphene_point_t _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	ClutterPropertyTransition* _tmp13_;
	ClutterPropertyTransition* _tmp14_;
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp0_, meta_display_get_current_monitor (_tmp1_));
	gala_dwell_click_timer_update_cursor_size (self, scale);
	_tmp2_ = self->priv->_display;
	_tmp3_ = meta_cursor_tracker_get_for_display (_tmp2_);
	tracker = _tmp3_;
	coords = _tmp4_;
	_tmp5_ = tracker;
	meta_cursor_tracker_get_pointer (_tmp5_, &_tmp6_, NULL);
	coords = _tmp6_;
	_tmp7_ = coords;
	_tmp8_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp9_ = _tmp8_;
	clutter_actor_set_x ((ClutterActor*) self, _tmp7_.x - (_tmp9_ / 2));
	_tmp10_ = coords;
	_tmp11_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	clutter_actor_set_y ((ClutterActor*) self, _tmp10_.y - (_tmp12_ / 2));
	_tmp13_ = self->priv->transition;
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp13_, timeout);
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	_tmp14_ = self->priv->transition;
	clutter_timeline_start ((ClutterTimeline*) _tmp14_);
}

static void
__gala_dwell_click_timer___lambda148__clutter_seat_ptr_a11y_timeout_started (ClutterSeat* _sender,
                                                                             ClutterInputDevice* device,
                                                                             ClutterPointerA11yTimeoutType timeout_type,
                                                                             guint delay,
                                                                             gpointer self)
{
	_gala_dwell_click_timer___lambda148_ ((GalaDwellClickTimer*) self, device, timeout_type, delay);
}

static void
_gala_dwell_click_timer___lambda149_ (GalaDwellClickTimer* self,
                                      ClutterInputDevice* device,
                                      ClutterPointerA11yTimeoutType type,
                                      gboolean clicked)
{
	ClutterPropertyTransition* _tmp0_;
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->transition;
	clutter_timeline_stop ((ClutterTimeline*) _tmp0_);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
}

static void
__gala_dwell_click_timer___lambda149__clutter_seat_ptr_a11y_timeout_stopped (ClutterSeat* _sender,
                                                                             ClutterInputDevice* device,
                                                                             ClutterPointerA11yTimeoutType timeout_type,
                                                                             gboolean clicked,
                                                                             gpointer self)
{
	_gala_dwell_click_timer___lambda149_ ((GalaDwellClickTimer*) self, device, timeout_type, clicked);
}

static GObject *
gala_dwell_click_timer_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaDwellClickTimer * self;
	ClutterBackend* backend = NULL;
	ClutterBackend* _tmp0_;
	ClutterBackend* _tmp1_;
	CoglContext* _tmp2_;
	CoglPipeline* _tmp3_;
	ClutterPropertyTransition* _tmp4_;
	ClutterPropertyTransition* _tmp5_;
	ClutterPropertyTransition* _tmp6_;
	ClutterPropertyTransition* _tmp7_;
	GValue _tmp8_ = {0};
	ClutterPropertyTransition* _tmp9_;
	GValue _tmp10_ = {0};
	ClutterPropertyTransition* _tmp11_;
	GSettings* _tmp12_;
	ClutterSeat* seat = NULL;
	ClutterBackend* _tmp13_;
	ClutterSeat* _tmp14_;
	ClutterSeat* _tmp15_;
	ClutterSeat* _tmp16_;
	ClutterSeat* _tmp17_;
	ClutterSeat* _tmp18_;
	parent_class = G_OBJECT_CLASS (gala_dwell_click_timer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, FALSE);
	_tmp0_ = clutter_get_default_backend ();
	backend = _tmp0_;
	_tmp1_ = backend;
	_tmp2_ = clutter_backend_get_cogl_context (_tmp1_);
	_tmp3_ = cogl_pipeline_new (_tmp2_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp3_;
	_tmp4_ = (ClutterPropertyTransition*) clutter_property_transition_new ("angle");
	_g_object_unref0 (self->priv->transition);
	self->priv->transition = _tmp4_;
	_tmp5_ = self->priv->transition;
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
	_tmp6_ = self->priv->transition;
	clutter_transition_set_animatable ((ClutterTransition*) _tmp6_, (ClutterAnimatable*) self);
	_tmp7_ = self->priv->transition;
	g_value_init (&_tmp8_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp8_, GALA_DWELL_CLICK_TIMER_START_ANGLE);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp7_, &_tmp8_);
	G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
	_tmp9_ = self->priv->transition;
	g_value_init (&_tmp10_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp10_, GALA_DWELL_CLICK_TIMER_START_ANGLE + (2 * G_PI));
	clutter_transition_set_to_value ((ClutterTransition*) _tmp9_, &_tmp10_);
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	_tmp11_ = self->priv->transition;
	g_signal_connect_object ((ClutterTimeline*) _tmp11_, "new-frame", (GCallback) __gala_dwell_click_timer___lambda147__clutter_timeline_new_frame, self, 0);
	_tmp12_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp12_;
	_tmp13_ = backend;
	_tmp14_ = clutter_backend_get_default_seat (_tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	seat = _tmp15_;
	_tmp16_ = seat;
	clutter_seat_set_pointer_a11y_dwell_click_type (_tmp16_, CLUTTER_A11Y_DWELL_CLICK_TYPE_PRIMARY);
	_tmp17_ = seat;
	g_signal_connect_object (_tmp17_, "ptr-a11y-timeout-started", (GCallback) __gala_dwell_click_timer___lambda148__clutter_seat_ptr_a11y_timeout_started, self, 0);
	_tmp18_ = seat;
	g_signal_connect_object (_tmp18_, "ptr-a11y-timeout-stopped", (GCallback) __gala_dwell_click_timer___lambda149__clutter_seat_ptr_a11y_timeout_stopped, self, 0);
	_g_object_unref0 (seat);
	return obj;
}

static void
gala_dwell_click_timer_class_init (GalaDwellClickTimerClass * klass,
                                   gpointer klass_data)
{
	gala_dwell_click_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDwellClickTimer_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_dwell_click_timer_real_paint;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_dwell_click_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_dwell_click_timer_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_dwell_click_timer_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_dwell_click_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DWELL_CLICK_TIMER_DISPLAY_PROPERTY, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY, gala_dwell_click_timer_properties[GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY] = g_param_spec_double ("angle", "angle", "angle", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_dwell_click_timer_clutter_animatable_interface_init (ClutterAnimatableInterface * iface,
                                                          gpointer iface_data)
{
	gala_dwell_click_timer_clutter_animatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->interpolate_value = (gboolean (*) (ClutterAnimatable*, const gchar*, ClutterInterval*, gdouble, GValue*)) gala_dwell_click_timer_real_interpolate_value;
}

static void
gala_dwell_click_timer_instance_init (GalaDwellClickTimer * self,
                                      gpointer klass)
{
	self->priv = gala_dwell_click_timer_get_instance_private (self);
	self->priv->scaling_factor = 1.0f;
	self->priv->cursor_size = 24;
}

static void
gala_dwell_click_timer_finalize (GObject * obj)
{
	GalaDwellClickTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->transition);
	_cairo_pattern_destroy0 (self->priv->stroke_color);
	_cairo_pattern_destroy0 (self->priv->fill_color);
	_g_object_unref0 (self->priv->interface_settings);
	_cairo_surface_destroy0 (self->priv->surface);
	_g_object_unref0 (self->priv->_display);
	G_OBJECT_CLASS (gala_dwell_click_timer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_dwell_click_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDwellClickTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_dwell_click_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDwellClickTimer), 0, (GInstanceInitFunc) gala_dwell_click_timer_instance_init, NULL };
	static const GInterfaceInfo clutter_animatable_info = { (GInterfaceInitFunc) gala_dwell_click_timer_clutter_animatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_dwell_click_timer_type_id;
	gala_dwell_click_timer_type_id = g_type_register_static (clutter_actor_get_type (), "GalaDwellClickTimer", &g_define_type_info, 0);
	g_type_add_interface_static (gala_dwell_click_timer_type_id, clutter_animatable_get_type (), &clutter_animatable_info);
	GalaDwellClickTimer_private_offset = g_type_add_instance_private (gala_dwell_click_timer_type_id, sizeof (GalaDwellClickTimerPrivate));
	return gala_dwell_click_timer_type_id;
}

GType
gala_dwell_click_timer_get_type (void)
{
	static gsize gala_dwell_click_timer_type_id__once = 0;
	if (g_once_init_enter (&gala_dwell_click_timer_type_id__once)) {
		GType gala_dwell_click_timer_type_id;
		gala_dwell_click_timer_type_id = gala_dwell_click_timer_get_type_once ();
		g_once_init_leave (&gala_dwell_click_timer_type_id__once, gala_dwell_click_timer_type_id);
	}
	return gala_dwell_click_timer_type_id__once;
}

static void
_vala_gala_dwell_click_timer_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaDwellClickTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	switch (property_id) {
		case GALA_DWELL_CLICK_TIMER_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_dwell_click_timer_get_display (self));
		break;
		case GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY:
		g_value_set_double (value, gala_dwell_click_timer_get_angle (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_dwell_click_timer_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaDwellClickTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DWELL_CLICK_TIMER, GalaDwellClickTimer);
	switch (property_id) {
		case GALA_DWELL_CLICK_TIMER_DISPLAY_PROPERTY:
		gala_dwell_click_timer_set_display (self, g_value_get_object (value));
		break;
		case GALA_DWELL_CLICK_TIMER_ANGLE_PROPERTY:
		gala_dwell_click_timer_set_angle (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

