/* FontList.c generated by valac 0.56.18, the Vala compiler
 * generated from FontList.vala, do not modify */

/* FontList.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include "font-manager.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL (font_manager_google_fonts_font_model_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModel))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModelClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModelClass))

typedef struct _FontManagerGoogleFontsFontModel FontManagerGoogleFontsFontModel;
typedef struct _FontManagerGoogleFontsFontModelClass FontManagerGoogleFontsFontModelClass;
typedef struct _FontManagerGoogleFontsFontModelPrivate FontManagerGoogleFontsFontModelPrivate;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY (font_manager_google_fonts_family_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily))
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamilyClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY))
#define FONT_MANAGER_GOOGLE_FONTS_FAMILY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamilyClass))

typedef struct _FontManagerGoogleFontsFamily FontManagerGoogleFontsFamily;
typedef struct _FontManagerGoogleFontsFamilyClass FontManagerGoogleFontsFamilyClass;

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER (font_manager_font_list_filter_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter))
#define FONT_MANAGER_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_FONT_LIST_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))

typedef struct _FontManagerFontListFilter FontManagerFontListFilter;
typedef struct _FontManagerFontListFilterClass FontManagerFontListFilterClass;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ENTRIES_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ITEMS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_SEARCH_TERM_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_FILTER_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_NUM_PROPERTIES];
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT (font_manager_google_fonts_font_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFontClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFontClass))

typedef struct _FontManagerGoogleFontsFont FontManagerGoogleFontsFont;
typedef struct _FontManagerGoogleFontsFontClass FontManagerGoogleFontsFontClass;
typedef struct _Block34Data Block34Data;
typedef enum  {
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_THIN = 100,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_LIGHT = 200,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_LIGHT = 300,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_REGULAR = 400,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_MEDIUM = 500,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_SEMI_BOLD = 600,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BOLD = 700,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_EXTRA_BOLD = 800,
	FONT_MANAGER_GOOGLE_FONTS_WEIGHT_BLACK = 900
} FontManagerGoogleFontsWeight;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_WEIGHT (font_manager_google_fonts_weight_get_type ())
typedef struct _Block35Data Block35Data;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL (font_manager_google_fonts_variant_model_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModel))
#define FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModelClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_VARIANT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL))
#define FONT_MANAGER_GOOGLE_FONTS_IS_VARIANT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL))
#define FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModelClass))

typedef struct _FontManagerGoogleFontsVariantModel FontManagerGoogleFontsVariantModel;
typedef struct _FontManagerGoogleFontsVariantModelClass FontManagerGoogleFontsVariantModelClass;
typedef struct _Block36Data Block36Data;
typedef struct _FontManagerGoogleFontsVariantModelPrivate FontManagerGoogleFontsVariantModelPrivate;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_ITEMS_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_variant_model_properties[FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_LIST_ITEM_ROW (font_manager_list_item_row_get_type ())
#define FONT_MANAGER_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRow))
#define FONT_MANAGER_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRowClass))
#define FONT_MANAGER_IS_LIST_ITEM_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW))
#define FONT_MANAGER_IS_LIST_ITEM_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LIST_ITEM_ROW))
#define FONT_MANAGER_LIST_ITEM_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LIST_ITEM_ROW, FontManagerListItemRowClass))

typedef struct _FontManagerListItemRow FontManagerListItemRow;
typedef struct _FontManagerListItemRowClass FontManagerListItemRowClass;
typedef struct _FontManagerListItemRowPrivate FontManagerListItemRowPrivate;

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW (font_manager_google_fonts_font_list_row_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRow))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRowClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRowClass))

typedef struct _FontManagerGoogleFontsFontListRow FontManagerGoogleFontsFontListRow;
typedef struct _FontManagerGoogleFontsFontListRowClass FontManagerGoogleFontsFontListRowClass;
typedef struct _FontManagerGoogleFontsFontListRowPrivate FontManagerGoogleFontsFontListRowPrivate;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_POSITION_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_font_list_row_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_NUM_PROPERTIES];
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_STATE_CHANGED_SIGNAL,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_NUM_SIGNALS
};
static guint font_manager_google_fonts_font_list_row_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_NUM_SIGNALS] = {0};

#define FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW (font_manager_google_fonts_font_list_view_get_type ())
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListViewClass))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW))
#define FONT_MANAGER_GOOGLE_FONTS_IS_FONT_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW))
#define FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListViewClass))

typedef struct _FontManagerGoogleFontsFontListView FontManagerGoogleFontsFontListView;
typedef struct _FontManagerGoogleFontsFontListViewClass FontManagerGoogleFontsFontListViewClass;
typedef struct _FontManagerGoogleFontsFontListViewPrivate FontManagerGoogleFontsFontListViewPrivate;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_0_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTED_ITEM_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_AVAILABLE_FAMILIES_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_FILTER_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_MODEL_PROPERTY,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_NUM_PROPERTIES
};
static GParamSpec* font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_APPLICATION (font_manager_application_get_type ())
#define FONT_MANAGER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication))
#define FONT_MANAGER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))
#define FONT_MANAGER_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))

typedef struct _FontManagerApplication FontManagerApplication;
typedef struct _FontManagerApplicationClass FontManagerApplicationClass;
typedef struct _Block37Data Block37Data;
enum  {
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTION_CHANGED_SIGNAL,
	FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_NUM_SIGNALS
};
static guint font_manager_google_fonts_font_list_view_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerGoogleFontsFontModel {
	GObject parent_instance;
	FontManagerGoogleFontsFontModelPrivate * priv;
};

struct _FontManagerGoogleFontsFontModelClass {
	GObjectClass parent_class;
};

struct _FontManagerGoogleFontsFontModelPrivate {
	JsonArray* _entries;
	GPtrArray* _items;
	gchar* _search_term;
	FontManagerFontListFilter* _filter;
};

struct _Block34Data {
	int _ref_count_;
	FontManagerGoogleFontsFontModel* self;
	GPtrArray* variants;
	gchar* search;
};

struct _Block35Data {
	int _ref_count_;
	FontManagerGoogleFontsFontModel* self;
	FontManagerGoogleFontsFamily* item;
};

struct _Block36Data {
	int _ref_count_;
	FontManagerGoogleFontsFontModel* self;
	gchar* property;
};

struct _FontManagerGoogleFontsVariantModel {
	GObject parent_instance;
	FontManagerGoogleFontsVariantModelPrivate * priv;
};

struct _FontManagerGoogleFontsVariantModelClass {
	GObjectClass parent_class;
};

struct _FontManagerGoogleFontsVariantModelPrivate {
	GPtrArray* _items;
};

struct _FontManagerListItemRow {
	GtkBox parent_instance;
	FontManagerListItemRowPrivate * priv;
};

struct _FontManagerListItemRowClass {
	GtkBoxClass parent_class;
	void (*on_item_set) (FontManagerListItemRow* self);
	void (*reset) (FontManagerListItemRow* self);
};

struct _FontManagerGoogleFontsFontListRow {
	FontManagerListItemRow parent_instance;
	FontManagerGoogleFontsFontListRowPrivate * priv;
};

struct _FontManagerGoogleFontsFontListRowClass {
	FontManagerListItemRowClass parent_class;
};

struct _FontManagerGoogleFontsFontListRowPrivate {
	guint _position;
	gulong signal_id;
	GBinding* active;
	GBinding* inconsistent;
};

struct _FontManagerGoogleFontsFontListView {
	GtkBox parent_instance;
	FontManagerGoogleFontsFontListViewPrivate * priv;
};

struct _FontManagerGoogleFontsFontListViewClass {
	GtkBoxClass parent_class;
};

struct _FontManagerGoogleFontsFontListViewPrivate {
	GObject* _selected_item;
	JsonArray* _available_families;
	FontManagerFontListFilter* _filter;
	GtkListView* listview;
	GtkExpander* expander;
	GtkSearchEntry* search;
	gboolean changed;
	gboolean initialized;
	guint current_selection;
	guint search_timeout;
	GtkTreeListModel* treemodel;
	GtkSingleSelection* selection;
};

struct _Block37Data {
	int _ref_count_;
	FontManagerGoogleFontsFontListView* self;
	guint position;
};

static gint FontManagerGoogleFontsFontModel_private_offset;
static gpointer font_manager_google_fonts_font_model_parent_class = NULL;
static GListModelInterface * font_manager_google_fonts_font_model_g_list_model_parent_iface = NULL;
static gint FontManagerGoogleFontsVariantModel_private_offset;
static gpointer font_manager_google_fonts_variant_model_parent_class = NULL;
static GListModelInterface * font_manager_google_fonts_variant_model_g_list_model_parent_iface = NULL;
static gint FontManagerGoogleFontsFontListRow_private_offset;
static gpointer font_manager_google_fonts_font_list_row_parent_class = NULL;
static gint FontManagerGoogleFontsFontListView_private_offset;
static gpointer font_manager_google_fonts_font_list_view_parent_class = NULL;

VALA_EXTERN GType font_manager_google_fonts_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFontModel, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_family_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFamily, g_object_unref)
VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_font_list_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilter, g_object_unref)
static GType font_manager_google_fonts_font_model_real_get_item_type (GListModel* base);
static guint font_manager_google_fonts_font_model_real_get_n_items (GListModel* base);
VALA_EXTERN GPtrArray* font_manager_google_fonts_font_model_get_items (FontManagerGoogleFontsFontModel* self);
static GObject* font_manager_google_fonts_font_model_real_get_item (GListModel* base,
                                                             guint position);
static gboolean font_manager_google_fonts_font_model_variant_matches (FontManagerGoogleFontsFontModel* self,
                                                               FontManagerGoogleFontsFamily* item,
                                                               const gchar* search);
VALA_EXTERN GType font_manager_google_fonts_font_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFont, g_object_unref)
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GPtrArray* font_manager_google_fonts_family_get_variants (FontManagerGoogleFontsFamily* self);
static void __lambda181_ (Block34Data* _data34_,
                   FontManagerGoogleFontsFont* f);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_style (FontManagerGoogleFontsFont* self);
VALA_EXTERN gint font_manager_google_fonts_font_get_weight (FontManagerGoogleFontsFont* self);
VALA_EXTERN GType font_manager_google_fonts_weight_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* font_manager_google_fonts_weight_to_translatable_string (FontManagerGoogleFontsWeight self);
static void ___lambda181__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN void font_manager_google_fonts_family_set_variants (FontManagerGoogleFontsFamily* self,
                                                    GPtrArray* value);
VALA_EXTERN gint font_manager_google_fonts_family_get_count (FontManagerGoogleFontsFamily* self);
static gboolean font_manager_google_fonts_font_model_matches_search_term (FontManagerGoogleFontsFontModel* self,
                                                                   FontManagerGoogleFontsFamily* item);
VALA_EXTERN const gchar* font_manager_google_fonts_font_model_get_search_term (FontManagerGoogleFontsFontModel* self);
VALA_EXTERN const gchar* font_manager_google_fonts_family_get_family (FontManagerGoogleFontsFamily* self);
static gboolean font_manager_google_fonts_font_model_matches_filter (FontManagerGoogleFontsFontModel* self,
                                                              FontManagerGoogleFontsFamily* item);
VALA_EXTERN FontManagerFontListFilter* font_manager_google_fonts_font_model_get_filter (FontManagerGoogleFontsFontModel* self);
VALA_EXTERN gboolean font_manager_font_list_filter_matches (FontManagerFontListFilter* self,
                                                GObject* item);
static void font_manager_google_fonts_font_model_on_item_changed (FontManagerGoogleFontsFontModel* self,
                                                           FontManagerGoogleFontsFamily* item);
VALA_EXTERN guint font_manager_google_fonts_family_get_position (FontManagerGoogleFontsFamily* self);
VALA_EXTERN void font_manager_google_fonts_font_model_update_items (FontManagerGoogleFontsFontModel* self);
VALA_EXTERN void font_manager_google_fonts_font_model_set_items (FontManagerGoogleFontsFontModel* self,
                                                     GPtrArray* value);
VALA_EXTERN JsonArray* font_manager_google_fonts_font_model_get_entries (FontManagerGoogleFontsFontModel* self);
static void ___lambda182_ (FontManagerGoogleFontsFontModel* self,
                    JsonArray* array,
                    guint index,
                    JsonNode* node);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
VALA_EXTERN FontManagerGoogleFontsFamily* font_manager_google_fonts_family_new (JsonObject* source);
VALA_EXTERN FontManagerGoogleFontsFamily* font_manager_google_fonts_family_construct (GType object_type,
                                                                          JsonObject* source);
static void ___lambda183_ (Block35Data* _data35_);
static void ____lambda183__font_manager_google_fonts_family_changed (FontManagerGoogleFontsFamily* _sender,
                                                              gpointer self);
static void _____lambda184_ (Block35Data* _data35_);
static void ______lambda184__font_manager_google_fonts_font_changed (FontManagerGoogleFontsFont* _sender,
                                                              gpointer self);
static void ____lambda182__json_array_foreach (JsonArray* array,
                                        guint index_,
                                        JsonNode* element_node,
                                        gpointer self);
VALA_EXTERN GListModel* font_manager_google_fonts_font_model_get_child_model (FontManagerGoogleFontsFontModel* self,
                                                                  GObject* item);
VALA_EXTERN GType font_manager_google_fonts_variant_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsVariantModel, g_object_unref)
VALA_EXTERN FontManagerGoogleFontsVariantModel* font_manager_google_fonts_variant_model_new (void);
VALA_EXTERN FontManagerGoogleFontsVariantModel* font_manager_google_fonts_variant_model_construct (GType object_type);
VALA_EXTERN FontManagerGoogleFontsFontModel* font_manager_google_fonts_font_model_new (void);
VALA_EXTERN FontManagerGoogleFontsFontModel* font_manager_google_fonts_font_model_construct (GType object_type);
VALA_EXTERN void font_manager_google_fonts_font_model_set_entries (FontManagerGoogleFontsFontModel* self,
                                                       JsonArray* value);
VALA_EXTERN void font_manager_google_fonts_font_model_set_search_term (FontManagerGoogleFontsFontModel* self,
                                                           const gchar* value);
VALA_EXTERN void font_manager_google_fonts_font_model_set_filter (FontManagerGoogleFontsFontModel* self,
                                                      FontManagerFontListFilter* value);
static GObject * font_manager_google_fonts_font_model_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void _font_manager_google_fonts_font_model_____lambda185_ (Block36Data* _data36_);
static gboolean __lambda186_ (Block36Data* _data36_);
static void _font_manager_google_fonts_font_model_update_items_font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                                                        gpointer self);
static gboolean ___lambda186__gsource_func (gpointer self);
static void __font_manager_google_fonts_font_model_____lambda185__g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void font_manager_google_fonts_font_model_finalize (GObject * obj);
static GType font_manager_google_fonts_font_model_get_type_once (void);
static void _vala_font_manager_google_fonts_font_model_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_font_manager_google_fonts_font_model_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
static void font_manager_google_fonts_variant_model_on_item_changed (FontManagerGoogleFontsVariantModel* self,
                                                              FontManagerGoogleFontsFont* item);
VALA_EXTERN guint font_manager_google_fonts_font_get_position (FontManagerGoogleFontsFont* self);
static void font_manager_google_fonts_variant_model_on_items_changed (FontManagerGoogleFontsVariantModel* self);
VALA_EXTERN GPtrArray* font_manager_google_fonts_variant_model_get_items (FontManagerGoogleFontsVariantModel* self);
static void _font_manager_google_fonts_variant_model_on_item_changed_font_manager_google_fonts_font_changed (FontManagerGoogleFontsFont* _sender,
                                                                                                      gpointer self);
static GType font_manager_google_fonts_variant_model_real_get_item_type (GListModel* base);
static guint font_manager_google_fonts_variant_model_real_get_n_items (GListModel* base);
static GObject* font_manager_google_fonts_variant_model_real_get_item (GListModel* base,
                                                                guint position);
VALA_EXTERN void font_manager_google_fonts_variant_model_set_items (FontManagerGoogleFontsVariantModel* self,
                                                        GPtrArray* value);
static GObject * font_manager_google_fonts_variant_model_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties);
static void _font_manager_google_fonts_variant_model_on_items_changed_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self);
static void font_manager_google_fonts_variant_model_finalize (GObject * obj);
static GType font_manager_google_fonts_variant_model_get_type_once (void);
static void _vala_font_manager_google_fonts_variant_model_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_font_manager_google_fonts_variant_model_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
VALA_EXTERN GType font_manager_list_item_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerListItemRow, g_object_unref)
VALA_EXTERN GType font_manager_google_fonts_font_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFontListRow, g_object_unref)
VALA_EXTERN void font_manager_list_item_row_reset (FontManagerListItemRow* self);
VALA_EXTERN void font_manager_list_item_row_on_item_set (FontManagerListItemRow* self);
static void font_manager_google_fonts_font_list_row_real_reset (FontManagerListItemRow* base);
VALA_EXTERN GtkCheckButton* font_manager_list_item_row_get_item_state (FontManagerListItemRow* self);
VALA_EXTERN GtkLabel* font_manager_list_item_row_get_item_label (FontManagerListItemRow* self);
VALA_EXTERN GtkInscription* font_manager_list_item_row_get_item_preview (FontManagerListItemRow* self);
VALA_EXTERN GtkLabel* font_manager_list_item_row_get_item_count (FontManagerListItemRow* self);
static void font_manager_google_fonts_font_list_row_real_on_item_set (FontManagerListItemRow* base);
VALA_EXTERN GObject* font_manager_list_item_row_get_item (FontManagerListItemRow* self);
VALA_EXTERN gchar* font_manager_google_fonts_font_to_display_name (FontManagerGoogleFontsFont* self);
static void __lambda187_ (FontManagerGoogleFontsFontListRow* self);
static void ___lambda187__gtk_check_button_toggled (GtkCheckButton* _sender,
                                             gpointer self);
VALA_EXTERN FontManagerGoogleFontsFontListRow* font_manager_google_fonts_font_list_row_new (void);
VALA_EXTERN FontManagerGoogleFontsFontListRow* font_manager_google_fonts_font_list_row_construct (GType object_type);
VALA_EXTERN FontManagerListItemRow* font_manager_list_item_row_new (void);
VALA_EXTERN FontManagerListItemRow* font_manager_list_item_row_construct (GType object_type);
VALA_EXTERN guint font_manager_google_fonts_font_list_row_get_position (FontManagerGoogleFontsFontListRow* self);
VALA_EXTERN void font_manager_google_fonts_font_list_row_set_position (FontManagerGoogleFontsFontListRow* self,
                                                           guint value);
static void font_manager_google_fonts_font_list_row_finalize (GObject * obj);
static GType font_manager_google_fonts_font_list_row_get_type_once (void);
static void _vala_font_manager_google_fonts_font_list_row_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_font_manager_google_fonts_font_list_row_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
VALA_EXTERN GType font_manager_google_fonts_font_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerGoogleFontsFontListView, g_object_unref)
VALA_EXTERN void font_manager_google_fonts_font_list_view_queue_refilter (FontManagerGoogleFontsFontListView* self);
static gboolean font_manager_google_fonts_font_list_view_refilter (FontManagerGoogleFontsFontListView* self);
static gboolean _font_manager_google_fonts_font_list_view_refilter_gsource_func (gpointer self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_focus_search_entry (FontManagerGoogleFontsFontListView* self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_select_item (FontManagerGoogleFontsFontListView* self,
                                                           guint position);
VALA_EXTERN FontManagerGoogleFontsFontModel* font_manager_google_fonts_font_list_view_get_model (FontManagerGoogleFontsFontListView* self);
static void font_manager_google_fonts_font_list_view_on_expander_activated (FontManagerGoogleFontsFontListView* self,
                                                                     GtkExpander* _expander);
static void font_manager_google_fonts_font_list_view_queue_update (FontManagerGoogleFontsFontListView* self,
                                                            guint position);
static void _font_manager_google_fonts_font_list_view_on_expander_activated_gtk_expander_activate (GtkExpander* _sender,
                                                                                            gpointer self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_on_map (FontManagerGoogleFontsFontListView* self);
static GListModel* _font_manager_google_fonts_font_model_get_child_model_gtk_tree_list_model_create_model_func (GObject* item,
                                                                                                         gpointer self);
static GtkSignalListItemFactory* font_manager_google_fonts_font_list_view_get_factory (FontManagerGoogleFontsFontListView* self);
static void font_manager_google_fonts_font_list_view_on_selection_changed (FontManagerGoogleFontsFontListView* self,
                                                                    guint position,
                                                                    guint n_items);
static void _font_manager_google_fonts_font_list_view_on_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                                           guint position,
                                                                                                           guint n_items,
                                                                                                           gpointer self);
static void _font_manager_google_fonts_font_list_view_queue_refilter_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                               gpointer self);
static void font_manager_google_fonts_font_list_view_next_match (FontManagerGoogleFontsFontListView* self,
                                                          GtkSearchEntry* entry);
static void _font_manager_google_fonts_font_list_view_next_match_gtk_search_entry_activate (GtkSearchEntry* _sender,
                                                                                     gpointer self);
static void _font_manager_google_fonts_font_list_view_next_match_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                                       gpointer self);
static void font_manager_google_fonts_font_list_view_previous_match (FontManagerGoogleFontsFontListView* self,
                                                              GtkSearchEntry* entry);
static void _font_manager_google_fonts_font_list_view_previous_match_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                                               gpointer self);
static void _font_manager_google_fonts_font_list_view_on_map_gtk_widget_map (GtkWidget* _sender,
                                                                      gpointer self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_on_unmap (FontManagerGoogleFontsFontListView* self);
VALA_EXTERN GType font_manager_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerApplication, g_object_unref)
VALA_EXTERN guint font_manager_application_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN FontManagerApplication* font_manager_get_default_application (void);
VALA_EXTERN void font_manager_application_reload (FontManagerApplication* self);
static void _font_manager_google_fonts_font_list_view_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                                                          gpointer self);
static void font_manager_google_fonts_font_list_view_setup_list_row (FontManagerGoogleFontsFontListView* self,
                                                              GtkSignalListItemFactory* factory,
                                                              GObject* item);
static void _font_manager_google_fonts_font_list_view_setup_list_row_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                                  GObject* object,
                                                                                                  gpointer self);
static void font_manager_google_fonts_font_list_view_bind_list_row (FontManagerGoogleFontsFontListView* self,
                                                             GtkSignalListItemFactory* factory,
                                                             GObject* item);
static void _font_manager_google_fonts_font_list_view_bind_list_row_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                                                GObject* object,
                                                                                                gpointer self);
static void __lambda188_ (FontManagerGoogleFontsFontListView* self);
static void ___lambda188__font_manager_google_fonts_font_list_row_state_changed (FontManagerGoogleFontsFontListRow* _sender,
                                                                          gpointer self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static gboolean __lambda180_ (Block37Data* _data37_);
static gboolean ___lambda180__gsource_func (gpointer self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_set_selected_item (FontManagerGoogleFontsFontListView* self,
                                                                 GObject* value);
VALA_EXTERN GObject* font_manager_google_fonts_font_list_view_get_selected_item (FontManagerGoogleFontsFontListView* self);
VALA_EXTERN const gchar* font_manager_google_fonts_font_get_family (FontManagerGoogleFontsFont* self);
VALA_EXTERN FontManagerGoogleFontsFontListView* font_manager_google_fonts_font_list_view_new (void);
VALA_EXTERN FontManagerGoogleFontsFontListView* font_manager_google_fonts_font_list_view_construct (GType object_type);
VALA_EXTERN JsonArray* font_manager_google_fonts_font_list_view_get_available_families (FontManagerGoogleFontsFontListView* self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_set_available_families (FontManagerGoogleFontsFontListView* self,
                                                                      JsonArray* value);
VALA_EXTERN FontManagerFontListFilter* font_manager_google_fonts_font_list_view_get_filter (FontManagerGoogleFontsFontListView* self);
VALA_EXTERN void font_manager_google_fonts_font_list_view_set_filter (FontManagerGoogleFontsFontListView* self,
                                                          FontManagerFontListFilter* value);
static GObject * font_manager_google_fonts_font_list_view_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static void font_manager_google_fonts_font_list_view_finalize (GObject * obj);
static GType font_manager_google_fonts_font_list_view_get_type_once (void);
static void _vala_font_manager_google_fonts_font_list_view_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_font_manager_google_fonts_font_list_view_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
font_manager_google_fonts_font_model_get_instance_private (FontManagerGoogleFontsFontModel* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsFontModel_private_offset);
}

static GType
font_manager_google_fonts_font_model_real_get_item_type (GListModel* base)
{
	FontManagerGoogleFontsFontModel * self;
	GType result;
	self = (FontManagerGoogleFontsFontModel*) base;
	result = FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
font_manager_google_fonts_font_model_real_get_n_items (GListModel* base)
{
	FontManagerGoogleFontsFontModel * self;
	gint _tmp0_ = 0;
	GPtrArray* _tmp1_;
	guint result;
	self = (FontManagerGoogleFontsFontModel*) base;
	_tmp1_ = self->priv->_items;
	if (_tmp1_ != NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = (guint) _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject*
font_manager_google_fonts_font_model_real_get_item (GListModel* base,
                                                    guint position)
{
	FontManagerGoogleFontsFontModel * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gconstpointer _tmp2_;
	GObject* _tmp3_;
	GObject* result;
	self = (FontManagerGoogleFontsFontModel*) base;
	_tmp0_ = self->priv->_items;
	_vala_return_val_if_fail (_tmp0_ != NULL, "items != null", NULL);
	_vala_return_val_if_fail (position >= ((guint) 0), "position >= 0", NULL);
	_vala_return_val_if_fail (position < g_list_model_get_n_items ((GListModel*) self), "position < get_n_items()", NULL);
	_tmp1_ = self->priv->_items;
	_tmp2_ = g_ptr_array_index (_tmp1_, position);
	_tmp3_ = _g_object_ref0 ((GObject*) ((FontManagerGoogleFontsFamily*) _tmp2_));
	result = _tmp3_;
	return result;
}

static Block34Data*
block34_data_ref (Block34Data* _data34_)
{
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}

static void
block34_data_unref (void * _userdata_)
{
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		FontManagerGoogleFontsFontModel* self;
		self = _data34_->self;
		_g_ptr_array_unref0 (_data34_->variants);
		_g_free0 (_data34_->search);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
__lambda181_ (Block34Data* _data34_,
              FontManagerGoogleFontsFont* f)
{
	FontManagerGoogleFontsFontModel* self;
	gchar* style = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* weight = NULL;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	self = _data34_->self;
	g_return_if_fail (f != NULL);
	_tmp0_ = font_manager_google_fonts_font_get_style (f);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	style = _tmp2_;
	_tmp3_ = font_manager_google_fonts_font_get_weight (f);
	_tmp4_ = _tmp3_;
	_tmp5_ = font_manager_google_fonts_weight_to_translatable_string ((FontManagerGoogleFontsWeight) _tmp4_);
	weight = _tmp5_;
	_tmp6_ = weight;
	_tmp7_ = g_utf8_casefold (_tmp6_, (gssize) -1);
	_g_free0 (weight);
	weight = _tmp7_;
	_tmp9_ = style;
	if (string_contains (_tmp9_, _data34_->search)) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = weight;
		_tmp8_ = string_contains (_tmp10_, _data34_->search);
	}
	if (_tmp8_) {
		FontManagerGoogleFontsFont* _tmp11_;
		_tmp11_ = _g_object_ref0 (f);
		g_ptr_array_add (_data34_->variants, _tmp11_);
	}
	_g_free0 (weight);
	_g_free0 (style);
}

static void
___lambda181__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda181_ (self, (FontManagerGoogleFontsFont*) data);
}

static gboolean
font_manager_google_fonts_font_model_variant_matches (FontManagerGoogleFontsFontModel* self,
                                                      FontManagerGoogleFontsFamily* item,
                                                      const gchar* search)
{
	Block34Data* _data34_;
	gchar* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	g_return_val_if_fail (search != NULL, FALSE);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = g_strdup (search);
	_g_free0 (_data34_->search);
	_data34_->search = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_data34_->variants = _tmp1_;
	_tmp2_ = font_manager_google_fonts_family_get_variants (item);
	_tmp3_ = _tmp2_;
	g_ptr_array_foreach (_tmp3_, ___lambda181__gfunc, _data34_);
	font_manager_google_fonts_family_set_variants (item, _data34_->variants);
	_tmp4_ = font_manager_google_fonts_family_get_count (item);
	_tmp5_ = _tmp4_;
	result = _tmp5_ > 0;
	block34_data_unref (_data34_);
	_data34_ = NULL;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
font_manager_google_fonts_font_model_matches_search_term (FontManagerGoogleFontsFontModel* self,
                                                          FontManagerGoogleFontsFamily* item)
{
	gboolean item_matches = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* search = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	item_matches = TRUE;
	_tmp1_ = self->priv->_search_term;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp2_ = self->priv->_search_term;
		_tmp3_ = string_strip (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == 0;
		_g_free0 (_tmp4_);
	}
	if (_tmp0_) {
		result = item_matches;
		return result;
	}
	_tmp7_ = self->priv->_search_term;
	_tmp8_ = string_strip (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_casefold (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	search = _tmp11_;
	_tmp12_ = font_manager_google_fonts_family_get_family (item);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_utf8_casefold (_tmp13_, (gssize) -1);
	_tmp15_ = _tmp14_;
	_tmp16_ = search;
	item_matches = string_contains (_tmp15_, _tmp16_);
	_g_free0 (_tmp15_);
	if (!item_matches) {
		const gchar* _tmp17_;
		_tmp17_ = search;
		item_matches = font_manager_google_fonts_font_model_variant_matches (self, item, _tmp17_);
	}
	result = item_matches;
	_g_free0 (search);
	return result;
}

static gboolean
font_manager_google_fonts_font_model_matches_filter (FontManagerGoogleFontsFontModel* self,
                                                     FontManagerGoogleFontsFamily* item)
{
	FontManagerFontListFilter* _tmp0_;
	FontManagerFontListFilter* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->_filter;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->_filter;
	result = font_manager_font_list_filter_matches (_tmp1_, (GObject*) item);
	return result;
}

static void
font_manager_google_fonts_font_model_on_item_changed (FontManagerGoogleFontsFontModel* self,
                                                      FontManagerGoogleFontsFamily* item)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = font_manager_google_fonts_family_get_position (item);
	_tmp1_ = _tmp0_;
	g_list_model_items_changed ((GListModel*) self, _tmp1_, (guint) 0, (guint) 0);
	return;
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		FontManagerGoogleFontsFontModel* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->item);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static void
___lambda183_ (Block35Data* _data35_)
{
	FontManagerGoogleFontsFontModel* self;
	FontManagerGoogleFontsFamily* _tmp0_;
	self = _data35_->self;
	_tmp0_ = _data35_->item;
	font_manager_google_fonts_font_model_on_item_changed (self, _tmp0_);
}

static void
____lambda183__font_manager_google_fonts_family_changed (FontManagerGoogleFontsFamily* _sender,
                                                         gpointer self)
{
	___lambda183_ (self);
}

static void
_____lambda184_ (Block35Data* _data35_)
{
	FontManagerGoogleFontsFontModel* self;
	FontManagerGoogleFontsFamily* _tmp0_;
	self = _data35_->self;
	_tmp0_ = _data35_->item;
	font_manager_google_fonts_font_model_on_item_changed (self, _tmp0_);
}

static void
______lambda184__font_manager_google_fonts_font_changed (FontManagerGoogleFontsFont* _sender,
                                                         gpointer self)
{
	_____lambda184_ (self);
}

static void
___lambda182_ (FontManagerGoogleFontsFontModel* self,
               JsonArray* array,
               guint index,
               JsonNode* node)
{
	Block35Data* _data35_;
	JsonObject* _tmp0_;
	FontManagerGoogleFontsFamily* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FontManagerGoogleFontsFamily* _tmp3_;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = json_node_get_object (node);
	_tmp1_ = font_manager_google_fonts_family_new (_tmp0_);
	_data35_->item = _tmp1_;
	_tmp3_ = _data35_->item;
	if (font_manager_google_fonts_font_model_matches_filter (self, _tmp3_)) {
		FontManagerGoogleFontsFamily* _tmp4_;
		_tmp4_ = _data35_->item;
		_tmp2_ = font_manager_google_fonts_font_model_matches_search_term (self, _tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GPtrArray* _tmp5_;
		FontManagerGoogleFontsFamily* _tmp6_;
		FontManagerGoogleFontsFamily* _tmp7_;
		FontManagerGoogleFontsFamily* _tmp8_;
		FontManagerGoogleFontsFamily* _tmp9_;
		GPtrArray* _tmp10_;
		GPtrArray* _tmp11_;
		_tmp5_ = self->priv->_items;
		_tmp6_ = _data35_->item;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		g_ptr_array_add (_tmp5_, _tmp7_);
		_tmp8_ = _data35_->item;
		g_signal_connect_data (_tmp8_, "changed", (GCallback) ____lambda183__font_manager_google_fonts_family_changed, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
		_tmp9_ = _data35_->item;
		_tmp10_ = font_manager_google_fonts_family_get_variants (_tmp9_);
		_tmp11_ = _tmp10_;
		{
			GPtrArray* font_collection = NULL;
			guint font_index = 0U;
			font_collection = _tmp11_;
			for (font_index = 0; font_index < font_collection->len; font_index = font_index + 1) {
				FontManagerGoogleFontsFont* _tmp12_;
				FontManagerGoogleFontsFont* font = NULL;
				_tmp12_ = _g_object_ref0 ((FontManagerGoogleFontsFont*) g_ptr_array_index (font_collection, font_index));
				font = _tmp12_;
				{
					FontManagerGoogleFontsFont* _tmp13_;
					_tmp13_ = font;
					g_signal_connect_data (_tmp13_, "changed", (GCallback) ______lambda184__font_manager_google_fonts_font_changed, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
					_g_object_unref0 (font);
				}
			}
		}
	}
	block35_data_unref (_data35_);
	_data35_ = NULL;
}

static void
____lambda182__json_array_foreach (JsonArray* array,
                                   guint index_,
                                   JsonNode* element_node,
                                   gpointer self)
{
	___lambda182_ ((FontManagerGoogleFontsFontModel*) self, array, index_, element_node);
}

void
font_manager_google_fonts_font_model_update_items (FontManagerGoogleFontsFontModel* self)
{
	guint n_items = 0U;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	JsonArray* _tmp2_;
	g_return_if_fail (self != NULL);
	n_items = g_list_model_get_n_items ((GListModel*) self);
	font_manager_google_fonts_font_model_set_items (self, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	font_manager_google_fonts_font_model_set_items (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, n_items, (guint) 0);
	_tmp2_ = self->priv->_entries;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_;
		_tmp3_ = self->priv->_entries;
		json_array_foreach_element (_tmp3_, ____lambda182__json_array_foreach, self);
		g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) self));
	}
	return;
}

GListModel*
font_manager_google_fonts_font_model_get_child_model (FontManagerGoogleFontsFontModel* self,
                                                      GObject* item)
{
	FontManagerGoogleFontsFamily* parent = NULL;
	FontManagerGoogleFontsFamily* _tmp0_;
	FontManagerGoogleFontsVariantModel* child = NULL;
	FontManagerGoogleFontsVariantModel* _tmp1_;
	GBindingFlags flags = 0U;
	FontManagerGoogleFontsFamily* _tmp2_;
	FontManagerGoogleFontsVariantModel* _tmp3_;
	GListModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	if (!FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY (item)) {
		result = NULL;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily));
	parent = _tmp0_;
	_tmp1_ = font_manager_google_fonts_variant_model_new ();
	child = _tmp1_;
	flags = G_BINDING_SYNC_CREATE;
	_tmp2_ = parent;
	_tmp3_ = child;
	g_object_bind_property_with_closures ((GObject*) _tmp2_, "variants", (GObject*) _tmp3_, "items", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = (GListModel*) child;
	_g_object_unref0 (parent);
	return result;
}

FontManagerGoogleFontsFontModel*
font_manager_google_fonts_font_model_construct (GType object_type)
{
	FontManagerGoogleFontsFontModel * self = NULL;
	self = (FontManagerGoogleFontsFontModel*) g_object_new (object_type, NULL);
	return self;
}

FontManagerGoogleFontsFontModel*
font_manager_google_fonts_font_model_new (void)
{
	return font_manager_google_fonts_font_model_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL);
}

JsonArray*
font_manager_google_fonts_font_model_get_entries (FontManagerGoogleFontsFontModel* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entries;
	result = _tmp0_;
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

void
font_manager_google_fonts_font_model_set_entries (FontManagerGoogleFontsFontModel* self,
                                                  JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_model_get_entries (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_entries);
		self->priv->_entries = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ENTRIES_PROPERTY]);
	}
}

GPtrArray*
font_manager_google_fonts_font_model_get_items (FontManagerGoogleFontsFontModel* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
font_manager_google_fonts_font_model_set_items (FontManagerGoogleFontsFontModel* self,
                                                GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_model_get_items (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_items);
		self->priv->_items = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ITEMS_PROPERTY]);
	}
}

const gchar*
font_manager_google_fonts_font_model_get_search_term (FontManagerGoogleFontsFontModel* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_term;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_model_set_search_term (FontManagerGoogleFontsFontModel* self,
                                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_model_get_search_term (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_term);
		self->priv->_search_term = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_SEARCH_TERM_PROPERTY]);
	}
}

FontManagerFontListFilter*
font_manager_google_fonts_font_model_get_filter (FontManagerGoogleFontsFontModel* self)
{
	FontManagerFontListFilter* result;
	FontManagerFontListFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filter;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_model_set_filter (FontManagerGoogleFontsFontModel* self,
                                                 FontManagerFontListFilter* value)
{
	FontManagerFontListFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_model_get_filter (self);
	if (old_value != value) {
		FontManagerFontListFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_filter);
		self->priv->_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_FILTER_PROPERTY]);
	}
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		FontManagerGoogleFontsFontModel* self;
		self = _data36_->self;
		_g_free0 (_data36_->property);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static void
_font_manager_google_fonts_font_model_update_items_font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                                                   gpointer self)
{
	font_manager_google_fonts_font_model_update_items ((FontManagerGoogleFontsFontModel*) self);
}

static gboolean
__lambda186_ (Block36Data* _data36_)
{
	FontManagerGoogleFontsFontModel* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	self = _data36_->self;
	font_manager_google_fonts_font_model_update_items (self);
	_tmp1_ = _data36_->property;
	if (g_strcmp0 (_tmp1_, "filter") == 0) {
		FontManagerFontListFilter* _tmp2_;
		_tmp2_ = self->priv->_filter;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FontManagerFontListFilter* _tmp3_;
		_tmp3_ = self->priv->_filter;
		g_signal_connect_object ((FontManagerCacheable*) _tmp3_, "changed", (GCallback) _font_manager_google_fonts_font_model_update_items_font_manager_cacheable_changed, self, 0);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda186__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda186_ (self);
	return result;
}

static void
_font_manager_google_fonts_font_model_____lambda185_ (Block36Data* _data36_)
{
	FontManagerGoogleFontsFontModel* self;
	self = _data36_->self;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda186__gsource_func, block36_data_ref (_data36_), block36_data_unref);
}

static void
__font_manager_google_fonts_font_model_____lambda185__g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	_font_manager_google_fonts_font_model_____lambda185_ (self);
}

static GObject *
font_manager_google_fonts_font_model_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerGoogleFontsFontModel * self;
	gchar** requires_update = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint requires_update_length1;
	gint _requires_update_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	parent_class = G_OBJECT_CLASS (font_manager_google_fonts_font_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModel);
	_tmp0_ = g_strdup ("entries");
	_tmp1_ = g_strdup ("filter");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	requires_update = _tmp2_;
	requires_update_length1 = 2;
	_requires_update_size_ = requires_update_length1;
	_tmp3_ = requires_update;
	_tmp3__length1 = requires_update_length1;
	{
		gchar** property_collection = NULL;
		gint property_collection_length1 = 0;
		gint _property_collection_size_ = 0;
		gint property_it = 0;
		property_collection = _tmp3_;
		property_collection_length1 = _tmp3__length1;
		for (property_it = 0; property_it < property_collection_length1; property_it = property_it + 1) {
			gchar* _tmp4_;
			gchar* property = NULL;
			_tmp4_ = g_strdup (property_collection[property_it]);
			property = _tmp4_;
			{
				Block36Data* _data36_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_data36_ = g_slice_new0 (Block36Data);
				_data36_->_ref_count_ = 1;
				_data36_->self = g_object_ref (self);
				_data36_->property = property;
				_tmp5_ = _data36_->property;
				_tmp6_ = g_strconcat ("notify::", _tmp5_, NULL);
				g_signal_connect_data ((GObject*) self, _tmp6_, (GCallback) __font_manager_google_fonts_font_model_____lambda185__g_object_notify, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
				_g_free0 (_tmp6_);
				block36_data_unref (_data36_);
				_data36_ = NULL;
			}
		}
	}
	requires_update = (_vala_array_free (requires_update, requires_update_length1, (GDestroyNotify) g_free), NULL);
	return obj;
}

static void
font_manager_google_fonts_font_model_class_init (FontManagerGoogleFontsFontModelClass * klass,
                                                 gpointer klass_data)
{
	font_manager_google_fonts_font_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsFontModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_font_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_font_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_google_fonts_font_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_font_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ENTRIES_PROPERTY, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ENTRIES_PROPERTY] = g_param_spec_boxed ("entries", "entries", "entries", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ITEMS_PROPERTY, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ITEMS_PROPERTY] = g_param_spec_boxed ("items", "items", "items", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_SEARCH_TERM_PROPERTY, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_SEARCH_TERM_PROPERTY] = g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_FILTER_PROPERTY, font_manager_google_fonts_font_model_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_FILTER_PROPERTY] = g_param_spec_object ("filter", "filter", "filter", FONT_MANAGER_TYPE_FONT_LIST_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_google_fonts_font_model_g_list_model_interface_init (GListModelInterface * iface,
                                                                  gpointer iface_data)
{
	font_manager_google_fonts_font_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) font_manager_google_fonts_font_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) font_manager_google_fonts_font_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) font_manager_google_fonts_font_model_real_get_item;
}

static void
font_manager_google_fonts_font_model_instance_init (FontManagerGoogleFontsFontModel * self,
                                                    gpointer klass)
{
	self->priv = font_manager_google_fonts_font_model_get_instance_private (self);
	self->priv->_entries = NULL;
	self->priv->_items = NULL;
	self->priv->_search_term = NULL;
	self->priv->_filter = NULL;
}

static void
font_manager_google_fonts_font_model_finalize (GObject * obj)
{
	FontManagerGoogleFontsFontModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModel);
	_json_array_unref0 (self->priv->_entries);
	_g_ptr_array_unref0 (self->priv->_items);
	_g_free0 (self->priv->_search_term);
	_g_object_unref0 (self->priv->_filter);
	G_OBJECT_CLASS (font_manager_google_fonts_font_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_font_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsFontModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_font_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsFontModel), 0, (GInstanceInitFunc) font_manager_google_fonts_font_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) font_manager_google_fonts_font_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType font_manager_google_fonts_font_model_type_id;
	font_manager_google_fonts_font_model_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerGoogleFontsFontModel", &g_define_type_info, 0);
	g_type_add_interface_static (font_manager_google_fonts_font_model_type_id, g_list_model_get_type (), &g_list_model_info);
	FontManagerGoogleFontsFontModel_private_offset = g_type_add_instance_private (font_manager_google_fonts_font_model_type_id, sizeof (FontManagerGoogleFontsFontModelPrivate));
	return font_manager_google_fonts_font_model_type_id;
}

GType
font_manager_google_fonts_font_model_get_type (void)
{
	static volatile gsize font_manager_google_fonts_font_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_font_model_type_id__once)) {
		GType font_manager_google_fonts_font_model_type_id;
		font_manager_google_fonts_font_model_type_id = font_manager_google_fonts_font_model_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_font_model_type_id__once, font_manager_google_fonts_font_model_type_id);
	}
	return font_manager_google_fonts_font_model_type_id__once;
}

static void
_vala_font_manager_google_fonts_font_model_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	FontManagerGoogleFontsFontModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModel);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ENTRIES_PROPERTY:
		g_value_set_boxed (value, font_manager_google_fonts_font_model_get_entries (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ITEMS_PROPERTY:
		g_value_set_boxed (value, font_manager_google_fonts_font_model_get_items (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_SEARCH_TERM_PROPERTY:
		g_value_set_string (value, font_manager_google_fonts_font_model_get_search_term (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_FILTER_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_font_model_get_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_font_model_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	FontManagerGoogleFontsFontModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModel);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ENTRIES_PROPERTY:
		font_manager_google_fonts_font_model_set_entries (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_ITEMS_PROPERTY:
		font_manager_google_fonts_font_model_set_items (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_SEARCH_TERM_PROPERTY:
		font_manager_google_fonts_font_model_set_search_term (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_MODEL_FILTER_PROPERTY:
		font_manager_google_fonts_font_model_set_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_google_fonts_variant_model_get_instance_private (FontManagerGoogleFontsVariantModel* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsVariantModel_private_offset);
}

static void
font_manager_google_fonts_variant_model_on_item_changed (FontManagerGoogleFontsVariantModel* self,
                                                         FontManagerGoogleFontsFont* item)
{
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = font_manager_google_fonts_font_get_position (item);
	_tmp1_ = _tmp0_;
	g_list_model_items_changed ((GListModel*) self, _tmp1_, (guint) 0, (guint) 0);
	return;
}

static void
_font_manager_google_fonts_variant_model_on_item_changed_font_manager_google_fonts_font_changed (FontManagerGoogleFontsFont* _sender,
                                                                                                 gpointer self)
{
	font_manager_google_fonts_variant_model_on_item_changed ((FontManagerGoogleFontsVariantModel*) self, _sender);
}

static void
font_manager_google_fonts_variant_model_on_items_changed (FontManagerGoogleFontsVariantModel* self)
{
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	{
		GPtrArray* font_collection = NULL;
		guint font_index = 0U;
		font_collection = _tmp0_;
		for (font_index = 0; font_index < font_collection->len; font_index = font_index + 1) {
			FontManagerGoogleFontsFont* _tmp1_;
			FontManagerGoogleFontsFont* font = NULL;
			_tmp1_ = _g_object_ref0 ((FontManagerGoogleFontsFont*) g_ptr_array_index (font_collection, font_index));
			font = _tmp1_;
			{
				FontManagerGoogleFontsFont* _tmp2_;
				_tmp2_ = font;
				g_signal_connect_object (_tmp2_, "changed", (GCallback) _font_manager_google_fonts_variant_model_on_item_changed_font_manager_google_fonts_font_changed, self, 0);
				_g_object_unref0 (font);
			}
		}
	}
}

static GType
font_manager_google_fonts_variant_model_real_get_item_type (GListModel* base)
{
	FontManagerGoogleFontsVariantModel * self;
	GType result;
	self = (FontManagerGoogleFontsVariantModel*) base;
	result = FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT;
	return result;
}

static guint
font_manager_google_fonts_variant_model_real_get_n_items (GListModel* base)
{
	FontManagerGoogleFontsVariantModel * self;
	gint _tmp0_ = 0;
	GPtrArray* _tmp1_;
	guint result;
	self = (FontManagerGoogleFontsVariantModel*) base;
	_tmp1_ = self->priv->_items;
	if (_tmp1_ != NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = (guint) _tmp0_;
	return result;
}

static GObject*
font_manager_google_fonts_variant_model_real_get_item (GListModel* base,
                                                       guint position)
{
	FontManagerGoogleFontsVariantModel * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	gconstpointer _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* _tmp5_;
	GObject* result;
	self = (FontManagerGoogleFontsVariantModel*) base;
	_tmp0_ = self->priv->_items;
	_vala_return_val_if_fail (_tmp0_ != NULL, "items != null", NULL);
	_tmp1_ = self->priv->_items;
	_tmp2_ = g_ptr_array_index (_tmp1_, position);
	g_return_val_if_fail (((FontManagerGoogleFontsFont*) _tmp2_) != NULL, NULL);
	_tmp3_ = self->priv->_items;
	_tmp4_ = g_ptr_array_index (_tmp3_, position);
	_tmp5_ = _g_object_ref0 ((GObject*) ((FontManagerGoogleFontsFont*) _tmp4_));
	result = _tmp5_;
	return result;
}

FontManagerGoogleFontsVariantModel*
font_manager_google_fonts_variant_model_construct (GType object_type)
{
	FontManagerGoogleFontsVariantModel * self = NULL;
	self = (FontManagerGoogleFontsVariantModel*) g_object_new (object_type, NULL);
	return self;
}

FontManagerGoogleFontsVariantModel*
font_manager_google_fonts_variant_model_new (void)
{
	return font_manager_google_fonts_variant_model_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL);
}

GPtrArray*
font_manager_google_fonts_variant_model_get_items (FontManagerGoogleFontsVariantModel* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_variant_model_set_items (FontManagerGoogleFontsVariantModel* self,
                                                   GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_variant_model_get_items (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_items);
		self->priv->_items = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_variant_model_properties[FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_ITEMS_PROPERTY]);
	}
}

static void
_font_manager_google_fonts_variant_model_on_items_changed_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self)
{
	font_manager_google_fonts_variant_model_on_items_changed ((FontManagerGoogleFontsVariantModel*) self);
}

static GObject *
font_manager_google_fonts_variant_model_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerGoogleFontsVariantModel * self;
	parent_class = G_OBJECT_CLASS (font_manager_google_fonts_variant_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModel);
	g_signal_connect_object ((GObject*) self, "notify::items", (GCallback) _font_manager_google_fonts_variant_model_on_items_changed_g_object_notify, self, 0);
	return obj;
}

static void
font_manager_google_fonts_variant_model_class_init (FontManagerGoogleFontsVariantModelClass * klass,
                                                    gpointer klass_data)
{
	font_manager_google_fonts_variant_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsVariantModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_variant_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_variant_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_google_fonts_variant_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_variant_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_ITEMS_PROPERTY, font_manager_google_fonts_variant_model_properties[FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_ITEMS_PROPERTY] = g_param_spec_boxed ("items", "items", "items", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_google_fonts_variant_model_g_list_model_interface_init (GListModelInterface * iface,
                                                                     gpointer iface_data)
{
	font_manager_google_fonts_variant_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) font_manager_google_fonts_variant_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) font_manager_google_fonts_variant_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) font_manager_google_fonts_variant_model_real_get_item;
}

static void
font_manager_google_fonts_variant_model_instance_init (FontManagerGoogleFontsVariantModel * self,
                                                       gpointer klass)
{
	self->priv = font_manager_google_fonts_variant_model_get_instance_private (self);
	self->priv->_items = NULL;
}

static void
font_manager_google_fonts_variant_model_finalize (GObject * obj)
{
	FontManagerGoogleFontsVariantModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModel);
	_g_ptr_array_unref0 (self->priv->_items);
	G_OBJECT_CLASS (font_manager_google_fonts_variant_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_variant_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsVariantModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_variant_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsVariantModel), 0, (GInstanceInitFunc) font_manager_google_fonts_variant_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) font_manager_google_fonts_variant_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType font_manager_google_fonts_variant_model_type_id;
	font_manager_google_fonts_variant_model_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerGoogleFontsVariantModel", &g_define_type_info, 0);
	g_type_add_interface_static (font_manager_google_fonts_variant_model_type_id, g_list_model_get_type (), &g_list_model_info);
	FontManagerGoogleFontsVariantModel_private_offset = g_type_add_instance_private (font_manager_google_fonts_variant_model_type_id, sizeof (FontManagerGoogleFontsVariantModelPrivate));
	return font_manager_google_fonts_variant_model_type_id;
}

GType
font_manager_google_fonts_variant_model_get_type (void)
{
	static volatile gsize font_manager_google_fonts_variant_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_variant_model_type_id__once)) {
		GType font_manager_google_fonts_variant_model_type_id;
		font_manager_google_fonts_variant_model_type_id = font_manager_google_fonts_variant_model_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_variant_model_type_id__once, font_manager_google_fonts_variant_model_type_id);
	}
	return font_manager_google_fonts_variant_model_type_id__once;
}

static void
_vala_font_manager_google_fonts_variant_model_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	FontManagerGoogleFontsVariantModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModel);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_ITEMS_PROPERTY:
		g_value_set_boxed (value, font_manager_google_fonts_variant_model_get_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_variant_model_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	FontManagerGoogleFontsVariantModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_VARIANT_MODEL, FontManagerGoogleFontsVariantModel);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_VARIANT_MODEL_ITEMS_PROPERTY:
		font_manager_google_fonts_variant_model_set_items (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_google_fonts_font_list_row_get_instance_private (FontManagerGoogleFontsFontListRow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsFontListRow_private_offset);
}

static void
font_manager_google_fonts_font_list_row_real_reset (FontManagerListItemRow* base)
{
	FontManagerGoogleFontsFontListRow * self;
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkInscription* _tmp4_;
	GtkInscription* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GBinding* _tmp12_;
	GBinding* _tmp16_;
	self = (FontManagerGoogleFontsFontListRow*) base;
	_tmp0_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
	_tmp3_ = _tmp2_;
	g_object_set ((GObject*) _tmp3_, "label", "", "attributes", NULL, NULL, NULL);
	_tmp4_ = font_manager_list_item_row_get_item_preview ((FontManagerListItemRow*) self);
	_tmp5_ = _tmp4_;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
	_tmp6_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp7_ = _tmp6_;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp9_, "");
	if (self->priv->signal_id != ((gulong) 0)) {
		GtkCheckButton* _tmp10_;
		GtkCheckButton* _tmp11_;
		_tmp10_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
		_tmp11_ = _tmp10_;
		g_signal_handler_disconnect (_tmp11_, self->priv->signal_id);
	}
	self->priv->signal_id = (gulong) 0;
	_tmp12_ = self->priv->active;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, G_TYPE_BINDING)) {
		GBinding* _tmp13_;
		GBinding* _tmp14_;
		GBinding* _tmp15_;
		_tmp13_ = self->priv->active;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		g_binding_unbind (_tmp14_);
		_tmp15_ = self->priv->active;
		g_object_unref ((GObject*) _tmp15_);
		_g_object_unref0 (self->priv->active);
		self->priv->active = NULL;
	}
	_tmp16_ = self->priv->inconsistent;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, G_TYPE_BINDING)) {
		GBinding* _tmp17_;
		GBinding* _tmp18_;
		GBinding* _tmp19_;
		_tmp17_ = self->priv->inconsistent;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		g_binding_unbind (_tmp18_);
		_tmp19_ = self->priv->inconsistent;
		g_object_unref ((GObject*) _tmp19_);
		_g_object_unref0 (self->priv->inconsistent);
		self->priv->inconsistent = NULL;
	}
}

static void
__lambda187_ (FontManagerGoogleFontsFontListRow* self)
{
	g_signal_emit (self, font_manager_google_fonts_font_list_row_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda187__gtk_check_button_toggled (GtkCheckButton* _sender,
                                        gpointer self)
{
	__lambda187_ ((FontManagerGoogleFontsFontListRow*) self);
}

static void
font_manager_google_fonts_font_list_row_real_on_item_set (FontManagerListItemRow* base)
{
	FontManagerGoogleFontsFontListRow * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	gboolean root = FALSE;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GBindingFlags flags = 0U;
	GObject* _tmp30_;
	GObject* _tmp31_;
	GtkCheckButton* _tmp32_;
	GtkCheckButton* _tmp33_;
	GBinding* _tmp34_;
	GBinding* _tmp35_;
	GObject* _tmp36_;
	GObject* _tmp37_;
	GtkCheckButton* _tmp38_;
	GtkCheckButton* _tmp39_;
	GBinding* _tmp40_;
	GBinding* _tmp41_;
	GtkCheckButton* _tmp42_;
	GtkCheckButton* _tmp43_;
	gulong _tmp44_;
	self = (FontManagerGoogleFontsFontListRow*) base;
	font_manager_list_item_row_reset ((FontManagerListItemRow*) self);
	_tmp0_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
	_tmp3_ = _tmp2_;
	root = FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY (_tmp3_);
	_tmp4_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
	_tmp5_ = _tmp4_;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, root);
	if (root) {
		gint count = 0;
		GObject* _tmp6_;
		GObject* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* count_label = NULL;
		gchar* _tmp10_;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		GObject* _tmp18_;
		GObject* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp6_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = font_manager_google_fonts_family_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily));
		_tmp9_ = _tmp8_;
		count = _tmp9_;
		_tmp10_ = g_strdup (ngettext ("%i Variation ", "%i Variations", (gulong) count));
		count_label = _tmp10_;
		_tmp11_ = font_manager_list_item_row_get_item_count ((FontManagerListItemRow*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = count_label;
		_tmp14_ = g_strdup_printf (_tmp13_, count);
		_tmp15_ = _tmp14_;
		gtk_label_set_label (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
		_tmp16_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = font_manager_google_fonts_family_get_family (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily));
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (count_label);
	} else {
		FontManagerGoogleFontsFont* font = NULL;
		GObject* _tmp22_;
		GObject* _tmp23_;
		FontManagerGoogleFontsFont* _tmp24_;
		GtkLabel* _tmp25_;
		GtkLabel* _tmp26_;
		FontManagerGoogleFontsFont* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp22_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
		_tmp23_ = _tmp22_;
		_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont));
		font = _tmp24_;
		_tmp25_ = font_manager_list_item_row_get_item_label ((FontManagerListItemRow*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = font;
		_tmp28_ = font_manager_google_fonts_font_to_display_name (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_label_set_text (_tmp26_, _tmp29_);
		_g_free0 (_tmp29_);
		_g_object_unref0 (font);
	}
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp30_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_object_bind_property_with_closures (_tmp31_, "active", (GObject*) _tmp33_, "active", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (self->priv->active);
	self->priv->active = _tmp35_;
	flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
	_tmp36_ = font_manager_list_item_row_get_item ((FontManagerListItemRow*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_object_bind_property_with_closures (_tmp37_, "inconsistent", (GObject*) _tmp39_, "inconsistent", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (self->priv->inconsistent);
	self->priv->inconsistent = _tmp41_;
	_tmp42_ = font_manager_list_item_row_get_item_state ((FontManagerListItemRow*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_signal_connect_object (_tmp43_, "toggled", (GCallback) ___lambda187__gtk_check_button_toggled, self, G_CONNECT_AFTER);
	self->priv->signal_id = _tmp44_;
	return;
}

FontManagerGoogleFontsFontListRow*
font_manager_google_fonts_font_list_row_construct (GType object_type)
{
	FontManagerGoogleFontsFontListRow * self = NULL;
	self = (FontManagerGoogleFontsFontListRow*) font_manager_list_item_row_construct (object_type);
	return self;
}

FontManagerGoogleFontsFontListRow*
font_manager_google_fonts_font_list_row_new (void)
{
	return font_manager_google_fonts_font_list_row_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW);
}

guint
font_manager_google_fonts_font_list_row_get_position (FontManagerGoogleFontsFontListRow* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_position;
	return result;
}

void
font_manager_google_fonts_font_list_row_set_position (FontManagerGoogleFontsFontListRow* self,
                                                      guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_list_row_get_position (self);
	if (old_value != value) {
		self->priv->_position = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_list_row_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_POSITION_PROPERTY]);
	}
}

static void
font_manager_google_fonts_font_list_row_class_init (FontManagerGoogleFontsFontListRowClass * klass,
                                                    gpointer klass_data)
{
	font_manager_google_fonts_font_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsFontListRow_private_offset);
	((FontManagerListItemRowClass *) klass)->reset = (void (*) (FontManagerListItemRow*)) font_manager_google_fonts_font_list_row_real_reset;
	((FontManagerListItemRowClass *) klass)->on_item_set = (void (*) (FontManagerListItemRow*)) font_manager_google_fonts_font_list_row_real_on_item_set;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_font_list_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_font_list_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_font_list_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_POSITION_PROPERTY, font_manager_google_fonts_font_list_row_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_POSITION_PROPERTY] = g_param_spec_uint ("position", "position", "position", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	font_manager_google_fonts_font_list_row_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
font_manager_google_fonts_font_list_row_instance_init (FontManagerGoogleFontsFontListRow * self,
                                                       gpointer klass)
{
	self->priv = font_manager_google_fonts_font_list_row_get_instance_private (self);
	self->priv->_position = (guint) 0;
	self->priv->signal_id = (gulong) 0;
	self->priv->active = NULL;
	self->priv->inconsistent = NULL;
}

static void
font_manager_google_fonts_font_list_row_finalize (GObject * obj)
{
	FontManagerGoogleFontsFontListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRow);
	_g_object_unref0 (self->priv->active);
	_g_object_unref0 (self->priv->inconsistent);
	G_OBJECT_CLASS (font_manager_google_fonts_font_list_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_font_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsFontListRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_font_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsFontListRow), 0, (GInstanceInitFunc) font_manager_google_fonts_font_list_row_instance_init, NULL };
	GType font_manager_google_fonts_font_list_row_type_id;
	font_manager_google_fonts_font_list_row_type_id = g_type_register_static (FONT_MANAGER_TYPE_LIST_ITEM_ROW, "FontManagerGoogleFontsFontListRow", &g_define_type_info, 0);
	FontManagerGoogleFontsFontListRow_private_offset = g_type_add_instance_private (font_manager_google_fonts_font_list_row_type_id, sizeof (FontManagerGoogleFontsFontListRowPrivate));
	return font_manager_google_fonts_font_list_row_type_id;
}

GType
font_manager_google_fonts_font_list_row_get_type (void)
{
	static volatile gsize font_manager_google_fonts_font_list_row_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_font_list_row_type_id__once)) {
		GType font_manager_google_fonts_font_list_row_type_id;
		font_manager_google_fonts_font_list_row_type_id = font_manager_google_fonts_font_list_row_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_font_list_row_type_id__once, font_manager_google_fonts_font_list_row_type_id);
	}
	return font_manager_google_fonts_font_list_row_type_id__once;
}

static void
_vala_font_manager_google_fonts_font_list_row_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	FontManagerGoogleFontsFontListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRow);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_POSITION_PROPERTY:
		g_value_set_uint (value, font_manager_google_fonts_font_list_row_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_font_list_row_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	FontManagerGoogleFontsFontListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRow);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_ROW_POSITION_PROPERTY:
		font_manager_google_fonts_font_list_row_set_position (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_google_fonts_font_list_view_get_instance_private (FontManagerGoogleFontsFontListView* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerGoogleFontsFontListView_private_offset);
}

static gboolean
_font_manager_google_fonts_font_list_view_refilter_gsource_func (gpointer self)
{
	gboolean result;
	result = font_manager_google_fonts_font_list_view_refilter ((FontManagerGoogleFontsFontListView*) self);
	return result;
}

void
font_manager_google_fonts_font_list_view_queue_refilter (FontManagerGoogleFontsFontListView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->search_timeout != ((guint) 0)) {
		g_source_remove (self->priv->search_timeout);
	}
	self->priv->search_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 333, _font_manager_google_fonts_font_list_view_refilter_gsource_func, g_object_ref (self), g_object_unref);
	return;
}

void
font_manager_google_fonts_font_list_view_focus_search_entry (FontManagerGoogleFontsFontListView* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	return;
}

void
font_manager_google_fonts_font_list_view_select_item (FontManagerGoogleFontsFontListView* self,
                                                      guint position)
{
	FontManagerGoogleFontsFontModel* _tmp0_;
	FontManagerGoogleFontsFontModel* _tmp1_;
	GtkListView* _tmp2_;
	GtkListView* _tmp3_;
	GtkSingleSelection* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_google_fonts_font_list_view_get_model (self);
	_tmp1_ = _tmp0_;
	if (g_list_model_get_n_items ((GListModel*) _tmp1_) < ((guint) 1)) {
		return;
	}
	_tmp2_ = self->priv->listview;
	gtk_widget_activate_action ((GtkWidget*) _tmp2_, "list.select-item", "(ubb)", position, FALSE, FALSE, NULL);
	_tmp3_ = self->priv->listview;
	gtk_widget_activate_action ((GtkWidget*) _tmp3_, "list.scroll-to-item", "u", position, NULL);
	_tmp4_ = self->priv->selection;
	gtk_selection_model_selection_changed ((GtkSelectionModel*) _tmp4_, position, (guint) 1);
	return;
}

static void
font_manager_google_fonts_font_list_view_on_expander_activated (FontManagerGoogleFontsFontListView* self,
                                                                GtkExpander* _expander)
{
	gboolean expanded = FALSE;
	GtkExpander* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkTreeListModel* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkExpander* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_expander != NULL);
	_tmp0_ = self->priv->expander;
	_tmp1_ = gtk_expander_get_expanded (_tmp0_);
	_tmp2_ = _tmp1_;
	expanded = _tmp2_;
	_tmp3_ = self->priv->treemodel;
	gtk_tree_list_model_set_autoexpand (_tmp3_, expanded);
	if (expanded) {
		_tmp4_ = _ ("Collapse all");
	} else {
		_tmp4_ = _ ("Expand all");
	}
	_tmp5_ = self->priv->expander;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
	font_manager_google_fonts_font_list_view_queue_update (self, (guint) 0);
	return;
}

static void
_font_manager_google_fonts_font_list_view_on_expander_activated_gtk_expander_activate (GtkExpander* _sender,
                                                                                       gpointer self)
{
	font_manager_google_fonts_font_list_view_on_expander_activated ((FontManagerGoogleFontsFontListView*) self, _sender);
}

static GListModel*
_font_manager_google_fonts_font_model_get_child_model_gtk_tree_list_model_create_model_func (GObject* item,
                                                                                             gpointer self)
{
	GListModel* result;
	result = font_manager_google_fonts_font_model_get_child_model ((FontManagerGoogleFontsFontModel*) self, item);
	return result;
}

static void
_font_manager_google_fonts_font_list_view_on_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                                                      guint position,
                                                                                                      guint n_items,
                                                                                                      gpointer self)
{
	font_manager_google_fonts_font_list_view_on_selection_changed ((FontManagerGoogleFontsFontListView*) self, position, n_items);
}

static void
_font_manager_google_fonts_font_list_view_queue_refilter_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                          gpointer self)
{
	font_manager_google_fonts_font_list_view_queue_refilter ((FontManagerGoogleFontsFontListView*) self);
}

static void
_font_manager_google_fonts_font_list_view_next_match_gtk_search_entry_activate (GtkSearchEntry* _sender,
                                                                                gpointer self)
{
	font_manager_google_fonts_font_list_view_next_match ((FontManagerGoogleFontsFontListView*) self, _sender);
}

static void
_font_manager_google_fonts_font_list_view_next_match_gtk_search_entry_next_match (GtkSearchEntry* _sender,
                                                                                  gpointer self)
{
	font_manager_google_fonts_font_list_view_next_match ((FontManagerGoogleFontsFontListView*) self, _sender);
}

static void
_font_manager_google_fonts_font_list_view_previous_match_gtk_search_entry_previous_match (GtkSearchEntry* _sender,
                                                                                          gpointer self)
{
	font_manager_google_fonts_font_list_view_previous_match ((FontManagerGoogleFontsFontListView*) self, _sender);
}

void
font_manager_google_fonts_font_list_view_on_map (FontManagerGoogleFontsFontListView* self)
{
	FontManagerGoogleFontsFontModel* fontmodel = NULL;
	FontManagerGoogleFontsFontModel* _tmp0_;
	FontManagerGoogleFontsFontModel* _tmp1_;
	GListModel* _tmp2_;
	FontManagerGoogleFontsFontModel* _tmp3_;
	GtkTreeListModel* _tmp4_;
	GtkTreeListModel* _tmp5_;
	GListModel* _tmp6_;
	GtkSingleSelection* _tmp7_;
	GtkListView* _tmp8_;
	GtkSignalListItemFactory* _tmp9_;
	GtkSignalListItemFactory* _tmp10_;
	GtkListView* _tmp11_;
	GtkSingleSelection* _tmp12_;
	GtkSingleSelection* _tmp13_;
	GBindingFlags flags = 0U;
	FontManagerGoogleFontsFontModel* _tmp14_;
	FontManagerGoogleFontsFontModel* _tmp15_;
	FontManagerGoogleFontsFontModel* _tmp16_;
	GtkSearchEntry* _tmp17_;
	GtkSearchEntry* _tmp18_;
	GtkSearchEntry* _tmp19_;
	GtkSearchEntry* _tmp20_;
	g_return_if_fail (self != NULL);
	if (self->priv->initialized) {
		return;
	}
	_tmp0_ = font_manager_google_fonts_font_model_new ();
	fontmodel = _tmp0_;
	_tmp1_ = fontmodel;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = fontmodel;
	_tmp4_ = gtk_tree_list_model_new (_tmp2_, FALSE, FALSE, _font_manager_google_fonts_font_model_get_child_model_gtk_tree_list_model_create_model_func, g_object_ref (_tmp3_), g_object_unref);
	_g_object_unref0 (self->priv->treemodel);
	self->priv->treemodel = _tmp4_;
	_tmp5_ = self->priv->treemodel;
	_tmp6_ = _g_object_ref0 ((GListModel*) _tmp5_);
	_tmp7_ = gtk_single_selection_new (_tmp6_);
	_g_object_unref0 (self->priv->selection);
	self->priv->selection = _tmp7_;
	_tmp8_ = self->priv->listview;
	_tmp9_ = font_manager_google_fonts_font_list_view_get_factory (self);
	_tmp10_ = _tmp9_;
	gtk_list_view_set_factory (_tmp8_, (GtkListItemFactory*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->listview;
	_tmp12_ = self->priv->selection;
	gtk_list_view_set_model (_tmp11_, (GtkSelectionModel*) _tmp12_);
	_tmp13_ = self->priv->selection;
	g_signal_connect_object ((GtkSelectionModel*) _tmp13_, "selection-changed", (GCallback) _font_manager_google_fonts_font_list_view_on_selection_changed_gtk_selection_model_selection_changed, self, 0);
	flags = G_BINDING_SYNC_CREATE;
	_tmp14_ = fontmodel;
	g_object_bind_property_with_closures ((GObject*) self, "filter", (GObject*) _tmp14_, "filter", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp15_ = font_manager_google_fonts_font_list_view_get_model (self);
	_tmp16_ = _tmp15_;
	g_object_bind_property_with_closures ((GObject*) self, "available-families", (GObject*) _tmp16_, "entries", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp17_ = self->priv->search;
	g_signal_connect_object (_tmp17_, "search-changed", (GCallback) _font_manager_google_fonts_font_list_view_queue_refilter_gtk_search_entry_search_changed, self, 0);
	_tmp18_ = self->priv->search;
	g_signal_connect_object (_tmp18_, "activate", (GCallback) _font_manager_google_fonts_font_list_view_next_match_gtk_search_entry_activate, self, 0);
	_tmp19_ = self->priv->search;
	g_signal_connect_object (_tmp19_, "next-match", (GCallback) _font_manager_google_fonts_font_list_view_next_match_gtk_search_entry_next_match, self, 0);
	_tmp20_ = self->priv->search;
	g_signal_connect_object (_tmp20_, "previous-match", (GCallback) _font_manager_google_fonts_font_list_view_previous_match_gtk_search_entry_previous_match, self, 0);
	self->priv->initialized = TRUE;
	_g_object_unref0 (fontmodel);
	return;
}

static void
_font_manager_google_fonts_font_list_view_on_map_gtk_widget_map (GtkWidget* _sender,
                                                                 gpointer self)
{
	font_manager_google_fonts_font_list_view_on_map ((FontManagerGoogleFontsFontListView*) self);
}

void
font_manager_google_fonts_font_list_view_on_unmap (FontManagerGoogleFontsFontListView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->changed) {
		FontManagerApplication* _tmp0_;
		FontManagerApplication* _tmp1_;
		_tmp0_ = font_manager_get_default_application ();
		_tmp1_ = _tmp0_;
		font_manager_application_reload (_tmp1_);
		_g_object_unref0 (_tmp1_);
	}
	return;
}

static void
_font_manager_google_fonts_font_list_view_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                                                     gpointer self)
{
	font_manager_google_fonts_font_list_view_on_unmap ((FontManagerGoogleFontsFontListView*) self);
}

static void
_font_manager_google_fonts_font_list_view_setup_list_row_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                                             GObject* object,
                                                                                             gpointer self)
{
	font_manager_google_fonts_font_list_view_setup_list_row ((FontManagerGoogleFontsFontListView*) self, _sender, object);
}

static void
_font_manager_google_fonts_font_list_view_bind_list_row_gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                                                           GObject* object,
                                                                                           gpointer self)
{
	font_manager_google_fonts_font_list_view_bind_list_row ((FontManagerGoogleFontsFontListView*) self, _sender, object);
}

static GtkSignalListItemFactory*
font_manager_google_fonts_font_list_view_get_factory (FontManagerGoogleFontsFontListView* self)
{
	GtkSignalListItemFactory* factory = NULL;
	GtkSignalListItemFactory* _tmp0_;
	GtkSignalListItemFactory* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	factory = _tmp0_;
	g_signal_connect_object (factory, "setup", (GCallback) _font_manager_google_fonts_font_list_view_setup_list_row_gtk_signal_list_item_factory_setup, self, 0);
	g_signal_connect_object (factory, "bind", (GCallback) _font_manager_google_fonts_font_list_view_bind_list_row_gtk_signal_list_item_factory_bind, self, 0);
	result = factory;
	return result;
}

static void
font_manager_google_fonts_font_list_view_setup_list_row (FontManagerGoogleFontsFontListView* self,
                                                         GtkSignalListItemFactory* factory,
                                                         GObject* item)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	GtkTreeExpander* tree_expander = NULL;
	GtkTreeExpander* _tmp1_;
	FontManagerGoogleFontsFontListRow* row = NULL;
	FontManagerGoogleFontsFontListRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	_tmp1_ = (GtkTreeExpander*) gtk_tree_expander_new ();
	g_object_ref_sink (_tmp1_);
	tree_expander = _tmp1_;
	_tmp2_ = font_manager_google_fonts_font_list_row_new ();
	g_object_ref_sink (_tmp2_);
	row = _tmp2_;
	gtk_widget_set_margin_top ((GtkWidget*) row, 4);
	gtk_widget_set_margin_bottom ((GtkWidget*) row, 4);
	gtk_tree_expander_set_child (tree_expander, (GtkWidget*) row);
	gtk_list_item_set_child (list_item, (GtkWidget*) tree_expander);
	_g_object_unref0 (row);
	_g_object_unref0 (tree_expander);
	_g_object_unref0 (list_item);
	return;
}

static void
__lambda188_ (FontManagerGoogleFontsFontListView* self)
{
	self->priv->changed = TRUE;
}

static void
___lambda188__font_manager_google_fonts_font_list_row_state_changed (FontManagerGoogleFontsFontListRow* _sender,
                                                                     gpointer self)
{
	__lambda188_ ((FontManagerGoogleFontsFontListView*) self);
}

static void
font_manager_google_fonts_font_list_view_bind_list_row (FontManagerGoogleFontsFontListView* self,
                                                        GtkSignalListItemFactory* factory,
                                                        GObject* item)
{
	GtkListItem* list_item = NULL;
	GtkListItem* _tmp0_;
	guint position = 0U;
	GtkTreeListRow* list_row = NULL;
	GtkTreeListModel* _tmp1_;
	GtkTreeListRow* _tmp2_;
	GtkTreeExpander* tree_expander = NULL;
	GtkWidget* _tmp3_;
	GtkTreeExpander* _tmp4_;
	FontManagerGoogleFontsFontListRow* row = NULL;
	GtkWidget* _tmp5_;
	FontManagerGoogleFontsFontListRow* _tmp6_;
	GObject* _item = NULL;
	GObject* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, gtk_list_item_get_type (), GtkListItem));
	list_item = _tmp0_;
	position = gtk_list_item_get_position (list_item);
	_tmp1_ = self->priv->treemodel;
	_tmp2_ = gtk_tree_list_model_get_row (_tmp1_, position);
	list_row = _tmp2_;
	_tmp3_ = gtk_list_item_get_child (list_item);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_tree_expander_get_type (), GtkTreeExpander));
	tree_expander = _tmp4_;
	gtk_widget_set_margin_start ((GtkWidget*) tree_expander, 2);
	gtk_tree_expander_set_list_row (tree_expander, list_row);
	_tmp5_ = gtk_tree_expander_get_child (tree_expander);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_ROW, FontManagerGoogleFontsFontListRow));
	row = _tmp6_;
	_tmp7_ = gtk_tree_list_row_get_item (list_row);
	_item = _tmp7_;
	g_object_set ((GObject*) row, "position", position, "item", _item, NULL, NULL);
	g_signal_connect_object (row, "state-changed", (GCallback) ___lambda188__font_manager_google_fonts_font_list_row_state_changed, self, 0);
	_g_object_unref0 (_item);
	_g_object_unref0 (row);
	_g_object_unref0 (tree_expander);
	_g_object_unref0 (list_row);
	_g_object_unref0 (list_item);
	return;
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		FontManagerGoogleFontsFontListView* self;
		self = _data37_->self;
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static gboolean
__lambda180_ (Block37Data* _data37_)
{
	FontManagerGoogleFontsFontListView* self;
	FontManagerGoogleFontsFontModel* _tmp0_;
	FontManagerGoogleFontsFontModel* _tmp1_;
	GtkSearchEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FontManagerGoogleFontsFontModel* _tmp7_;
	FontManagerGoogleFontsFontModel* _tmp8_;
	gboolean result;
	self = _data37_->self;
	_tmp0_ = font_manager_google_fonts_font_list_view_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->search;
	_tmp3_ = gtk_editable_get_text ((GtkEditable*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	font_manager_google_fonts_font_model_set_search_term (_tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = font_manager_google_fonts_font_list_view_get_model (self);
	_tmp8_ = _tmp7_;
	font_manager_google_fonts_font_model_update_items (_tmp8_);
	font_manager_google_fonts_font_list_view_select_item (self, _data37_->position);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda180__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda180_ (self);
	return result;
}

static void
font_manager_google_fonts_font_list_view_queue_update (FontManagerGoogleFontsFontListView* self,
                                                       guint position)
{
	Block37Data* _data37_;
	g_return_if_fail (self != NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_data37_->position = position;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda180__gsource_func, block37_data_ref (_data37_), block37_data_unref);
	block37_data_unref (_data37_);
	_data37_ = NULL;
	return;
}

static void
font_manager_google_fonts_font_list_view_next_match (FontManagerGoogleFontsFontListView* self,
                                                     GtkSearchEntry* entry)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	font_manager_google_fonts_font_list_view_select_item (self, self->priv->current_selection + 1);
	return;
}

static void
font_manager_google_fonts_font_list_view_previous_match (FontManagerGoogleFontsFontListView* self,
                                                         GtkSearchEntry* entry)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	font_manager_google_fonts_font_list_view_select_item (self, self->priv->current_selection - 1);
	return;
}

static gboolean
font_manager_google_fonts_font_list_view_refilter (FontManagerGoogleFontsFontListView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	font_manager_google_fonts_font_list_view_queue_update (self, (guint) 0);
	self->priv->search_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static void
font_manager_google_fonts_font_list_view_on_selection_changed (FontManagerGoogleFontsFontListView* self,
                                                               guint position,
                                                               guint n_items)
{
	guint i = 0U;
	GtkSingleSelection* _tmp0_;
	GtkSingleSelection* _tmp1_;
	GtkTreeListRow* list_row = NULL;
	GtkTreeListModel* _tmp2_;
	GObject* _tmp3_;
	GObject* item = NULL;
	GtkTreeListRow* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	font_manager_google_fonts_font_list_view_set_selected_item (self, NULL);
	self->priv->current_selection = (guint) 0;
	_tmp0_ = self->priv->selection;
	i = gtk_single_selection_get_selected (_tmp0_);
	self->priv->current_selection = i;
	if (i == GTK_INVALID_LIST_POSITION) {
		return;
	}
	_tmp1_ = self->priv->selection;
	_vala_assert (gtk_selection_model_is_selected ((GtkSelectionModel*) _tmp1_, i), "selection.is_selected(i)");
	_tmp2_ = self->priv->treemodel;
	_tmp3_ = g_list_model_get_item ((GListModel*) _tmp2_, i);
	list_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_tree_list_row_get_type (), GtkTreeListRow);
	_tmp4_ = list_row;
	_tmp5_ = gtk_tree_list_row_get_item (_tmp4_);
	item = _tmp5_;
	_tmp6_ = item;
	font_manager_google_fonts_font_list_view_set_selected_item (self, _tmp6_);
	_tmp7_ = item;
	g_signal_emit (self, font_manager_google_fonts_font_list_view_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTION_CHANGED_SIGNAL], 0, _tmp7_);
	_tmp8_ = g_getenv ("G_MESSAGES_DEBUG");
	if (_tmp8_ != NULL) {
		gchar* description = NULL;
		GObject* _tmp9_;
		GtkListView* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		description = NULL;
		_tmp9_ = self->priv->_selected_item;
		if (FONT_MANAGER_GOOGLE_FONTS_IS_FAMILY (_tmp9_)) {
			GObject* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp10_ = self->priv->_selected_item;
			_tmp11_ = font_manager_google_fonts_family_get_family (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FAMILY, FontManagerGoogleFontsFamily));
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (description);
			description = _tmp13_;
		} else {
			GObject* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			GObject* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp14_ = self->priv->_selected_item;
			_tmp15_ = font_manager_google_fonts_font_get_family (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont));
			_tmp16_ = _tmp15_;
			_tmp17_ = self->priv->_selected_item;
			_tmp18_ = font_manager_google_fonts_font_get_style (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT, FontManagerGoogleFontsFont));
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("%s %s", _tmp16_, _tmp19_);
			_g_free0 (description);
			description = _tmp20_;
		}
		_tmp21_ = self->priv->listview;
		_tmp22_ = gtk_widget_get_name ((GtkWidget*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = description;
		g_debug ("FontList.vala:393: %s::selection_changed : %s", _tmp23_, _tmp24_);
		_g_free0 (description);
	}
	_g_object_unref0 (item);
	_g_object_unref0 (list_row);
	return;
}

FontManagerGoogleFontsFontListView*
font_manager_google_fonts_font_list_view_construct (GType object_type)
{
	FontManagerGoogleFontsFontListView * self = NULL;
	self = (FontManagerGoogleFontsFontListView*) g_object_new (object_type, NULL);
	return self;
}

FontManagerGoogleFontsFontListView*
font_manager_google_fonts_font_list_view_new (void)
{
	return font_manager_google_fonts_font_list_view_construct (FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW);
}

GObject*
font_manager_google_fonts_font_list_view_get_selected_item (FontManagerGoogleFontsFontListView* self)
{
	GObject* result;
	GObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_item;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_list_view_set_selected_item (FontManagerGoogleFontsFontListView* self,
                                                            GObject* value)
{
	GObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_list_view_get_selected_item (self);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_item);
		self->priv->_selected_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTED_ITEM_PROPERTY]);
	}
}

JsonArray*
font_manager_google_fonts_font_list_view_get_available_families (FontManagerGoogleFontsFontListView* self)
{
	JsonArray* result;
	JsonArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_families;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_list_view_set_available_families (FontManagerGoogleFontsFontListView* self,
                                                                 JsonArray* value)
{
	JsonArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_list_view_get_available_families (self);
	if (old_value != value) {
		JsonArray* _tmp0_;
		_tmp0_ = _json_array_ref0 (value);
		_json_array_unref0 (self->priv->_available_families);
		self->priv->_available_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_AVAILABLE_FAMILIES_PROPERTY]);
	}
}

FontManagerFontListFilter*
font_manager_google_fonts_font_list_view_get_filter (FontManagerGoogleFontsFontListView* self)
{
	FontManagerFontListFilter* result;
	FontManagerFontListFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filter;
	result = _tmp0_;
	return result;
}

void
font_manager_google_fonts_font_list_view_set_filter (FontManagerGoogleFontsFontListView* self,
                                                     FontManagerFontListFilter* value)
{
	FontManagerFontListFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_google_fonts_font_list_view_get_filter (self);
	if (old_value != value) {
		FontManagerFontListFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_filter);
		self->priv->_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_FILTER_PROPERTY]);
	}
}

FontManagerGoogleFontsFontModel*
font_manager_google_fonts_font_list_view_get_model (FontManagerGoogleFontsFontListView* self)
{
	FontManagerGoogleFontsFontModel* result;
	GtkTreeListModel* _tmp0_;
	GListModel* _tmp1_;
	GListModel* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->treemodel;
	_tmp1_ = gtk_tree_list_model_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, FontManagerGoogleFontsFontModel);
	return result;
}

static GObject *
font_manager_google_fonts_font_list_view_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerGoogleFontsFontListView * self;
	GtkListView* _tmp0_;
	GtkListView* _tmp1_;
	parent_class = G_OBJECT_CLASS (font_manager_google_fonts_font_list_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView);
	_tmp0_ = self->priv->listview;
	font_manager_widget_set_name ((GtkWidget*) _tmp0_, "FontManagerGoogleFontsFontListView");
	_tmp1_ = self->priv->listview;
	font_manager_widget_set_margin ((GtkWidget*) _tmp1_, 6);
	return obj;
}

static void
font_manager_google_fonts_font_list_view_class_init (FontManagerGoogleFontsFontListViewClass * klass,
                                                     gpointer klass_data)
{
	font_manager_google_fonts_font_list_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerGoogleFontsFontListView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_google_fonts_font_list_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_google_fonts_font_list_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_google_fonts_font_list_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_google_fonts_font_list_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTED_ITEM_PROPERTY, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTED_ITEM_PROPERTY] = g_param_spec_object ("selected-item", "selected-item", "selected-item", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_AVAILABLE_FAMILIES_PROPERTY, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_AVAILABLE_FAMILIES_PROPERTY] = g_param_spec_boxed ("available-families", "available-families", "available-families", json_array_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_FILTER_PROPERTY, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_FILTER_PROPERTY] = g_param_spec_object ("filter", "filter", "filter", FONT_MANAGER_TYPE_FONT_LIST_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_MODEL_PROPERTY, font_manager_google_fonts_font_list_view_properties[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/web/google/ui/google-fonts-font-list-view.ui");
	font_manager_google_fonts_font_list_view_signals[FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_OBJECT);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listview", FALSE, FontManagerGoogleFontsFontListView_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsFontListViewPrivate, listview));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "expander", FALSE, FontManagerGoogleFontsFontListView_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsFontListViewPrivate, expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search", FALSE, FontManagerGoogleFontsFontListView_private_offset + G_STRUCT_OFFSET (FontManagerGoogleFontsFontListViewPrivate, search));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_expander_activated", G_CALLBACK(_font_manager_google_fonts_font_list_view_on_expander_activated_gtk_expander_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_map", G_CALLBACK(_font_manager_google_fonts_font_list_view_on_map_gtk_widget_map));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_unmap", G_CALLBACK(_font_manager_google_fonts_font_list_view_on_unmap_gtk_widget_unmap));
}

static void
font_manager_google_fonts_font_list_view_instance_init (FontManagerGoogleFontsFontListView * self,
                                                        gpointer klass)
{
	self->priv = font_manager_google_fonts_font_list_view_get_instance_private (self);
	self->priv->_selected_item = NULL;
	self->priv->_available_families = NULL;
	self->priv->_filter = NULL;
	self->priv->changed = FALSE;
	self->priv->initialized = FALSE;
	self->priv->current_selection = (guint) 0;
	self->priv->search_timeout = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_google_fonts_font_list_view_finalize (GObject * obj)
{
	FontManagerGoogleFontsFontListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView);
	_g_object_unref0 (self->priv->_selected_item);
	_json_array_unref0 (self->priv->_available_families);
	_g_object_unref0 (self->priv->_filter);
	_g_object_unref0 (self->priv->treemodel);
	_g_object_unref0 (self->priv->selection);
	G_OBJECT_CLASS (font_manager_google_fonts_font_list_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_google_fonts_font_list_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerGoogleFontsFontListViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_google_fonts_font_list_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerGoogleFontsFontListView), 0, (GInstanceInitFunc) font_manager_google_fonts_font_list_view_instance_init, NULL };
	GType font_manager_google_fonts_font_list_view_type_id;
	font_manager_google_fonts_font_list_view_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerGoogleFontsFontListView", &g_define_type_info, 0);
	FontManagerGoogleFontsFontListView_private_offset = g_type_add_instance_private (font_manager_google_fonts_font_list_view_type_id, sizeof (FontManagerGoogleFontsFontListViewPrivate));
	return font_manager_google_fonts_font_list_view_type_id;
}

GType
font_manager_google_fonts_font_list_view_get_type (void)
{
	static volatile gsize font_manager_google_fonts_font_list_view_type_id__once = 0;
	if (g_once_init_enter (&font_manager_google_fonts_font_list_view_type_id__once)) {
		GType font_manager_google_fonts_font_list_view_type_id;
		font_manager_google_fonts_font_list_view_type_id = font_manager_google_fonts_font_list_view_get_type_once ();
		g_once_init_leave (&font_manager_google_fonts_font_list_view_type_id__once, font_manager_google_fonts_font_list_view_type_id);
	}
	return font_manager_google_fonts_font_list_view_type_id__once;
}

static void
_vala_font_manager_google_fonts_font_list_view_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	FontManagerGoogleFontsFontListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTED_ITEM_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_font_list_view_get_selected_item (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_AVAILABLE_FAMILIES_PROPERTY:
		g_value_set_boxed (value, font_manager_google_fonts_font_list_view_get_available_families (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_FILTER_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_font_list_view_get_filter (self));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_google_fonts_font_list_view_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_google_fonts_font_list_view_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	FontManagerGoogleFontsFontListView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_GOOGLE_FONTS_TYPE_FONT_LIST_VIEW, FontManagerGoogleFontsFontListView);
	switch (property_id) {
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_SELECTED_ITEM_PROPERTY:
		font_manager_google_fonts_font_list_view_set_selected_item (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_AVAILABLE_FAMILIES_PROPERTY:
		font_manager_google_fonts_font_list_view_set_available_families (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_GOOGLE_FONTS_FONT_LIST_VIEW_FILTER_PROPERTY:
		font_manager_google_fonts_font_list_view_set_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

