//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/locks/PLockManagerChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/locks/IPCUtils.h"
#include "mozilla/dom/locks/LockManagerChild.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/locks/PLockRequestChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {
namespace locks {


MOZ_IMPLICIT PLockManagerChild::PLockManagerChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PLockManagerChild);
}

PLockManagerChild::~PLockManagerChild()
{
    MOZ_COUNT_DTOR(PLockManagerChild);
}

auto PLockManagerChild::ActorAlloc() -> void
{
    AddRef();
}

auto PLockManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PLockManagerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PLockManagerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PLockManagerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PLockManagerChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PLockManagerChild::ManagedPLockRequestChild(nsTArray<PLockRequestChild*>& aArr) const -> void
{
    mManagedPLockRequestChild.ToArray(aArr);
}

auto PLockManagerChild::ManagedPLockRequestChild() const -> const ManagedContainer<PLockRequestChild>&
{
    return mManagedPLockRequestChild;
}

auto PLockManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PLockRequestMsgStart
    };
    return sIds;
}

auto PLockManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PLockRequestMsgStart:
        return (&(mManagedPLockRequestChild));
    default:
        return nullptr;
    }
}

auto PLockManagerChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PLockManagerChild::OpenPLockRequestEndpoint(PLockRequestChild* aActor) -> ManagedEndpoint<PLockRequestParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PLockRequestChild actor");
        return ManagedEndpoint<PLockRequestParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PLockRequestChild actor");
        return ManagedEndpoint<PLockRequestParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PLockRequestParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PLockManagerChild::BindPLockRequestEndpoint(
        ManagedEndpoint<PLockRequestChild> aEndpoint,
        PLockRequestChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PLockManagerChild::SendQuery(
        mozilla::ipc::ResolveCallback<LockManagerSnapshot>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PLockManager::Msg_Query(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PLockManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PLockManager::Msg_Query", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PLockManager::Reply_Query__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__snapshot = IPC::ReadParam<LockManagerSnapshot>(aReader);
            if (!maybe__snapshot) {
                (aReader)->FatalError("Error deserializing 'LockManagerSnapshot'");
                return MsgValueError;

            }
            auto& snapshot = *maybe__snapshot;
            // Sentinel = 'snapshot'
            if ((!((aReader)->ReadSentinel(258868081)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LockManagerSnapshot'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(snapshot));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PLockManagerChild::SendQuery() -> RefPtr<QueryPromise>
{
    RefPtr<MozPromise<LockManagerSnapshot, ResponseRejectReason, true>::Private> promise__ = new MozPromise<LockManagerSnapshot, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendQuery([promise__](LockManagerSnapshot&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PLockManagerChild::SendPLockRequestConstructor(
        PLockRequestChild* actor,
        const IPCLockRequest& aRequest) -> PLockRequestChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PLockRequestChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PLockRequestChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PLockManager::Msg_PLockRequestConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aRequest);
    // Sentinel = 'aRequest'
    ((&(writer__)))->WriteSentinel(238945099);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PLockManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PLockManager::Msg_PLockRequestConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PLockRequestChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PLockManagerChild::Send__delete__(PLockManagerChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PLockManager::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PLockManagerChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PLockManager::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PLockManagerChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PLockManagerChild::OnMessageReceived(const Message& msg__) -> PLockManagerChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PLockManager::Reply_Query__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PLockManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PLockManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PLockManager::Msg_Query", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PLockManager::Reply_PLockRequestConstructor__ID:
        {
            return MsgProcessed;
        }
    case PLockManager::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PLockManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PLockManagerChild::Result
{
    return MsgNotKnown;
}



} // namespace locks
} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::locks::PLockManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PLockManager'
    (aWriter)->WriteSentinel(481625237);
}

auto ParamTraits<::mozilla::dom::locks::PLockManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PLockManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PLockManager'
    if ((!((aReader)->ReadSentinel(481625237)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PLockManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PLockManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PLockManager)");

        return {};
    }
    return static_cast<::mozilla::dom::locks::PLockManagerChild*>(actor);
}

} // namespace IPC
