/* session.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from session.vala, do not modify */

/* libenchant: Session
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2025 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <sys/types.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_SESSION (enchant_session_get_type ())
#define ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_SESSION, EnchantSession))
#define ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_SESSION, EnchantSessionClass))
#define IS_ENCHANT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_SESSION))
#define IS_ENCHANT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_SESSION))
#define ENCHANT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_SESSION, EnchantSessionClass))

typedef struct _EnchantSession EnchantSession;
typedef struct _EnchantSessionClass EnchantSessionClass;
typedef struct _EnchantSessionPrivate EnchantSessionPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _enchant_pwl_unref0(var) ((var == NULL) ? NULL : (var = (enchant_pwl_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecEnchantSession ParamSpecEnchantSession;

struct _EnchantSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantSessionPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
};

struct _EnchantSessionClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantSession *self);
};

struct _ParamSpecEnchantSession {
	GParamSpec parent_instance;
};

static gpointer enchant_session_parent_class = NULL;

VALA_EXTERN gpointer enchant_session_ref (gpointer instance);
VALA_EXTERN void enchant_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_session (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_enchant_session (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_enchant_session (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_session (const GValue* value);
VALA_EXTERN GType enchant_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantSession, enchant_session_unref)
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
static EnchantSession* enchant_session_new (void);
static EnchantSession* enchant_session_construct (GType object_type);
static void _g_free0_ (gpointer var);
VALA_EXTERN EnchantSession* enchant_session_with_implicit_pwl (const gchar* lang,
                                                   const gchar* pwl);
VALA_EXTERN EnchantSession* enchant_session_with_pwl (const gchar* pwlname,
                                          const gchar* exclname);
VALA_EXTERN gchar* enchant_get_user_config_dir (void);
VALA_EXTERN EnchantPWL* enchant_pwl_new (const gchar* filename);
VALA_EXTERN EnchantPWL* enchant_pwl_construct (GType object_type,
                                   const gchar* filename);
VALA_EXTERN void enchant_session_add (EnchantSession* self,
                          const gchar* word);
VALA_EXTERN void enchant_session_remove (EnchantSession* self,
                             const gchar* word);
VALA_EXTERN gboolean enchant_session_exclude (EnchantSession* self,
                                  const gchar* word);
VALA_EXTERN gint enchant_pwl_check (EnchantPWL* self,
                        const gchar* word_buf,
                        ssize_t len);
VALA_EXTERN gboolean enchant_session_contains (EnchantSession* self,
                                   const gchar* word);
static void enchant_session_finalize (EnchantSession * obj);
static GType enchant_session_get_type_once (void);

static void
_g_free0_ (gpointer var)
{
#line 41 "session.vala"
	var = (g_free (var), NULL);
#line 166 "session.c"
}

static EnchantSession*
enchant_session_construct (GType object_type)
{
	EnchantSession* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
#line 40 "session.vala"
	self = (EnchantSession*) g_type_create_instance (object_type);
#line 41 "session.vala"
	_tmp0_ = g_str_hash;
#line 41 "session.vala"
	_tmp1_ = g_str_equal;
#line 41 "session.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
#line 41 "session.vala"
	_g_hash_table_unref0 (self->session_include);
#line 41 "session.vala"
	self->session_include = _tmp2_;
#line 42 "session.vala"
	_tmp3_ = g_str_hash;
#line 42 "session.vala"
	_tmp4_ = g_str_equal;
#line 42 "session.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
#line 42 "session.vala"
	_g_hash_table_unref0 (self->session_exclude);
#line 42 "session.vala"
	self->session_exclude = _tmp5_;
#line 40 "session.vala"
	return self;
#line 203 "session.c"
}

static EnchantSession*
enchant_session_new (void)
{
#line 40 "session.vala"
	return enchant_session_construct (TYPE_ENCHANT_SESSION);
#line 211 "session.c"
}

EnchantSession*
enchant_session_with_implicit_pwl (const gchar* lang,
                                   const gchar* pwl)
{
	gchar* user_config_dir = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	EnchantSession* _tmp13_;
	EnchantSession* _tmp14_;
	EnchantSession* result;
#line 45 "session.vala"
	g_return_val_if_fail (lang != NULL, NULL);
#line 46 "session.vala"
	if (pwl != NULL) {
#line 238 "session.c"
		EnchantSession* _tmp0_;
#line 47 "session.vala"
		_tmp0_ = enchant_session_with_pwl (pwl, NULL);
#line 47 "session.vala"
		result = _tmp0_;
#line 47 "session.vala"
		return result;
#line 246 "session.c"
	}
#line 49 "session.vala"
	_tmp1_ = enchant_get_user_config_dir ();
#line 49 "session.vala"
	user_config_dir = _tmp1_;
#line 50 "session.vala"
	_tmp2_ = user_config_dir;
#line 50 "session.vala"
	g_mkdir_with_parents (_tmp2_, 0700);
#line 51 "session.vala"
	_tmp3_ = user_config_dir;
#line 51 "session.vala"
	_tmp4_ = g_strdup_printf ("%s.dic", lang);
#line 51 "session.vala"
	_tmp5_ = _tmp4_;
#line 51 "session.vala"
	_tmp6_ = g_build_filename (_tmp3_, _tmp5_, NULL);
#line 51 "session.vala"
	_tmp7_ = _tmp6_;
#line 51 "session.vala"
	_tmp8_ = user_config_dir;
#line 51 "session.vala"
	_tmp9_ = g_strdup_printf ("%s.exc", lang);
#line 51 "session.vala"
	_tmp10_ = _tmp9_;
#line 51 "session.vala"
	_tmp11_ = g_build_filename (_tmp8_, _tmp10_, NULL);
#line 51 "session.vala"
	_tmp12_ = _tmp11_;
#line 51 "session.vala"
	_tmp13_ = enchant_session_with_pwl (_tmp7_, _tmp12_);
#line 51 "session.vala"
	_tmp14_ = _tmp13_;
#line 51 "session.vala"
	_g_free0 (_tmp12_);
#line 51 "session.vala"
	_g_free0 (_tmp10_);
#line 51 "session.vala"
	_g_free0 (_tmp7_);
#line 51 "session.vala"
	_g_free0 (_tmp5_);
#line 51 "session.vala"
	result = _tmp14_;
#line 51 "session.vala"
	_g_free0 (user_config_dir);
#line 51 "session.vala"
	return result;
#line 294 "session.c"
}

EnchantSession*
enchant_session_with_pwl (const gchar* pwlname,
                          const gchar* exclname)
{
	EnchantPWL* pwl = NULL;
	EnchantPWL* _tmp0_;
	EnchantPWL* exclude_pwl = NULL;
	EnchantPWL* _tmp1_;
	EnchantSession* session = NULL;
	EnchantSession* _tmp2_;
	EnchantPWL* _tmp3_;
	EnchantPWL* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	EnchantSession* result;
#line 56 "session.vala"
	g_return_val_if_fail (pwlname != NULL, NULL);
#line 57 "session.vala"
	_tmp0_ = enchant_pwl_new (pwlname);
#line 57 "session.vala"
	pwl = _tmp0_;
#line 58 "session.vala"
	_tmp1_ = enchant_pwl_new (exclname);
#line 58 "session.vala"
	exclude_pwl = _tmp1_;
#line 60 "session.vala"
	_tmp2_ = enchant_session_new ();
#line 60 "session.vala"
	session = _tmp2_;
#line 61 "session.vala"
	_tmp3_ = pwl;
#line 61 "session.vala"
	pwl = NULL;
#line 61 "session.vala"
	_enchant_pwl_unref0 (session->pwl);
#line 61 "session.vala"
	session->pwl = _tmp3_;
#line 62 "session.vala"
	_tmp4_ = exclude_pwl;
#line 62 "session.vala"
	exclude_pwl = NULL;
#line 62 "session.vala"
	_enchant_pwl_unref0 (session->exclude_pwl);
#line 62 "session.vala"
	session->exclude_pwl = _tmp4_;
#line 63 "session.vala"
	_tmp5_ = g_strdup (pwlname);
#line 63 "session.vala"
	_g_free0 (session->personal_filename);
#line 63 "session.vala"
	session->personal_filename = _tmp5_;
#line 64 "session.vala"
	_tmp6_ = g_strdup (exclname);
#line 64 "session.vala"
	_g_free0 (session->exclude_filename);
#line 64 "session.vala"
	session->exclude_filename = _tmp6_;
#line 66 "session.vala"
	result = session;
#line 66 "session.vala"
	_enchant_pwl_unref0 (exclude_pwl);
#line 66 "session.vala"
	_enchant_pwl_unref0 (pwl);
#line 66 "session.vala"
	return result;
#line 362 "session.c"
}

void
enchant_session_add (EnchantSession* self,
                     const gchar* word)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
#line 69 "session.vala"
	g_return_if_fail (self != NULL);
#line 69 "session.vala"
	g_return_if_fail (word != NULL);
#line 70 "session.vala"
	_tmp0_ = self->session_exclude;
#line 70 "session.vala"
	g_hash_table_remove (_tmp0_, word);
#line 71 "session.vala"
	_tmp1_ = self->session_include;
#line 71 "session.vala"
	_tmp2_ = g_strdup (word);
#line 71 "session.vala"
	g_hash_table_add (_tmp1_, _tmp2_);
#line 386 "session.c"
}

void
enchant_session_remove (EnchantSession* self,
                        const gchar* word)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
#line 74 "session.vala"
	g_return_if_fail (self != NULL);
#line 74 "session.vala"
	g_return_if_fail (word != NULL);
#line 75 "session.vala"
	_tmp0_ = self->session_include;
#line 75 "session.vala"
	g_hash_table_remove (_tmp0_, word);
#line 76 "session.vala"
	_tmp1_ = self->session_exclude;
#line 76 "session.vala"
	_tmp2_ = g_strdup (word);
#line 76 "session.vala"
	g_hash_table_add (_tmp1_, _tmp2_);
#line 410 "session.c"
}

gboolean
enchant_session_exclude (EnchantSession* self,
                         const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
#line 79 "session.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 79 "session.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 80 "session.vala"
	_tmp1_ = self->session_include;
#line 80 "session.vala"
	if (!g_hash_table_contains (_tmp1_, word)) {
#line 428 "session.c"
		gboolean _tmp2_ = FALSE;
		GHashTable* _tmp3_;
#line 81 "session.vala"
		_tmp3_ = self->session_exclude;
#line 81 "session.vala"
		if (g_hash_table_contains (_tmp3_, word)) {
#line 81 "session.vala"
			_tmp2_ = TRUE;
#line 437 "session.c"
		} else {
			EnchantPWL* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
#line 82 "session.vala"
			_tmp4_ = self->exclude_pwl;
#line 82 "session.vala"
			_tmp5_ = strlen (word);
#line 82 "session.vala"
			_tmp6_ = _tmp5_;
#line 82 "session.vala"
			_tmp2_ = enchant_pwl_check (_tmp4_, word, (ssize_t) _tmp6_) == 0;
#line 450 "session.c"
		}
#line 81 "session.vala"
		_tmp0_ = _tmp2_;
#line 454 "session.c"
	} else {
#line 80 "session.vala"
		_tmp0_ = FALSE;
#line 458 "session.c"
	}
#line 80 "session.vala"
	result = _tmp0_;
#line 80 "session.vala"
	return result;
#line 464 "session.c"
}

gboolean
enchant_session_contains (EnchantSession* self,
                          const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
#line 85 "session.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 85 "session.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 86 "session.vala"
	_tmp1_ = self->session_include;
#line 86 "session.vala"
	if (g_hash_table_contains (_tmp1_, word)) {
#line 86 "session.vala"
		_tmp0_ = TRUE;
#line 484 "session.c"
	} else {
		gboolean _tmp2_ = FALSE;
		EnchantPWL* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 87 "session.vala"
		_tmp3_ = self->pwl;
#line 87 "session.vala"
		_tmp4_ = strlen (word);
#line 87 "session.vala"
		_tmp5_ = _tmp4_;
#line 87 "session.vala"
		if (enchant_pwl_check (_tmp3_, word, (ssize_t) _tmp5_) == 0) {
#line 498 "session.c"
			EnchantPWL* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 88 "session.vala"
			_tmp6_ = self->exclude_pwl;
#line 88 "session.vala"
			_tmp7_ = strlen (word);
#line 88 "session.vala"
			_tmp8_ = _tmp7_;
#line 88 "session.vala"
			_tmp2_ = enchant_pwl_check (_tmp6_, word, (ssize_t) _tmp8_) != 0;
#line 510 "session.c"
		} else {
#line 87 "session.vala"
			_tmp2_ = FALSE;
#line 514 "session.c"
		}
#line 87 "session.vala"
		_tmp0_ = _tmp2_;
#line 518 "session.c"
	}
#line 86 "session.vala"
	result = _tmp0_;
#line 86 "session.vala"
	return result;
#line 524 "session.c"
}

static void
value_enchant_session_init (GValue* value)
{
#line 31 "session.vala"
	value->data[0].v_pointer = NULL;
#line 532 "session.c"
}

static void
value_enchant_session_free_value (GValue* value)
{
#line 31 "session.vala"
	if (value->data[0].v_pointer) {
#line 31 "session.vala"
		enchant_session_unref (value->data[0].v_pointer);
#line 542 "session.c"
	}
}

static void
value_enchant_session_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 31 "session.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "session.vala"
		dest_value->data[0].v_pointer = enchant_session_ref (src_value->data[0].v_pointer);
#line 554 "session.c"
	} else {
#line 31 "session.vala"
		dest_value->data[0].v_pointer = NULL;
#line 558 "session.c"
	}
}

static gpointer
value_enchant_session_peek_pointer (const GValue* value)
{
#line 31 "session.vala"
	return value->data[0].v_pointer;
#line 567 "session.c"
}

static gchar*
value_enchant_session_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 31 "session.vala"
	if (collect_values[0].v_pointer) {
#line 578 "session.c"
		EnchantSession * object;
		object = collect_values[0].v_pointer;
#line 31 "session.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "session.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 585 "session.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "session.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 589 "session.c"
		}
#line 31 "session.vala"
		value->data[0].v_pointer = enchant_session_ref (object);
#line 593 "session.c"
	} else {
#line 31 "session.vala"
		value->data[0].v_pointer = NULL;
#line 597 "session.c"
	}
#line 31 "session.vala"
	return NULL;
#line 601 "session.c"
}

static gchar*
value_enchant_session_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	EnchantSession ** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "session.vala"
	if (!object_p) {
#line 31 "session.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 616 "session.c"
	}
#line 31 "session.vala"
	if (!value->data[0].v_pointer) {
#line 31 "session.vala"
		*object_p = NULL;
#line 622 "session.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "session.vala"
		*object_p = value->data[0].v_pointer;
#line 626 "session.c"
	} else {
#line 31 "session.vala"
		*object_p = enchant_session_ref (value->data[0].v_pointer);
#line 630 "session.c"
	}
#line 31 "session.vala"
	return NULL;
#line 634 "session.c"
}

GParamSpec*
param_spec_enchant_session (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecEnchantSession* spec;
#line 31 "session.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_SESSION), NULL);
#line 31 "session.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "session.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "session.vala"
	return G_PARAM_SPEC (spec);
#line 653 "session.c"
}

gpointer
value_get_enchant_session (const GValue* value)
{
#line 31 "session.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_SESSION), NULL);
#line 31 "session.vala"
	return value->data[0].v_pointer;
#line 663 "session.c"
}

void
value_set_enchant_session (GValue* value,
                           gpointer v_object)
{
	EnchantSession * old;
#line 31 "session.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_SESSION));
#line 31 "session.vala"
	old = value->data[0].v_pointer;
#line 31 "session.vala"
	if (v_object) {
#line 31 "session.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_SESSION));
#line 31 "session.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "session.vala"
		value->data[0].v_pointer = v_object;
#line 31 "session.vala"
		enchant_session_ref (value->data[0].v_pointer);
#line 685 "session.c"
	} else {
#line 31 "session.vala"
		value->data[0].v_pointer = NULL;
#line 689 "session.c"
	}
#line 31 "session.vala"
	if (old) {
#line 31 "session.vala"
		enchant_session_unref (old);
#line 695 "session.c"
	}
}

void
value_take_enchant_session (GValue* value,
                            gpointer v_object)
{
	EnchantSession * old;
#line 31 "session.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_SESSION));
#line 31 "session.vala"
	old = value->data[0].v_pointer;
#line 31 "session.vala"
	if (v_object) {
#line 31 "session.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_SESSION));
#line 31 "session.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "session.vala"
		value->data[0].v_pointer = v_object;
#line 716 "session.c"
	} else {
#line 31 "session.vala"
		value->data[0].v_pointer = NULL;
#line 720 "session.c"
	}
#line 31 "session.vala"
	if (old) {
#line 31 "session.vala"
		enchant_session_unref (old);
#line 726 "session.c"
	}
}

static void
enchant_session_class_init (EnchantSessionClass * klass,
                            gpointer klass_data)
{
#line 31 "session.vala"
	enchant_session_parent_class = g_type_class_peek_parent (klass);
#line 31 "session.vala"
	((EnchantSessionClass *) klass)->finalize = enchant_session_finalize;
#line 738 "session.c"
}

static void
enchant_session_instance_init (EnchantSession * self,
                               gpointer klass)
{
#line 31 "session.vala"
	self->ref_count = 1;
#line 747 "session.c"
}

static void
enchant_session_finalize (EnchantSession * obj)
{
	EnchantSession * self;
#line 31 "session.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_SESSION, EnchantSession);
#line 31 "session.vala"
	g_signal_handlers_destroy (self);
#line 32 "session.vala"
	_g_hash_table_unref0 (self->session_include);
#line 33 "session.vala"
	_g_hash_table_unref0 (self->session_exclude);
#line 34 "session.vala"
	_enchant_pwl_unref0 (self->pwl);
#line 35 "session.vala"
	_enchant_pwl_unref0 (self->exclude_pwl);
#line 37 "session.vala"
	_g_free0 (self->personal_filename);
#line 38 "session.vala"
	_g_free0 (self->exclude_filename);
#line 770 "session.c"
}

static GType
enchant_session_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_session_init, value_enchant_session_free_value, value_enchant_session_copy_value, value_enchant_session_peek_pointer, "p", value_enchant_session_collect_value, "p", value_enchant_session_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantSession), 0, (GInstanceInitFunc) enchant_session_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_session_type_id;
	enchant_session_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantSession", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_session_type_id;
}

GType
enchant_session_get_type (void)
{
	static volatile gsize enchant_session_type_id__once = 0;
	if (g_once_init_enter (&enchant_session_type_id__once)) {
		GType enchant_session_type_id;
		enchant_session_type_id = enchant_session_get_type_once ();
		g_once_init_leave (&enchant_session_type_id__once, enchant_session_type_id);
	}
	return enchant_session_type_id__once;
}

gpointer
enchant_session_ref (gpointer instance)
{
	EnchantSession * self;
	self = instance;
#line 31 "session.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "session.vala"
	return instance;
#line 805 "session.c"
}

void
enchant_session_unref (gpointer instance)
{
	EnchantSession * self;
	self = instance;
#line 31 "session.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "session.vala"
		ENCHANT_SESSION_GET_CLASS (self)->finalize (self);
#line 31 "session.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 819 "session.c"
	}
}

