/* Generated by wayland-scanner 1.23.0 */

#ifndef XDG_FOREIGN_UNSTABLE_V2_SERVER_PROTOCOL_H
#define XDG_FOREIGN_UNSTABLE_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_xdg_foreign_unstable_v2 The xdg_foreign_unstable_v2 protocol
 * Protocol for exporting xdg surface handles
 *
 * @section page_desc_xdg_foreign_unstable_v2 Description
 *
 * This protocol specifies a way for making it possible to reference a surface
 * of a different client. With such a reference, a client can, by using the
 * interfaces provided by this protocol, manipulate the relationship between
 * its own surfaces and the surface of some other client. For example, stack
 * some of its own surface above the other clients surface.
 *
 * In order for a client A to get a reference of a surface of client B, client
 * B must first export its surface using xdg_exporter.export_toplevel. Upon
 * doing this, client B will receive a handle (a unique string) that it may
 * share with client A in some way (for example D-Bus). After client A has
 * received the handle from client B, it may use xdg_importer.import_toplevel
 * to create a reference to the surface client B just exported. See the
 * corresponding requests for details.
 *
 * A possible use case for this is out-of-process dialogs. For example when a
 * sandboxed client without file system access needs the user to select a file
 * on the file system, given sandbox environment support, it can export its
 * surface, passing the exported surface handle to an unsandboxed process that
 * can show a file browser dialog and stack it above the sandboxed client's
 * surface.
 *
 * Warning! The protocol described in this file is experimental and backward
 * incompatible changes may be made. Backward compatible changes may be added
 * together with the corresponding interface version bump. Backward
 * incompatible changes are done by bumping the version number in the protocol
 * and interface names and resetting the interface version. Once the protocol
 * is to be declared stable, the 'z' prefix and the version number in the
 * protocol and interface names are removed and the interface version number is
 * reset.
 *
 * @section page_ifaces_xdg_foreign_unstable_v2 Interfaces
 * - @subpage page_iface_zxdg_exporter_v2 - interface for exporting surfaces
 * - @subpage page_iface_zxdg_importer_v2 - interface for importing surfaces
 * - @subpage page_iface_zxdg_exported_v2 - an exported surface handle
 * - @subpage page_iface_zxdg_imported_v2 - an imported surface handle
 * @section page_copyright_xdg_foreign_unstable_v2 Copyright
 * <pre>
 *
 * Copyright © 2015-2016 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct zxdg_exported_v2;
struct zxdg_exporter_v2;
struct zxdg_imported_v2;
struct zxdg_importer_v2;

#ifndef ZXDG_EXPORTER_V2_INTERFACE
#define ZXDG_EXPORTER_V2_INTERFACE
/**
 * @page page_iface_zxdg_exporter_v2 zxdg_exporter_v2
 * @section page_iface_zxdg_exporter_v2_desc Description
 *
 * A global interface used for exporting surfaces that can later be imported
 * using xdg_importer.
 * @section page_iface_zxdg_exporter_v2_api API
 * See @ref iface_zxdg_exporter_v2.
 */
/**
 * @defgroup iface_zxdg_exporter_v2 The zxdg_exporter_v2 interface
 *
 * A global interface used for exporting surfaces that can later be imported
 * using xdg_importer.
 */
extern const struct wl_interface zxdg_exporter_v2_interface;
#endif
#ifndef ZXDG_IMPORTER_V2_INTERFACE
#define ZXDG_IMPORTER_V2_INTERFACE
/**
 * @page page_iface_zxdg_importer_v2 zxdg_importer_v2
 * @section page_iface_zxdg_importer_v2_desc Description
 *
 * A global interface used for importing surfaces exported by xdg_exporter.
 * With this interface, a client can create a reference to a surface of
 * another client.
 * @section page_iface_zxdg_importer_v2_api API
 * See @ref iface_zxdg_importer_v2.
 */
/**
 * @defgroup iface_zxdg_importer_v2 The zxdg_importer_v2 interface
 *
 * A global interface used for importing surfaces exported by xdg_exporter.
 * With this interface, a client can create a reference to a surface of
 * another client.
 */
extern const struct wl_interface zxdg_importer_v2_interface;
#endif
#ifndef ZXDG_EXPORTED_V2_INTERFACE
#define ZXDG_EXPORTED_V2_INTERFACE
/**
 * @page page_iface_zxdg_exported_v2 zxdg_exported_v2
 * @section page_iface_zxdg_exported_v2_desc Description
 *
 * An xdg_exported object represents an exported reference to a surface. The
 * exported surface may be referenced as long as the xdg_exported object not
 * destroyed. Destroying the xdg_exported invalidates any relationship the
 * importer may have established using xdg_imported.
 * @section page_iface_zxdg_exported_v2_api API
 * See @ref iface_zxdg_exported_v2.
 */
/**
 * @defgroup iface_zxdg_exported_v2 The zxdg_exported_v2 interface
 *
 * An xdg_exported object represents an exported reference to a surface. The
 * exported surface may be referenced as long as the xdg_exported object not
 * destroyed. Destroying the xdg_exported invalidates any relationship the
 * importer may have established using xdg_imported.
 */
extern const struct wl_interface zxdg_exported_v2_interface;
#endif
#ifndef ZXDG_IMPORTED_V2_INTERFACE
#define ZXDG_IMPORTED_V2_INTERFACE
/**
 * @page page_iface_zxdg_imported_v2 zxdg_imported_v2
 * @section page_iface_zxdg_imported_v2_desc Description
 *
 * An xdg_imported object represents an imported reference to surface exported
 * by some client. A client can use this interface to manipulate
 * relationships between its own surfaces and the imported surface.
 * @section page_iface_zxdg_imported_v2_api API
 * See @ref iface_zxdg_imported_v2.
 */
/**
 * @defgroup iface_zxdg_imported_v2 The zxdg_imported_v2 interface
 *
 * An xdg_imported object represents an imported reference to surface exported
 * by some client. A client can use this interface to manipulate
 * relationships between its own surfaces and the imported surface.
 */
extern const struct wl_interface zxdg_imported_v2_interface;
#endif

#ifndef ZXDG_EXPORTER_V2_ERROR_ENUM
#define ZXDG_EXPORTER_V2_ERROR_ENUM
/**
 * @ingroup iface_zxdg_exporter_v2
 * error values
 *
 * These errors can be emitted in response to invalid xdg_exporter
 * requests.
 */
enum zxdg_exporter_v2_error {
	/**
	 * surface is not an xdg_toplevel
	 */
	ZXDG_EXPORTER_V2_ERROR_INVALID_SURFACE = 0,
};
/**
 * @ingroup iface_zxdg_exporter_v2
 * Validate a zxdg_exporter_v2 error value.
 *
 * @return true on success, false on error.
 * @ref zxdg_exporter_v2_error
 */
static inline bool
zxdg_exporter_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZXDG_EXPORTER_V2_ERROR_INVALID_SURFACE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZXDG_EXPORTER_V2_ERROR_ENUM */

/**
 * @ingroup iface_zxdg_exporter_v2
 * @struct zxdg_exporter_v2_interface
 */
struct zxdg_exporter_v2_interface {
	/**
	 * destroy the xdg_exporter object
	 *
	 * Notify the compositor that the xdg_exporter object will no
	 * longer be used.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * export a toplevel surface
	 *
	 * The export_toplevel request exports the passed surface so that
	 * it can later be imported via xdg_importer. When called, a new
	 * xdg_exported object will be created and xdg_exported.handle will
	 * be sent immediately. See the corresponding interface and event
	 * for details.
	 *
	 * A surface may be exported multiple times, and each exported
	 * handle may be used to create an xdg_imported multiple times.
	 * Only xdg_toplevel equivalent surfaces may be exported, otherwise
	 * an invalid_surface protocol error is sent.
	 * @param id the new xdg_exported object
	 * @param surface the surface to export
	 */
	void (*export_toplevel)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id,
				struct wl_resource *surface);
};


/**
 * @ingroup iface_zxdg_exporter_v2
 */
#define ZXDG_EXPORTER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zxdg_exporter_v2
 */
#define ZXDG_EXPORTER_V2_EXPORT_TOPLEVEL_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_importer_v2
 * @struct zxdg_importer_v2_interface
 */
struct zxdg_importer_v2_interface {
	/**
	 * destroy the xdg_importer object
	 *
	 * Notify the compositor that the xdg_importer object will no
	 * longer be used.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * import a toplevel surface
	 *
	 * The import_toplevel request imports a surface from any client
	 * given a handle retrieved by exporting said surface using
	 * xdg_exporter.export_toplevel. When called, a new xdg_imported
	 * object will be created. This new object represents the imported
	 * surface, and the importing client can manipulate its
	 * relationship using it. See xdg_imported for details.
	 * @param id the new xdg_imported object
	 * @param handle the exported surface handle
	 */
	void (*import_toplevel)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id,
				const char *handle);
};


/**
 * @ingroup iface_zxdg_importer_v2
 */
#define ZXDG_IMPORTER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zxdg_importer_v2
 */
#define ZXDG_IMPORTER_V2_IMPORT_TOPLEVEL_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_exported_v2
 * @struct zxdg_exported_v2_interface
 */
struct zxdg_exported_v2_interface {
	/**
	 * unexport the exported surface
	 *
	 * Revoke the previously exported surface. This invalidates any
	 * relationship the importer may have set up using the xdg_imported
	 * created given the handle sent via xdg_exported.handle.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZXDG_EXPORTED_V2_HANDLE 0

/**
 * @ingroup iface_zxdg_exported_v2
 */
#define ZXDG_EXPORTED_V2_HANDLE_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_exported_v2
 */
#define ZXDG_EXPORTED_V2_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_exported_v2
 * Sends an handle event to the client owning the resource.
 * @param resource_ The client's resource
 * @param handle the exported surface handle
 */
static inline void
zxdg_exported_v2_send_handle(struct wl_resource *resource_, const char *handle)
{
	wl_resource_post_event(resource_, ZXDG_EXPORTED_V2_HANDLE, handle);
}

#ifndef ZXDG_IMPORTED_V2_ERROR_ENUM
#define ZXDG_IMPORTED_V2_ERROR_ENUM
/**
 * @ingroup iface_zxdg_imported_v2
 * error values
 *
 * These errors can be emitted in response to invalid xdg_imported
 * requests.
 */
enum zxdg_imported_v2_error {
	/**
	 * surface is not an xdg_toplevel
	 */
	ZXDG_IMPORTED_V2_ERROR_INVALID_SURFACE = 0,
};
/**
 * @ingroup iface_zxdg_imported_v2
 * Validate a zxdg_imported_v2 error value.
 *
 * @return true on success, false on error.
 * @ref zxdg_imported_v2_error
 */
static inline bool
zxdg_imported_v2_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZXDG_IMPORTED_V2_ERROR_INVALID_SURFACE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZXDG_IMPORTED_V2_ERROR_ENUM */

/**
 * @ingroup iface_zxdg_imported_v2
 * @struct zxdg_imported_v2_interface
 */
struct zxdg_imported_v2_interface {
	/**
	 * destroy the xdg_imported object
	 *
	 * Notify the compositor that it will no longer use the
	 * xdg_imported object. Any relationship that may have been set up
	 * will at this point be invalidated.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set as the parent of some surface
	 *
	 * Set the imported surface as the parent of some surface of the
	 * client. The passed surface must be an xdg_toplevel equivalent,
	 * otherwise an invalid_surface protocol error is sent. Calling
	 * this function sets up a surface to surface relation with the
	 * same stacking and positioning semantics as
	 * xdg_toplevel.set_parent.
	 * @param surface the child surface
	 */
	void (*set_parent_of)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *surface);
};

#define ZXDG_IMPORTED_V2_DESTROYED 0

/**
 * @ingroup iface_zxdg_imported_v2
 */
#define ZXDG_IMPORTED_V2_DESTROYED_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_imported_v2
 */
#define ZXDG_IMPORTED_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zxdg_imported_v2
 */
#define ZXDG_IMPORTED_V2_SET_PARENT_OF_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_imported_v2
 * Sends an destroyed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zxdg_imported_v2_send_destroyed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZXDG_IMPORTED_V2_DESTROYED);
}

#ifdef  __cplusplus
}
#endif

#endif
