/*
 * This file was generated by qdbusxml2cpp-fix version 0.8
 * Command line was: qdbusxml2cpp-fix -c Source -p generated/com_deepin_daemon_audio_source ../xml/com.deepin.daemon.Audio.Source.xml
 *
 * qdbusxml2cpp-fix is Copyright (C) 2016 Deepin Technology Co., Ltd.
 *
 * This is an auto-generated file.
 * This file may have been hand-edited. Look for HAND-EDIT comments
 * before re-generating it.
 */

#include "generated/com_deepin_daemon_audio_source.h"

/*
 * Implementation of interface class __Source
 */

class __SourcePrivate
{
public:
   __SourcePrivate() = default;

    // begin member variables
    AudioPort ActivePort;
    double Balance;
    double BaseVolume;
    uint Card;
    QString Description;
    double Fade;
    bool Mute;
    QString Name;
    AudioPortList Ports;
    bool SupportBalance;
    bool SupportFade;
    double Volume;

public:
    QMap<QString, QDBusPendingCallWatcher *> m_processingCalls;
    QMap<QString, QList<QVariant>> m_waittingCalls;
};

__Source::__Source(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent)
    : DBusExtendedAbstractInterface(service, path, staticInterfaceName(), connection, parent)
    , d_ptr(new __SourcePrivate)
{
    connect(this, &__Source::propertyChanged, this, &__Source::onPropertyChanged);

    if (QMetaType::type("AudioPort") == QMetaType::UnknownType)
        registerAudioPortMetaType();
    if (QMetaType::type("AudioPortList") == QMetaType::UnknownType)
        registerAudioPortListMetaType();
}

__Source::~__Source()
{
    qDeleteAll(d_ptr->m_processingCalls.values());
    delete d_ptr;
}

void __Source::onPropertyChanged(const QString &propName, const QVariant &value)
{
    if (propName == QStringLiteral("ActivePort"))
    {
        const AudioPort &ActivePort = qvariant_cast<AudioPort>(value);
        if (d_ptr->ActivePort != ActivePort)
        {
            d_ptr->ActivePort = ActivePort;
            Q_EMIT ActivePortChanged(d_ptr->ActivePort);
        }
        return;
    }

    if (propName == QStringLiteral("Balance"))
    {
        const double &Balance = qvariant_cast<double>(value);
        if (d_ptr->Balance != Balance)
        {
            d_ptr->Balance = Balance;
            Q_EMIT BalanceChanged(d_ptr->Balance);
        }
        return;
    }

    if (propName == QStringLiteral("BaseVolume"))
    {
        const double &BaseVolume = qvariant_cast<double>(value);
        if (d_ptr->BaseVolume != BaseVolume)
        {
            d_ptr->BaseVolume = BaseVolume;
            Q_EMIT BaseVolumeChanged(d_ptr->BaseVolume);
        }
        return;
    }

    if (propName == QStringLiteral("Card"))
    {
        const uint &Card = qvariant_cast<uint>(value);
        if (d_ptr->Card != Card)
        {
            d_ptr->Card = Card;
            Q_EMIT CardChanged(d_ptr->Card);
        }
        return;
    }

    if (propName == QStringLiteral("Description"))
    {
        const QString &Description = qvariant_cast<QString>(value);
        if (d_ptr->Description != Description)
        {
            d_ptr->Description = Description;
            Q_EMIT DescriptionChanged(d_ptr->Description);
        }
        return;
    }

    if (propName == QStringLiteral("Fade"))
    {
        const double &Fade = qvariant_cast<double>(value);
        if (d_ptr->Fade != Fade)
        {
            d_ptr->Fade = Fade;
            Q_EMIT FadeChanged(d_ptr->Fade);
        }
        return;
    }

    if (propName == QStringLiteral("Mute"))
    {
        const bool &Mute = qvariant_cast<bool>(value);
        if (d_ptr->Mute != Mute)
        {
            d_ptr->Mute = Mute;
            Q_EMIT MuteChanged(d_ptr->Mute);
        }
        return;
    }

    if (propName == QStringLiteral("Name"))
    {
        const QString &Name = qvariant_cast<QString>(value);
        if (d_ptr->Name != Name)
        {
            d_ptr->Name = Name;
            Q_EMIT NameChanged(d_ptr->Name);
        }
        return;
    }

    if (propName == QStringLiteral("Ports"))
    {
        const AudioPortList &Ports = qvariant_cast<AudioPortList>(value);
        if (d_ptr->Ports != Ports)
        {
            d_ptr->Ports = Ports;
            Q_EMIT PortsChanged(d_ptr->Ports);
        }
        return;
    }

    if (propName == QStringLiteral("SupportBalance"))
    {
        const bool &SupportBalance = qvariant_cast<bool>(value);
        if (d_ptr->SupportBalance != SupportBalance)
        {
            d_ptr->SupportBalance = SupportBalance;
            Q_EMIT SupportBalanceChanged(d_ptr->SupportBalance);
        }
        return;
    }

    if (propName == QStringLiteral("SupportFade"))
    {
        const bool &SupportFade = qvariant_cast<bool>(value);
        if (d_ptr->SupportFade != SupportFade)
        {
            d_ptr->SupportFade = SupportFade;
            Q_EMIT SupportFadeChanged(d_ptr->SupportFade);
        }
        return;
    }

    if (propName == QStringLiteral("Volume"))
    {
        const double &Volume = qvariant_cast<double>(value);
        if (d_ptr->Volume != Volume)
        {
            d_ptr->Volume = Volume;
            Q_EMIT VolumeChanged(d_ptr->Volume);
        }
        return;
    }

    qWarning() << "property not handle: " << propName;
    return;
}

AudioPort __Source::activePort()
{
    return qvariant_cast<AudioPort>(internalPropGet("ActivePort", &d_ptr->ActivePort));
}

double __Source::balance()
{
    return qvariant_cast<double>(internalPropGet("Balance", &d_ptr->Balance));
}

double __Source::baseVolume()
{
    return qvariant_cast<double>(internalPropGet("BaseVolume", &d_ptr->BaseVolume));
}

uint __Source::card()
{
    return qvariant_cast<uint>(internalPropGet("Card", &d_ptr->Card));
}

QString __Source::description()
{
    return qvariant_cast<QString>(internalPropGet("Description", &d_ptr->Description));
}

double __Source::fade()
{
    return qvariant_cast<double>(internalPropGet("Fade", &d_ptr->Fade));
}

bool __Source::mute()
{
    return qvariant_cast<bool>(internalPropGet("Mute", &d_ptr->Mute));
}

QString __Source::name()
{
    return qvariant_cast<QString>(internalPropGet("Name", &d_ptr->Name));
}

AudioPortList __Source::ports()
{
    return qvariant_cast<AudioPortList>(internalPropGet("Ports", &d_ptr->Ports));
}

bool __Source::supportBalance()
{
    return qvariant_cast<bool>(internalPropGet("SupportBalance", &d_ptr->SupportBalance));
}

bool __Source::supportFade()
{
    return qvariant_cast<bool>(internalPropGet("SupportFade", &d_ptr->SupportFade));
}

double __Source::volume()
{
    return qvariant_cast<double>(internalPropGet("Volume", &d_ptr->Volume));
}

void __Source::CallQueued(const QString &callName, const QList<QVariant> &args)
{
    if (d_ptr->m_waittingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls[callName] = args;
        return;
    }
    if (d_ptr->m_processingCalls.contains(callName))
    {
        d_ptr->m_waittingCalls.insert(callName, args);
    } else {
        QDBusPendingCallWatcher *watcher = new QDBusPendingCallWatcher(asyncCallWithArgumentList(callName, args));
        connect(watcher, &QDBusPendingCallWatcher::finished, this, &__Source::onPendingCallFinished);
        d_ptr->m_processingCalls.insert(callName, watcher);
    }
}

void __Source::onPendingCallFinished(QDBusPendingCallWatcher *w)
{
    w->deleteLater();
    const auto callName = d_ptr->m_processingCalls.key(w);
    Q_ASSERT(!callName.isEmpty());
    if (callName.isEmpty())
        return;
    d_ptr->m_processingCalls.remove(callName);
    if (!d_ptr->m_waittingCalls.contains(callName))
        return;
    const auto args = d_ptr->m_waittingCalls.take(callName);
    CallQueued(callName, args);
}
