/* Generated by wayland-scanner 1.24.0 */

#ifndef DDE_SHELL_SERVER_PROTOCOL_H
#define DDE_SHELL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dde_shell The dde_shell protocol
 * @section page_ifaces_dde_shell Interfaces
 * - @subpage page_iface_dde_shell - get window info
 * - @subpage page_iface_dde_shell_surface - dde shell surface
 * @section page_copyright_dde_shell Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_shell;
struct dde_shell_surface;
struct wl_output;
struct wl_surface;

#ifndef DDE_SHELL_INTERFACE
#define DDE_SHELL_INTERFACE
/**
 * @page page_iface_dde_shell dde_shell
 * @section page_iface_dde_shell_desc Description
 *
 * Eg: window position.
 * @section page_iface_dde_shell_api API
 * See @ref iface_dde_shell.
 */
/**
 * @defgroup iface_dde_shell The dde_shell interface
 *
 * Eg: window position.
 */
extern const struct wl_interface dde_shell_interface;
#endif
#ifndef DDE_SHELL_SURFACE_INTERFACE
#define DDE_SHELL_SURFACE_INTERFACE
/**
 * @page page_iface_dde_shell_surface dde_shell_surface
 * @section page_iface_dde_shell_surface_desc Description
 *
 *
 * @section page_iface_dde_shell_surface_api API
 * See @ref iface_dde_shell_surface.
 */
/**
 * @defgroup iface_dde_shell_surface The dde_shell_surface interface
 *
 *
 */
extern const struct wl_interface dde_shell_surface_interface;
#endif

#ifndef DDE_SHELL_STATE_ENUM
#define DDE_SHELL_STATE_ENUM
enum dde_shell_state {
	DDE_SHELL_STATE_ACTIVE = 1 << 0,
	DDE_SHELL_STATE_MINIMIZED = 1 << 1,
	DDE_SHELL_STATE_MAXIMIZED = 1 << 2,
	DDE_SHELL_STATE_FULLSCREEN = 1 << 3,
	DDE_SHELL_STATE_KEEP_ABOVE = 1 << 4,
	DDE_SHELL_STATE_KEEP_BELOW = 1 << 5,
	DDE_SHELL_STATE_ON_ALL_DESKTOPS = 1 << 6,
	DDE_SHELL_STATE_DEMANDS_ATTENTION = 1 << 7,
	DDE_SHELL_STATE_CLOSEABLE = 1 << 8,
	DDE_SHELL_STATE_MINIMIZABLE = 1 << 9,
	DDE_SHELL_STATE_MAXIMIZABLE = 1 << 10,
	DDE_SHELL_STATE_FULLSCREENABLE = 1 << 11,
	DDE_SHELL_STATE_SKIPTASKBAR = 1 << 12,
	DDE_SHELL_STATE_SHADEABLE = 1 << 13,
	DDE_SHELL_STATE_SHADED = 1 << 14,
	DDE_SHELL_STATE_MOVABLE = 1 << 15,
	DDE_SHELL_STATE_RESIZABLE = 1 << 16,
	DDE_SHELL_STATE_VIRTUAL_DESKTOP_CHANGEABLE = 1 << 17,
	DDE_SHELL_STATE_SKIPSWITCHER = 1 << 18,
	DDE_SHELL_STATE_ACCEPT_FOCUS = 1 << 19,
	DDE_SHELL_STATE_MODALITY = 1 << 20,
};
#endif /* DDE_SHELL_STATE_ENUM */

#ifndef DDE_SHELL_STATE_ENUM_IS_VALID
#define DDE_SHELL_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell state value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_state
 */
static inline bool
dde_shell_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_STATE_ACTIVE:
		return version >= 1;
	case DDE_SHELL_STATE_MINIMIZED:
		return version >= 1;
	case DDE_SHELL_STATE_MAXIMIZED:
		return version >= 1;
	case DDE_SHELL_STATE_FULLSCREEN:
		return version >= 1;
	case DDE_SHELL_STATE_KEEP_ABOVE:
		return version >= 1;
	case DDE_SHELL_STATE_KEEP_BELOW:
		return version >= 1;
	case DDE_SHELL_STATE_ON_ALL_DESKTOPS:
		return version >= 1;
	case DDE_SHELL_STATE_DEMANDS_ATTENTION:
		return version >= 1;
	case DDE_SHELL_STATE_CLOSEABLE:
		return version >= 1;
	case DDE_SHELL_STATE_MINIMIZABLE:
		return version >= 1;
	case DDE_SHELL_STATE_MAXIMIZABLE:
		return version >= 1;
	case DDE_SHELL_STATE_FULLSCREENABLE:
		return version >= 1;
	case DDE_SHELL_STATE_SKIPTASKBAR:
		return version >= 1;
	case DDE_SHELL_STATE_SHADEABLE:
		return version >= 1;
	case DDE_SHELL_STATE_SHADED:
		return version >= 1;
	case DDE_SHELL_STATE_MOVABLE:
		return version >= 1;
	case DDE_SHELL_STATE_RESIZABLE:
		return version >= 1;
	case DDE_SHELL_STATE_VIRTUAL_DESKTOP_CHANGEABLE:
		return version >= 1;
	case DDE_SHELL_STATE_SKIPSWITCHER:
		return version >= 1;
	case DDE_SHELL_STATE_ACCEPT_FOCUS:
		return version >= 1;
	case DDE_SHELL_STATE_MODALITY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_STATE_ENUM_IS_VALID */

#ifndef DDE_SHELL_PROPERTY_ENUM
#define DDE_SHELL_PROPERTY_ENUM
enum dde_shell_property {
	DDE_SHELL_PROPERTY_NOTITLEBAR = 1 << 0,
	DDE_SHELL_PROPERTY_THEME = 1 << 1,
	DDE_SHELL_PROPERTY_WINDOWRADIUS = 1 << 2,
	DDE_SHELL_PROPERTY_BORDERWIDTH = 1 << 3,
	DDE_SHELL_PROPERTY_BORDERCOLOR = 1 << 4,
	DDE_SHELL_PROPERTY_SHADOWRADIUS = 1 << 5,
	DDE_SHELL_PROPERTY_SHADOWOFFSET = 1 << 6,
	DDE_SHELL_PROPERTY_SHADOWCOLOR = 1 << 7,
	DDE_SHELL_PROPERTY_MOUSEINPUTAREAMARGINS = 1 << 8,
	DDE_SHELL_PROPERTY_WINDOWPIXELRATIO = 1 << 9,
};
#endif /* DDE_SHELL_PROPERTY_ENUM */

#ifndef DDE_SHELL_PROPERTY_ENUM_IS_VALID
#define DDE_SHELL_PROPERTY_ENUM_IS_VALID
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell property value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_property
 */
static inline bool
dde_shell_property_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_PROPERTY_NOTITLEBAR:
		return version >= 1;
	case DDE_SHELL_PROPERTY_THEME:
		return version >= 1;
	case DDE_SHELL_PROPERTY_WINDOWRADIUS:
		return version >= 1;
	case DDE_SHELL_PROPERTY_BORDERWIDTH:
		return version >= 1;
	case DDE_SHELL_PROPERTY_BORDERCOLOR:
		return version >= 1;
	case DDE_SHELL_PROPERTY_SHADOWRADIUS:
		return version >= 1;
	case DDE_SHELL_PROPERTY_SHADOWOFFSET:
		return version >= 1;
	case DDE_SHELL_PROPERTY_SHADOWCOLOR:
		return version >= 1;
	case DDE_SHELL_PROPERTY_MOUSEINPUTAREAMARGINS:
		return version >= 1;
	case DDE_SHELL_PROPERTY_WINDOWPIXELRATIO:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_PROPERTY_ENUM_IS_VALID */

#ifndef DDE_SHELL_SPLIT_TYPE_ENUM
#define DDE_SHELL_SPLIT_TYPE_ENUM
enum dde_shell_split_type {
	DDE_SHELL_SPLIT_TYPE_LEFT_SPLIT = 1 << 0,
	DDE_SHELL_SPLIT_TYPE_RIGHT_SPLIT = 1 << 1,
};
#endif /* DDE_SHELL_SPLIT_TYPE_ENUM */

#ifndef DDE_SHELL_SPLIT_TYPE_ENUM_IS_VALID
#define DDE_SHELL_SPLIT_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell split_type value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_split_type
 */
static inline bool
dde_shell_split_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_SPLIT_TYPE_LEFT_SPLIT:
		return version >= 1;
	case DDE_SHELL_SPLIT_TYPE_RIGHT_SPLIT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_SPLIT_TYPE_ENUM_IS_VALID */

#ifndef DDE_SHELL_EFFECTSCENE_ENUM
#define DDE_SHELL_EFFECTSCENE_ENUM
enum dde_shell_effectscene {
	DDE_SHELL_EFFECTSCENE_EFFECTNORADIUS = 1 << 0,
	DDE_SHELL_EFFECTSCENE_EFFECTNOSHADOW = 1 << 1,
	DDE_SHELL_EFFECTSCENE_EFFECTNOBORDER = 1 << 2,
	DDE_SHELL_EFFECTSCENE_EFFECTNOSTART = 1 << 4,
	DDE_SHELL_EFFECTSCENE_EFFECTNOCLOSE = 1 << 5,
	DDE_SHELL_EFFECTSCENE_EFFECTNOMAXIMIZE = 1 << 6,
	DDE_SHELL_EFFECTSCENE_EFFECTNOMINIMIZE = 1 << 7,
};
#endif /* DDE_SHELL_EFFECTSCENE_ENUM */

#ifndef DDE_SHELL_EFFECTSCENE_ENUM_IS_VALID
#define DDE_SHELL_EFFECTSCENE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell effectscene value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_effectscene
 */
static inline bool
dde_shell_effectscene_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_EFFECTSCENE_EFFECTNORADIUS:
		return version >= 1;
	case DDE_SHELL_EFFECTSCENE_EFFECTNOSHADOW:
		return version >= 1;
	case DDE_SHELL_EFFECTSCENE_EFFECTNOBORDER:
		return version >= 1;
	case DDE_SHELL_EFFECTSCENE_EFFECTNOSTART:
		return version >= 1;
	case DDE_SHELL_EFFECTSCENE_EFFECTNOCLOSE:
		return version >= 1;
	case DDE_SHELL_EFFECTSCENE_EFFECTNOMAXIMIZE:
		return version >= 1;
	case DDE_SHELL_EFFECTSCENE_EFFECTNOMINIMIZE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_EFFECTSCENE_ENUM_IS_VALID */

#ifndef DDE_SHELL_EFFECTTYPE_ENUM
#define DDE_SHELL_EFFECTTYPE_ENUM
enum dde_shell_effecttype {
	DDE_SHELL_EFFECTTYPE_EFFECTNORMAL = 1 << 0,
	DDE_SHELL_EFFECTTYPE_EFFECTCURSOR = 1 << 1,
	DDE_SHELL_EFFECTTYPE_EFFECTTOP = 1 << 2,
	DDE_SHELL_EFFECTTYPE_EFFECTBOTTOM = 1 << 3,
};
#endif /* DDE_SHELL_EFFECTTYPE_ENUM */

#ifndef DDE_SHELL_EFFECTTYPE_ENUM_IS_VALID
#define DDE_SHELL_EFFECTTYPE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_shell
 * Validate a dde_shell effecttype value.
 *
 * @return true on success, false on error.
 * @ref dde_shell_effecttype
 */
static inline bool
dde_shell_effecttype_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_SHELL_EFFECTTYPE_EFFECTNORMAL:
		return version >= 1;
	case DDE_SHELL_EFFECTTYPE_EFFECTCURSOR:
		return version >= 1;
	case DDE_SHELL_EFFECTTYPE_EFFECTTOP:
		return version >= 1;
	case DDE_SHELL_EFFECTTYPE_EFFECTBOTTOM:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_SHELL_EFFECTTYPE_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_shell
 * @struct dde_shell_interface
 */
struct dde_shell_interface {
	/**
	 * get a dde shell surface bind to a wayland surface
	 *
	 * 
	 */
	void (*get_shell_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t id,
				  struct wl_resource *surface);
};


/**
 * @ingroup iface_dde_shell
 */
#define DDE_SHELL_GET_SHELL_SURFACE_SINCE_VERSION 1

/**
 * @ingroup iface_dde_shell_surface
 * @struct dde_shell_surface_interface
 */
struct dde_shell_surface_interface {
	/**
	 * request get the window geometry
	 *
	 * reques windo geometry, will notify by "geometry" event.
	 */
	void (*get_geometry)(struct wl_client *client,
			     struct wl_resource *resource);
	/**
	 * request to activate shell
	 *
	 * request to activate current shell if it's not active
	 */
	void (*request_active)(struct wl_client *client,
			       struct wl_resource *resource);
	/**
	 * set window state
	 *
	 * Set window state.
	 *
	 * Values for state argument are described by dde_shell.state and
	 * can be used together in a bitfield. The flags bitfield describes
	 * which flags are supposed to be set, the state bitfield the value
	 * for the set flags
	 * @param flags bitfield of set state flags
	 * @param state bitfield of state flags
	 */
	void (*set_state)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t flags,
			  uint32_t state);
	/**
	 * set window property
	 *
	 * Set window property.
	 *
	 * Values for property argument are described by dde_shell.property
	 * and can be used together in a bitfield. The flags bitfield
	 * describes which property are supposed to be set.
	 * @param property property type
	 * @param dataArr property value
	 * @since 2
	 */
	void (*set_property)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t property,
			     struct wl_array *dataArr);
	/**
	 * request split window
	 *
	 * Request split window.
	 */
	void (*request_split_window)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t split_type);
	/**
	 * custom window effect
	 *
	 * custom window effect.
	 * @since 2
	 */
	void (*request_window_effect)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t effectscene);
	/**
	 * custom window start up effect
	 *
	 * custom window start up effect.
	 * @since 2
	 */
	void (*request_window_startup_effect)(struct wl_client *client,
					      struct wl_resource *resource,
					      uint32_t effecttype);
};

#define DDE_SHELL_SURFACE_GEOMETRY 0
#define DDE_SHELL_SURFACE_STATE_CHANGED 1
#define DDE_SHELL_SURFACE_SPLITABLE 2
#define DDE_SHELL_SURFACE_WORKAREA 3

/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_STATE_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SPLITABLE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_WORKAREA_SINCE_VERSION 2

/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_GET_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_REQUEST_ACTIVE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SET_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_SET_PROPERTY_SINCE_VERSION 2
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_REQUEST_SPLIT_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_REQUEST_WINDOW_EFFECT_SINCE_VERSION 2
/**
 * @ingroup iface_dde_shell_surface
 */
#define DDE_SHELL_SURFACE_REQUEST_WINDOW_STARTUP_EFFECT_SINCE_VERSION 2

/**
 * @ingroup iface_dde_shell_surface
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x pos
 * @param y y pos
 * @param w width
 * @param h height
 */
static inline void
dde_shell_surface_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, uint32_t w, uint32_t h)
{
	wl_resource_post_event(resource_, DDE_SHELL_SURFACE_GEOMETRY, x, y, w, h);
}

/**
 * @ingroup iface_dde_shell_surface
 * Sends an state_changed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags bitfield of state flags
 */
static inline void
dde_shell_surface_send_state_changed(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, DDE_SHELL_SURFACE_STATE_CHANGED, flags);
}

/**
 * @ingroup iface_dde_shell_surface
 * Sends an splitable event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags splitable value
 */
static inline void
dde_shell_surface_send_splitable(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, DDE_SHELL_SURFACE_SPLITABLE, flags);
}

/**
 * @ingroup iface_dde_shell_surface
 * Sends an workarea event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output output
 * @param x x
 * @param y y
 * @param width width
 * @param height height
 */
static inline void
dde_shell_surface_send_workarea(struct wl_resource *resource_, struct wl_resource *output, uint32_t x, uint32_t y, uint32_t width, uint32_t height)
{
	wl_resource_post_event(resource_, DDE_SHELL_SURFACE_WORKAREA, output, x, y, width, height);
}

#ifdef  __cplusplus
}
#endif

#endif
